/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coordination.ZKSplitLogManagerCoordination;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.master.TestSplitLogManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestDLS {
    private static final Logger LOG = LoggerFactory.getLogger(TestSplitLogManager.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final int NUM_MASTERS = 2;
    private static final int NUM_RS = 5;
    private static byte[] COLUMN_FAMILY = Bytes.toBytes((String)"family");
    @Rule
    public TestName testName = new TestName();
    private TableName tableName;
    private SingleProcessHBaseCluster cluster;
    private HMaster master;
    private Configuration conf;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.startMiniDFSCluster(3);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    protected abstract String getWalProvider();

    private void startCluster(final int numRS) throws Exception {
        SplitLogCounters.resetCounters();
        LOG.info("Starting cluster");
        this.conf.setLong("hbase.splitlog.max.resubmit", 0L);
        this.conf.setInt("zookeeper.recovery.retry", 0);
        this.conf.setInt("hbase.regionserver.info.port", -1);
        this.conf.setFloat("hbase.regions.slop", 100.0f);
        this.conf.setInt("hbase.regionserver.wal.max.splitters", 3);
        this.conf.setInt("hbase.regionserver.metahandler.count", 10);
        this.conf.set("hbase.wal.provider", this.getWalProvider());
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(2).numRegionServers(numRS).build();
        TEST_UTIL.startMiniHBaseCluster(option);
        this.cluster = TEST_UTIL.getHBaseCluster();
        LOG.info("Waiting for active/ready master");
        this.cluster.waitForActiveAndReadyMaster();
        this.master = this.cluster.getMaster();
        TEST_UTIL.waitFor(120000L, 200L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return AbstractTestDLS.this.cluster.getLiveRegionServerThreads().size() >= numRS;
            }
        });
    }

    @Before
    public void before() throws Exception {
        this.conf = TEST_UTIL.getConfiguration();
        this.tableName = TableName.valueOf((String)this.testName.getMethodName());
    }

    @After
    public void after() throws Exception {
        TEST_UTIL.shutdownMiniHBaseCluster();
        TEST_UTIL.getTestFileSystem().delete(CommonFSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), true);
        ZKUtil.deleteNodeRecursively((ZKWatcher)TEST_UTIL.getZooKeeperWatcher(), (String)"/hbase");
    }

    @Test
    public void testMasterStartsUpWithLogSplittingWork() throws Exception {
        this.conf.setInt("hbase.master.wait.on.regionservers.mintostart", 4);
        this.startCluster(5);
        final int numRegionsToCreate = 40;
        int numLogLines = 1000;
        this.master.balanceSwitch(false);
        try (Table ht = this.installTable(numRegionsToCreate);){
            HRegionServer hrs = this.findRSToKill(false);
            List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            this.makeWAL(hrs, regions, numLogLines, 100);
            this.abortMaster(this.cluster);
            LOG.info("Aborting region server: " + hrs.getServerName());
            hrs.abort("testing");
            TEST_UTIL.waitFor(120000L, 200L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return AbstractTestDLS.this.cluster.getLiveRegionServerThreads().size() <= 4;
                }
            });
            Thread.sleep(2000L);
            LOG.info("Current Open Regions:" + HBaseTestingUtil.getAllOnlineRegions(this.cluster).size());
            TEST_UTIL.waitFor(120000L, 200L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return HBaseTestingUtil.getAllOnlineRegions(AbstractTestDLS.this.cluster).size() >= numRegionsToCreate + 1;
                }
            });
            LOG.info("Current Open Regions After Master Node Starts Up:" + HBaseTestingUtil.getAllOnlineRegions(this.cluster).size());
            Assert.assertEquals((long)numLogLines, (long)HBaseTestingUtil.countRows(ht));
        }
    }

    @Test
    public void testThreeRSAbort() throws Exception {
        LOG.info("testThreeRSAbort");
        int numRegionsToCreate = 40;
        int numRowsPerRegion = 100;
        this.startCluster(5);
        try (Table table = this.installTable(numRegionsToCreate);){
            int rows;
            this.populateDataInTable(numRowsPerRegion);
            List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
            Assert.assertEquals((long)5L, (long)rsts.size());
            this.cluster.killRegionServer(rsts.get(0).getRegionServer().getServerName());
            this.cluster.killRegionServer(rsts.get(1).getRegionServer().getServerName());
            this.cluster.killRegionServer(rsts.get(2).getRegionServer().getServerName());
            TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return AbstractTestDLS.this.cluster.getLiveRegionServerThreads().size() <= 2;
                }

                public String explainFailure() throws Exception {
                    return "Timed out waiting for server aborts.";
                }
            });
            TEST_UTIL.waitUntilAllRegionsAssigned(this.tableName);
            try {
                rows = HBaseTestingUtil.countRows(table);
            }
            catch (Exception e) {
                Threads.printThreadInfo((PrintStream)System.out, (String)"Thread dump before fail");
                throw e;
            }
            Assert.assertEquals((long)(numRegionsToCreate * numRowsPerRegion), (long)rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelayedDeleteOnFailure() throws Exception {
        if (!this.conf.getBoolean("hbase.split.wal.zk.coordinated", false)) {
            return;
        }
        LOG.info("testDelayedDeleteOnFailure");
        this.startCluster(1);
        final SplitLogManager slm = this.master.getMasterWalManager().getSplitLogManager();
        final FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        Path rootLogDir = new Path(CommonFSUtils.getWALRootDir((Configuration)this.conf), "WALs");
        final Path logDir = new Path(rootLogDir, ServerName.valueOf((String)"x", (int)1, (long)1L).toString());
        fs.mkdirs(logDir);
        ExecutorService executor = null;
        try {
            final Path corruptedLogFile = new Path(logDir, "x");
            FSDataOutputStream out = fs.create(corruptedLogFile);
            out.write(0);
            out.write(Bytes.toBytes((String)"corrupted bytes"));
            out.close();
            ZKSplitLogManagerCoordination coordination = (ZKSplitLogManagerCoordination)this.master.getCoordinatedStateManager().getSplitLogManagerCoordination();
            coordination.setIgnoreDeleteForTesting(true);
            executor = Executors.newSingleThreadExecutor();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        slm.splitLogDistributed(logDir);
                    }
                    catch (IOException ioe) {
                        try {
                            Assert.assertTrue((boolean)fs.exists(corruptedLogFile));
                            slm.splitLogDistributed(logDir);
                        }
                        catch (IOException e) {
                            Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
                            return;
                        }
                        Assert.fail((String)"did not get the expected IOException from the 2nd call");
                    }
                    Assert.fail((String)"did not get the expected IOException from the 1st call");
                }
            };
            Future<?> result = executor.submit(runnable);
            try {
                result.get(2000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            this.waitForCounter(SplitLogCounters.tot_mgr_wait_for_zk_delete, 0L, 1L, 10000L);
            executor.shutdownNow();
            executor = null;
            result.get();
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
            fs.delete(logDir, true);
        }
    }

    private Table installTable(int nrs) throws Exception {
        return this.installTable(nrs, 0);
    }

    private Table installTable(int nrs, int existingRegions) throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        LOG.info("Creating table with " + nrs + " regions");
        Table table = TEST_UTIL.createMultiRegionTable(this.tableName, family, nrs);
        int numRegions = -1;
        RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(this.tableName);
        Object object = null;
        try {
            numRegions = r.getStartKeys().length;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (r != null) {
                if (object != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    r.close();
                }
            }
        }
        Assert.assertEquals((long)nrs, (long)numRegions);
        LOG.info("Waiting for no more RIT\n");
        this.blockUntilNoRIT();
        Assert.assertTrue((boolean)TEST_UTIL.getAdmin().isTableEnabled(this.tableName));
        LOG.debug("Disabling table\n");
        TEST_UTIL.getAdmin().disableTable(this.tableName);
        LOG.debug("Waiting for no more RIT\n");
        this.blockUntilNoRIT();
        NavigableSet<String> regions = HBaseTestingUtil.getAllOnlineRegions(this.cluster);
        LOG.debug("Verifying only catalog region is assigned\n");
        if (regions.size() != 1) {
            for (String oregion : regions) {
                LOG.debug("Region still online: " + oregion);
            }
        }
        Assert.assertEquals((long)(1 + existingRegions), (long)regions.size());
        LOG.debug("Enabling table\n");
        TEST_UTIL.getAdmin().enableTable(this.tableName);
        LOG.debug("Waiting for no more RIT\n");
        this.blockUntilNoRIT();
        LOG.debug("Verifying there are " + numRegions + " assigned on cluster\n");
        regions = HBaseTestingUtil.getAllOnlineRegions(this.cluster);
        Assert.assertEquals((long)(numRegions + 1 + existingRegions), (long)regions.size());
        return table;
    }

    void populateDataInTable(int nrows) throws Exception {
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)5L, (long)rsts.size());
        for (JVMClusterUtil.RegionServerThread rst : rsts) {
            HRegionServer hrs = rst.getRegionServer();
            List hris = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (RegionInfo hri : hris) {
                if (hri.getTable().isSystemTable()) continue;
                LOG.debug("adding data to rs = " + rst.getName() + " region = " + hri.getRegionNameAsString());
                HRegion region = hrs.getOnlineRegion(hri.getRegionName());
                Assert.assertTrue((region != null ? 1 : 0) != 0);
                this.putData((Region)region, hri.getStartKey(), nrows, Bytes.toBytes((String)"q"), new byte[][]{COLUMN_FAMILY});
            }
        }
    }

    public void makeWAL(HRegionServer hrs, List<RegionInfo> regions, int num_edits, int edit_size) throws IOException {
        this.makeWAL(hrs, regions, num_edits, edit_size, true);
    }

    public void makeWAL(HRegionServer hrs, List<RegionInfo> regions, int numEdits, int editSize, boolean cleanShutdown) throws IOException {
        WAL log;
        regions.remove(RegionInfoBuilder.FIRST_META_REGIONINFO);
        Iterator<RegionInfo> iter = regions.iterator();
        while (iter.hasNext()) {
            RegionInfo regionInfo = iter.next();
            if (!regionInfo.getTable().isSystemTable()) continue;
            iter.remove();
        }
        byte[] value = new byte[editSize];
        ArrayList<RegionInfo> hris = new ArrayList<RegionInfo>();
        for (RegionInfo region : regions) {
            if (region.getTable() != this.tableName) continue;
            hris.add(region);
        }
        LOG.info("Creating wal edits across " + hris.size() + " regions.");
        for (int i = 0; i < editSize; ++i) {
            value[i] = (byte)(97 + i % 26);
        }
        int n = hris.size();
        int[] counts = new int[n];
        int syncEvery = 30720 / editSize;
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        if (n > 0) {
            for (int i = 0; i < numEdits; ++i) {
                WALEdit e = new WALEdit();
                RegionInfo curRegionInfo = (RegionInfo)hris.get(i % n);
                WAL log2 = hrs.getWAL(curRegionInfo);
                byte[] startRow = curRegionInfo.getStartKey();
                if (startRow == null || startRow.length == 0) {
                    startRow = new byte[]{0, 0, 0, 0, 1};
                }
                byte[] row = Bytes.incrementBytes((byte[])startRow, (long)counts[i % n]);
                row = Arrays.copyOfRange(row, 3, 8);
                byte[] qualifier = Bytes.toBytes((String)("c" + Integer.toString(i)));
                e.add((Cell)new KeyValue(row, COLUMN_FAMILY, qualifier, EnvironmentEdgeManager.currentTime(), value));
                log2.appendData(curRegionInfo, new WALKeyImpl(curRegionInfo.getEncodedNameAsBytes(), this.tableName, EnvironmentEdgeManager.currentTime(), mvcc), e);
                if (0 == i % syncEvery) {
                    log2.sync();
                }
                int n2 = i % n;
                counts[n2] = counts[n2] + 1;
            }
        }
        for (RegionInfo info : hris) {
            log = hrs.getWAL(info);
            log.sync();
        }
        if (cleanShutdown) {
            for (RegionInfo info : hris) {
                log = hrs.getWAL(info);
                log.shutdown();
            }
        }
        for (int i = 0; i < n; ++i) {
            LOG.info("region " + ((RegionInfo)hris.get(i)).getRegionNameAsString() + " has " + counts[i] + " edits");
        }
    }

    private void blockUntilNoRIT() throws Exception {
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
    }

    private void putData(Region region, byte[] startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            Put put = new Put(Bytes.add((byte[])startRow, (byte[])Bytes.toBytes((int)i)));
            for (byte[] family : families) {
                put.addColumn(family, qf, null);
            }
            region.put(put);
        }
    }

    private void waitForCounter(LongAdder ctr, long oldval, long newval, long timems) throws InterruptedException {
        long curt = EnvironmentEdgeManager.currentTime();
        long endt = curt + timems;
        while (curt < endt) {
            if (ctr.sum() == oldval) {
                Thread.sleep(100L);
                curt = EnvironmentEdgeManager.currentTime();
                continue;
            }
            Assert.assertEquals((long)newval, (long)ctr.sum());
            return;
        }
        Assert.fail();
    }

    private void abortMaster(SingleProcessHBaseCluster cluster) throws InterruptedException {
        for (JVMClusterUtil.MasterThread mt : cluster.getLiveMasterThreads()) {
            if (!mt.getMaster().isActiveMaster()) continue;
            mt.getMaster().abort("Aborting for tests", (Throwable)new Exception("Trace info"));
            mt.join();
            break;
        }
        LOG.debug("Master is aborted");
    }

    private HRegionServer findRSToKill(boolean hasMetaRegion) throws Exception {
        List<JVMClusterUtil.RegionServerThread> rsts = this.cluster.getLiveRegionServerThreads();
        List regions = null;
        HRegionServer hrs = null;
        for (JVMClusterUtil.RegionServerThread rst : rsts) {
            hrs = rst.getRegionServer();
            while (rst.isAlive() && !hrs.isOnline()) {
                Thread.sleep(100L);
            }
            if (!rst.isAlive()) continue;
            boolean isCarryingMeta = false;
            boolean foundTableRegion = false;
            regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices());
            for (RegionInfo region : regions) {
                if (region.isMetaRegion()) {
                    isCarryingMeta = true;
                }
                if (region.getTable() == this.tableName) {
                    foundTableRegion = true;
                }
                if (!foundTableRegion || !isCarryingMeta && hasMetaRegion) continue;
                break;
            }
            if (isCarryingMeta && hasMetaRegion) {
                if (!foundTableRegion) {
                    final HRegionServer destRS = hrs;
                    List tableRegions = TEST_UTIL.getAdmin().getRegions(this.tableName);
                    final RegionInfo hri = (RegionInfo)tableRegions.get(0);
                    TEST_UTIL.getAdmin().move(hri.getEncodedNameAsBytes(), destRS.getServerName());
                    final RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
                    TEST_UTIL.waitFor(45000L, 200L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                        public boolean evaluate() throws Exception {
                            ServerName sn = regionStates.getRegionServerOfRegion(hri);
                            return sn != null && sn.equals((Object)destRS.getServerName());
                        }
                    });
                }
                return hrs;
            }
            if (hasMetaRegion || isCarryingMeta || !foundTableRegion) continue;
            break;
        }
        return hrs;
    }
}

