/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.master.MasterStateStoreTestBase;
import org.apache.hadoop.hbase.master.SplitOrMergeStateStore;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSplitOrMergeStateStore
extends MasterStateStoreTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitOrMergeStateStore.class);

    @After
    public void tearDown() throws Exception {
        TestSplitOrMergeStateStore.cleanup();
        ZKUtil.deleteNodeRecursively((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)TestSplitOrMergeStateStore.UTIL.getZooKeeperWatcher().getZNodePaths().switchZNode);
    }

    @Test
    public void testSplit() throws Exception {
        this.testReadWrite(MasterSwitchType.SPLIT);
    }

    @Test
    public void testMerge() throws Exception {
        this.testReadWrite(MasterSwitchType.MERGE);
    }

    @Test
    public void testSplitMigrate() throws Exception {
        this.testMigrate(MasterSwitchType.SPLIT, ZNodePaths.joinZNode((String)TestSplitOrMergeStateStore.UTIL.getZooKeeperWatcher().getZNodePaths().switchZNode, (String[])new String[]{UTIL.getConfiguration().get("zookeeper.znode.switch.split", "split")}));
    }

    @Test
    public void testMergeMigrate() throws Exception {
        this.testMigrate(MasterSwitchType.MERGE, ZNodePaths.joinZNode((String)TestSplitOrMergeStateStore.UTIL.getZooKeeperWatcher().getZNodePaths().switchZNode, (String[])new String[]{UTIL.getConfiguration().get("zookeeper.znode.switch.merge", "merge")}));
    }

    private void testReadWrite(MasterSwitchType type) throws Exception {
        SplitOrMergeStateStore store = new SplitOrMergeStateStore(REGION, UTIL.getZooKeeperWatcher(), UTIL.getConfiguration());
        Assert.assertTrue((boolean)store.isSplitOrMergeEnabled(type));
        store.setSplitOrMergeEnabled(false, type);
        Assert.assertFalse((boolean)store.isSplitOrMergeEnabled(type));
        store = new SplitOrMergeStateStore(REGION, UTIL.getZooKeeperWatcher(), UTIL.getConfiguration());
        Assert.assertFalse((boolean)store.isSplitOrMergeEnabled(type));
        store.setSplitOrMergeEnabled(true, type);
        Assert.assertTrue((boolean)store.isSplitOrMergeEnabled(type));
    }

    private void testMigrate(MasterSwitchType type, String zkPath) throws Exception {
        byte[] zkData = ProtobufUtil.prependPBMagic((byte[])ZooKeeperProtos.SwitchState.newBuilder().setEnabled(false).build().toByteArray());
        ZKUtil.createSetData((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)zkPath, (byte[])zkData);
        SplitOrMergeStateStore store = new SplitOrMergeStateStore(REGION, UTIL.getZooKeeperWatcher(), UTIL.getConfiguration());
        Assert.assertFalse((boolean)store.isSplitOrMergeEnabled(type));
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)zkPath));
    }
}

