/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.assignment.RegionStateNodeLock;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.AtomicUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRegionStateNodeLock {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionStateNodeLock.class);
    private final RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"test")).build();
    private RegionStateNodeLock lock;

    @Before
    public void setUp() {
        this.lock = new RegionStateNodeLock(this.regionInfo);
    }

    @Test
    public void testLockByThread() {
        Assert.assertFalse((boolean)this.lock.isLocked());
        Assert.assertFalse((boolean)this.lock.isLockedBy((Object)Thread.currentThread()));
        Assert.assertThrows(IllegalMonitorStateException.class, () -> this.lock.unlock());
        this.lock.lock();
        Assert.assertTrue((boolean)this.lock.isLocked());
        Assert.assertTrue((boolean)this.lock.isLockedBy((Object)Thread.currentThread()));
        Assert.assertFalse((boolean)this.lock.isLockedBy(new Object()));
        Assert.assertTrue((boolean)this.lock.tryLock());
        this.lock.unlock();
        Assert.assertTrue((boolean)this.lock.isLocked());
        this.lock.unlock();
        Assert.assertFalse((boolean)this.lock.isLocked());
    }

    @Test
    public void testLockByProc() throws ProcedureSuspendedException {
        ProcedureTestingUtility.NoopProcedure proc = new ProcedureTestingUtility.NoopProcedure();
        Assert.assertFalse((boolean)this.lock.isLocked());
        Assert.assertFalse((boolean)this.lock.isLockedBy((Object)proc));
        Assert.assertThrows(IllegalMonitorStateException.class, () -> this.lock.unlock((Procedure)proc));
        this.lock.lock((Procedure)proc, null);
        Assert.assertTrue((boolean)this.lock.isLocked());
        Assert.assertTrue((boolean)this.lock.isLockedBy((Object)proc));
        Assert.assertTrue((boolean)this.lock.tryLock((Procedure)proc));
        this.lock.unlock((Procedure)proc);
        Assert.assertTrue((boolean)this.lock.isLocked());
        Assert.assertTrue((boolean)this.lock.isLockedBy((Object)proc));
        this.lock.unlock((Procedure)proc);
        Assert.assertFalse((boolean)this.lock.isLocked());
        Assert.assertFalse((boolean)this.lock.isLockedBy((Object)proc));
    }

    @Test
    public void testLockProcThenThread() throws ProcedureSuspendedException {
        ProcedureTestingUtility.NoopProcedure proc = new ProcedureTestingUtility.NoopProcedure();
        Assert.assertFalse((boolean)this.lock.isLocked());
        this.lock.lock((Procedure)proc, null);
        Assert.assertFalse((boolean)this.lock.tryLock());
        Assert.assertThrows(IllegalMonitorStateException.class, () -> this.lock.unlock());
        long startNs = System.nanoTime();
        new Thread(() -> {
            Threads.sleepWithoutInterrupt((long)2000L);
            this.lock.unlock((Procedure)proc);
        }).start();
        this.lock.lock();
        long costNs = System.nanoTime() - startNs;
        MatcherAssert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(costNs), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1800L)));
        Assert.assertTrue((boolean)this.lock.isLocked());
        this.lock.unlock();
        Assert.assertFalse((boolean)this.lock.isLocked());
    }

    @Test
    public void testLockThreadThenProc() throws ProcedureSuspendedException {
        this.lock.lock();
        ProcedureTestingUtility.NoopProcedure proc = new ProcedureTestingUtility.NoopProcedure();
        Runnable wakeUp = (Runnable)Mockito.mock(Runnable.class);
        Assert.assertThrows(ProcedureSuspendedException.class, () -> this.lock.lock((Procedure)proc, wakeUp));
        this.lock.unlock();
        ((Runnable)Mockito.verify((Object)wakeUp)).run();
        Assert.assertTrue((boolean)this.lock.isLockedBy((Object)proc));
    }

    @Test
    public void testLockMultiThread() throws InterruptedException {
        int nThreads = 10;
        AtomicLong concurrency = new AtomicLong(0L);
        AtomicLong maxConcurrency = new AtomicLong(0L);
        Thread[] threads = new Thread[nThreads];
        for (int i = 0; i < nThreads; ++i) {
            threads[i] = new Thread(() -> {
                for (int j = 0; j < 1000; ++j) {
                    this.lock.lock();
                    try {
                        long c = concurrency.incrementAndGet();
                        AtomicUtils.updateMax((AtomicLong)maxConcurrency, (long)c);
                        concurrency.decrementAndGet();
                    }
                    finally {
                        this.lock.unlock();
                    }
                    Threads.sleepWithoutInterrupt((long)1L);
                }
            });
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        Assert.assertEquals((long)0L, (long)concurrency.get());
        Assert.assertEquals((long)1L, (long)maxConcurrency.get());
        Assert.assertFalse((boolean)this.lock.isLocked());
    }
}

