/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.balancer.FavoredStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestFavoredNodeTableImport {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFavoredNodeTableImport.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFavoredNodeTableImport.class);
    private static final int SLAVES = 3;
    private static final int REGION_NUM = 20;
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final Configuration conf = UTIL.getConfiguration();

    @After
    public void stopCluster() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testTableCreation() throws Exception {
        conf.set("hbase.master.loadbalancer.class", StochasticLoadBalancer.class.getName());
        LOG.info("Starting up cluster");
        UTIL.startMiniCluster(3);
        while (!UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
            Threads.sleep((long)1L);
        }
        Admin admin = UTIL.getAdmin();
        admin.balancerSwitch(false, true);
        String tableName = "testFNImport";
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        admin.createTable(tableDescriptor, Bytes.toBytes((String)"a"), Bytes.toBytes((String)"z"), 20);
        UTIL.waitTableAvailable(tableDescriptor.getTableName());
        admin.balancerSwitch(true, true);
        LOG.info("Shutting down cluster");
        UTIL.shutdownMiniHBaseCluster();
        Thread.sleep(2000L);
        LOG.info("Starting cluster again with FN Balancer");
        UTIL.getConfiguration().set("hbase.master.loadbalancer.class", FavoredStochasticBalancer.class.getName());
        UTIL.restartHBaseCluster(3);
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        while (!master.isInitialized()) {
            Threads.sleep((long)1L);
        }
        UTIL.waitTableAvailable(tableDescriptor.getTableName());
        UTIL.waitUntilNoRegionsInTransition(10000L);
        Assert.assertTrue((boolean)master.isBalancerOn());
        FavoredNodesManager fnm = master.getFavoredNodesManager();
        Assert.assertNotNull((Object)fnm);
        admin = UTIL.getAdmin();
        List regionsOfTable = admin.getRegions(TableName.valueOf((String)tableName));
        for (RegionInfo rInfo : regionsOfTable) {
            Assert.assertNotNull((Object)rInfo);
            Assert.assertNotNull((Object)fnm);
            List fns = fnm.getFavoredNodes(rInfo);
            LOG.info("FNS {} {}", (Object)rInfo, (Object)fns);
            Assert.assertNotNull((String)rInfo.toString(), (Object)fns);
            HashSet favNodes = Sets.newHashSet((Iterable)fns);
            Assert.assertNotNull((Object)favNodes);
            Assert.assertEquals((String)"Required no of favored nodes not found.", (long)3L, (long)favNodes.size());
            for (ServerName fn : favNodes) {
                Assert.assertEquals((String)("StartCode invalid for:" + fn), (long)-1L, (long)fn.getStartcode());
            }
        }
    }
}

