/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class TestFlushTableProcedureBase {
    protected static HBaseTestingUtil TEST_UTIL;
    protected TableName TABLE_NAME;
    protected byte[] FAMILY1;
    protected byte[] FAMILY2;
    protected byte[] FAMILY3;

    @Before
    public void setup() throws Exception {
        TEST_UTIL = new HBaseTestingUtil();
        this.addConfiguration(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(3);
        this.TABLE_NAME = TableName.valueOf((byte[])Bytes.toBytes((String)"TestFlushTable"));
        this.FAMILY1 = Bytes.toBytes((String)"cf1");
        this.FAMILY2 = Bytes.toBytes((String)"cf2");
        this.FAMILY3 = Bytes.toBytes((String)"cf3");
        byte[][] splitKeys = new RegionSplitter.HexStringSplit().split(10);
        Table table = TEST_UTIL.createTable(this.TABLE_NAME, (byte[][])new byte[][]{this.FAMILY1, this.FAMILY2, this.FAMILY3}, splitKeys);
        TEST_UTIL.loadTable(table, this.FAMILY1, false);
        TEST_UTIL.loadTable(table, this.FAMILY2, false);
        TEST_UTIL.loadTable(table, this.FAMILY3, false);
    }

    protected void addConfiguration(Configuration config) {
        config.setInt("hbase.procedure.remote.dispatcher.delay.msec", 10000);
        config.setInt("hbase.procedure.remote.dispatcher.max.queue.size", 128);
    }

    protected void assertTableMemStoreNotEmpty() {
        long totalSize = TEST_UTIL.getHBaseCluster().getRegions(this.TABLE_NAME).stream().mapToLong(HRegion::getMemStoreDataSize).sum();
        Assert.assertTrue((totalSize > 0L ? 1 : 0) != 0);
    }

    protected void assertTableMemStoreEmpty() {
        long totalSize = TEST_UTIL.getHBaseCluster().getRegions(this.TABLE_NAME).stream().mapToLong(HRegion::getMemStoreDataSize).sum();
        Assert.assertEquals((long)0L, (long)totalSize);
    }

    protected void assertColumnFamilyMemStoreNotEmpty(byte[] columnFamily) {
        long totalSize = TEST_UTIL.getHBaseCluster().getRegions(this.TABLE_NAME).stream().mapToLong(r -> r.getStore(columnFamily).getMemStoreSize().getDataSize()).sum();
        Assert.assertTrue((totalSize > 0L ? 1 : 0) != 0);
    }

    protected void assertColumnFamilyMemStoreEmpty(byte[] columnFamily) {
        long totalSize = TEST_UTIL.getHBaseCluster().getRegions(this.TABLE_NAME).stream().mapToLong(r -> r.getStore(columnFamily).getMemStoreSize().getDataSize()).sum();
        Assert.assertEquals((long)0L, (long)totalSize);
    }

    @After
    public void teardown() throws Exception {
        if (TEST_UTIL.getHBaseCluster().getMaster() != null) {
            ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor(), (boolean)false);
        }
        TEST_UTIL.shutdownMiniCluster();
    }
}

