/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.TableReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.TestZKReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ZKReplicationQueueStorageForMigration;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReplicationPeerManagerMigrateQueuesFromZk {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationPeerManagerMigrateQueuesFromZk.class);
    private static HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static ExecutorService EXECUTOR;
    ConcurrentMap<String, ReplicationPeerDescription> peers;
    private ReplicationPeerStorage peerStorage;
    private ReplicationQueueStorage queueStorage;
    private ReplicationPeerManager.ReplicationQueueStorageInitializer queueStorageInitializer;
    private ReplicationPeerManager manager;
    private int nServers = 10;
    private int nPeers = 10;
    private int nRegions = 100;
    private ServerName deadServerName;
    @Rule
    public final TableNameTestRule tableNameRule = new TableNameTestRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(1);
        EXECUTOR = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(TestReplicationPeerManagerMigrateQueuesFromZk.class.getSimpleName() + "-%d").build());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        EXECUTOR.shutdownNow();
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        this.peerStorage = (ReplicationPeerStorage)Mockito.mock(ReplicationPeerStorage.class);
        TableName tableName = this.tableNameRule.getTableName();
        UTIL.getAdmin().createTable(ReplicationStorageFactory.createReplicationQueueTableDescriptor((TableName)tableName));
        this.queueStorage = new TableReplicationQueueStorage(UTIL.getConnection(), tableName);
        this.queueStorageInitializer = (ReplicationPeerManager.ReplicationQueueStorageInitializer)Mockito.mock(ReplicationPeerManager.ReplicationQueueStorageInitializer.class);
        this.peers = new ConcurrentHashMap<String, ReplicationPeerDescription>();
        this.deadServerName = ServerName.valueOf((String)"test-hbase-dead", (int)12345, (long)EnvironmentEdgeManager.currentTime());
        this.manager = new ReplicationPeerManager(UTIL.getTestFileSystem(), UTIL.getZooKeeperWatcher(), this.peerStorage, this.queueStorage, this.peers, conf, "cluster", this.queueStorageInitializer);
    }

    private Map<String, Set<String>> prepareData() throws Exception {
        ZKReplicationQueueStorageForMigration storage = new ZKReplicationQueueStorageForMigration(UTIL.getZooKeeperWatcher(), UTIL.getConfiguration());
        TestZKReplicationQueueStorage.mockQueuesData((ZKReplicationQueueStorageForMigration)storage, (int)10, (String)"peer_0", (ServerName)this.deadServerName);
        Map encodedName2PeerIds = TestZKReplicationQueueStorage.mockLastPushedSeqIds((ZKReplicationQueueStorageForMigration)storage, (String)"peer_1", (String)"peer_2", (int)this.nRegions, (int)10, (int)10);
        TestZKReplicationQueueStorage.mockHFileRefs((ZKReplicationQueueStorageForMigration)storage, (int)10);
        return encodedName2PeerIds;
    }

    @Test
    public void testNoPeers() throws Exception {
        this.prepareData();
        this.manager.migrateQueuesFromZk(UTIL.getZooKeeperWatcher(), EXECUTOR).get(1L, TimeUnit.MINUTES);
        ((ReplicationPeerManager.ReplicationQueueStorageInitializer)Mockito.verify((Object)this.queueStorageInitializer)).initialize();
        try (Table table = UTIL.getConnection().getTable(this.tableNameRule.getTableName());){
            Assert.assertEquals((long)0L, (long)HBaseTestingUtil.countRows(table));
        }
    }

    @Test
    public void testMigrate() throws Exception {
        Throwable offset;
        Object queueData2;
        Map<String, Set<String>> encodedName2PeerIds = this.prepareData();
        for (int i = 0; i < this.nPeers; ++i) {
            this.peers.put("peer_" + i, (ReplicationPeerDescription)Mockito.mock(ReplicationPeerDescription.class));
        }
        this.manager.migrateQueuesFromZk(UTIL.getZooKeeperWatcher(), EXECUTOR).get(1L, TimeUnit.MINUTES);
        ((ReplicationPeerManager.ReplicationQueueStorageInitializer)Mockito.verify((Object)this.queueStorageInitializer)).initialize();
        List queueDatas = this.queueStorage.listAllQueues();
        Assert.assertEquals((long)(2 * this.nServers - 2), (long)queueDatas.size());
        for (Object queueData2 : queueDatas) {
            Assert.assertEquals((Object)"peer_0", (Object)queueData2.getId().getPeerId());
            Assert.assertEquals((long)1L, (long)queueData2.getOffsets().size());
            String walGroup = queueData2.getId().getServerWALsBelongTo().toString();
            offset = (ReplicationGroupOffset)queueData2.getOffsets().get((Object)walGroup);
            Assert.assertEquals((long)0L, (long)offset.getOffset());
            Assert.assertEquals((Object)(queueData2.getId().getServerWALsBelongTo().toString() + ".0"), (Object)offset.getWal());
        }
        Table table = UTIL.getConnection().getTable(this.tableNameRule.getTableName());
        queueData2 = null;
        try {
            offset = null;
            try (ResultScanner scanner = table.getScanner(TableReplicationQueueStorage.LAST_SEQUENCE_ID_FAMILY);){
                for (int i = 0; i < 2; ++i) {
                    Result result = scanner.next();
                    String peerId = Bytes.toString((byte[])result.getRow());
                    Assert.assertEquals((long)this.nRegions, (long)result.size());
                    for (Cell cell : result.rawCells()) {
                        String encodedRegionName2 = Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                        encodedName2PeerIds.get(encodedRegionName2).remove(peerId);
                        long seqId = Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
                        Assert.assertEquals((long)(i + 1), (long)seqId);
                    }
                }
                encodedName2PeerIds.forEach((encodedRegionName, peerIds) -> MatcherAssert.assertThat((String)(encodedRegionName + " still has unmigrated peers"), (Object)peerIds, (Matcher)Matchers.empty()));
                Assert.assertNull((Object)scanner.next());
            }
            catch (Throwable throwable) {
                offset = throwable;
                throw throwable;
            }
        }
        catch (Throwable scanner) {
            queueData2 = scanner;
            throw scanner;
        }
        finally {
            if (table != null) {
                if (queueData2 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable scanner) {
                        ((Throwable)queueData2).addSuppressed(scanner);
                    }
                } else {
                    table.close();
                }
            }
        }
        for (int i = 0; i < this.nPeers; ++i) {
            List refs = this.queueStorage.getReplicableHFiles("peer_" + i);
            Assert.assertEquals((long)i, (long)refs.size());
            HashSet refsSet = new HashSet(refs);
            for (int j = 0; j < i; ++j) {
                Assert.assertTrue((boolean)refsSet.remove("hfile-" + j));
            }
            MatcherAssert.assertThat(refsSet, (Matcher)Matchers.empty());
        }
    }
}

