/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namespace;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.namespace.NamespaceAuditor;
import org.apache.hadoop.hbase.namespace.NamespaceTableAndRegionInfo;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestNamespaceAuditor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNamespaceAuditor.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestNamespaceAuditor.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static Admin ADMIN;
    private String prefix = "TestNamespaceAuditor";

    @BeforeClass
    public static void before() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.region.classes", CustomObserver.class.getName());
        conf.setStrings("hbase.coprocessor.master.classes", new String[]{MasterSyncObserver.class.getName(), CPMasterObserver.class.getName()});
        conf.setInt("hbase.client.retries.number", 5);
        conf.setBoolean("hbase.quota.enabled", true);
        conf.setClass("hbase.coprocessor.regionserver.classes", CPRegionServerObserver.class, RegionServerObserver.class);
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(2).build();
        UTIL.startMiniCluster(option);
        TestNamespaceAuditor.waitForQuotaInitialize(UTIL);
        ADMIN = UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void cleanup() throws Exception, KeeperException {
        for (TableDescriptor table : ADMIN.listTableDescriptors()) {
            ADMIN.disableTable(table.getTableName());
            this.deleteTable(table.getTableName());
        }
        for (NamespaceDescriptor ns : ADMIN.listNamespaceDescriptors()) {
            if (!ns.getName().startsWith(this.prefix)) continue;
            ADMIN.deleteNamespace(ns.getName());
        }
        Assert.assertTrue((String)"Quota manager not initialized", (boolean)UTIL.getHBaseCluster().getMaster().getMasterQuotaManager().isQuotaInitialized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableOperations() throws Exception {
        String nsp = this.prefix + "_np2";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxregions", "5").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(nsp));
        Assert.assertEquals((long)3L, (long)ADMIN.listNamespaceDescriptors().length);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"fam1")).build();
        TableDescriptorBuilder tableDescOne = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(nsp + ':' + "table1")));
        tableDescOne.setColumnFamily(columnFamilyDescriptor);
        TableDescriptorBuilder tableDescTwo = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(nsp + ':' + "table2")));
        tableDescTwo.setColumnFamily(columnFamilyDescriptor);
        TableDescriptorBuilder tableDescThree = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(nsp + ':' + "table3")));
        tableDescThree.setColumnFamily(columnFamilyDescriptor);
        ADMIN.createTable(tableDescOne.build());
        boolean constraintViolated = false;
        try {
            ADMIN.createTable(tableDescTwo.build(), Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 5);
        }
        catch (Exception exp) {
            Assert.assertTrue((boolean)(exp instanceof IOException));
            constraintViolated = true;
        }
        finally {
            Assert.assertTrue((String)("Constraint not violated for table " + tableDescTwo.build().getTableName()), (boolean)constraintViolated);
        }
        ADMIN.createTable(tableDescTwo.build(), Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 4);
        NamespaceTableAndRegionInfo nspState = this.getQuotaManager().getState(nsp);
        Assert.assertNotNull((Object)nspState);
        Assert.assertTrue((nspState.getTables().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((nspState.getRegionCount() == 5 ? 1 : 0) != 0);
        constraintViolated = false;
        try {
            ADMIN.createTable(tableDescThree.build());
        }
        catch (Exception exp) {
            Assert.assertTrue((boolean)(exp instanceof IOException));
            constraintViolated = true;
        }
        finally {
            Assert.assertTrue((String)("Constraint not violated for table " + tableDescThree.build().getTableName()), (boolean)constraintViolated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidQuotas() throws Exception {
        boolean exceptionCaught = false;
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)(this.prefix + "vq1")).addConfiguration("hbase.namespace.quota.maxregions", "hihdufh").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        try {
            ADMIN.createNamespace(nspDesc);
        }
        catch (Exception exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
            Assert.assertFalse((boolean)fs.exists(CommonFSUtils.getNamespaceDir((Path)rootDir, (String)nspDesc.getName())));
        }
        nspDesc = NamespaceDescriptor.create((String)(this.prefix + "vq2")).addConfiguration("hbase.namespace.quota.maxregions", "-456").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        try {
            ADMIN.createNamespace(nspDesc);
        }
        catch (Exception exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
            Assert.assertFalse((boolean)fs.exists(CommonFSUtils.getNamespaceDir((Path)rootDir, (String)nspDesc.getName())));
        }
        nspDesc = NamespaceDescriptor.create((String)(this.prefix + "vq3")).addConfiguration("hbase.namespace.quota.maxregions", "10").addConfiguration("hbase.namespace.quota.maxtables", "sciigd").build();
        try {
            ADMIN.createNamespace(nspDesc);
        }
        catch (Exception exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
            Assert.assertFalse((boolean)fs.exists(CommonFSUtils.getNamespaceDir((Path)rootDir, (String)nspDesc.getName())));
        }
        nspDesc = NamespaceDescriptor.create((String)(this.prefix + "vq4")).addConfiguration("hbase.namespace.quota.maxregions", "10").addConfiguration("hbase.namespace.quota.maxtables", "-1500").build();
        try {
            ADMIN.createNamespace(nspDesc);
        }
        catch (Exception exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
            Assert.assertFalse((boolean)fs.exists(CommonFSUtils.getNamespaceDir((Path)rootDir, (String)nspDesc.getName())));
        }
    }

    @Test
    public void testDeleteTable() throws Exception {
        String namespace = this.prefix + "_dummy";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)namespace).addConfiguration("hbase.namespace.quota.maxregions", "100").addConfiguration("hbase.namespace.quota.maxtables", "3").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(namespace));
        NamespaceTableAndRegionInfo stateInfo = this.getNamespaceState(nspDesc.getName());
        Assert.assertNotNull((String)("Namespace state found null for " + namespace), (Object)stateInfo);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"fam1")).build();
        TableDescriptorBuilder tableDescOne = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(namespace + ':' + "table1")));
        tableDescOne.setColumnFamily(columnFamilyDescriptor);
        TableDescriptorBuilder tableDescTwo = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(namespace + ':' + "table2")));
        tableDescTwo.setColumnFamily(columnFamilyDescriptor);
        ADMIN.createTable(tableDescOne.build());
        ADMIN.createTable(tableDescTwo.build(), Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 5);
        stateInfo = this.getNamespaceState(nspDesc.getName());
        Assert.assertNotNull((String)"Namespace state found to be null.", (Object)stateInfo);
        Assert.assertEquals((long)2L, (long)stateInfo.getTables().size());
        Assert.assertEquals((long)5L, (long)stateInfo.getRegionCountOfTable(tableDescTwo.build().getTableName()));
        Assert.assertEquals((long)6L, (long)stateInfo.getRegionCount());
        ADMIN.disableTable(tableDescOne.build().getTableName());
        this.deleteTable(tableDescOne.build().getTableName());
        stateInfo = this.getNamespaceState(nspDesc.getName());
        Assert.assertNotNull((String)"Namespace state found to be null.", (Object)stateInfo);
        Assert.assertEquals((long)5L, (long)stateInfo.getRegionCount());
        Assert.assertEquals((long)1L, (long)stateInfo.getTables().size());
        ADMIN.disableTable(tableDescTwo.build().getTableName());
        this.deleteTable(tableDescTwo.build().getTableName());
        ADMIN.deleteNamespace(namespace);
        stateInfo = this.getNamespaceState(namespace);
        Assert.assertNull((String)"Namespace state not found to be null.", (Object)stateInfo);
    }

    @Test
    public void testRegionMerge() throws Exception {
        String nsp1 = this.prefix + "_regiontest";
        int initialRegions = 3;
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp1).addConfiguration("hbase.namespace.quota.maxregions", "3").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        ADMIN.createNamespace(nspDesc);
        TableName tableTwo = TableName.valueOf((String)(nsp1 + ':' + "table2"));
        byte[] columnFamily = Bytes.toBytes((String)"info");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableTwo).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])columnFamily)).build();
        ADMIN.createTable(tableDescriptor, Bytes.toBytes((String)"0"), Bytes.toBytes((String)"9"), 3);
        Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
        try (Table table = connection.getTable(tableTwo);){
            UTIL.loadNumericRows(table, Bytes.toBytes((String)"info"), 1000, 1999);
        }
        ADMIN.flush(tableTwo);
        List hris = ADMIN.getRegions(tableTwo);
        Assert.assertEquals((long)3L, (long)hris.size());
        Collections.sort(hris, RegionInfo.COMPARATOR);
        Future f = ADMIN.mergeRegionsAsync(((RegionInfo)hris.get(0)).getEncodedNameAsBytes(), ((RegionInfo)hris.get(1)).getEncodedNameAsBytes(), false);
        f.get(10L, TimeUnit.SECONDS);
        hris = ADMIN.getRegions(tableTwo);
        Assert.assertEquals((long)2L, (long)hris.size());
        Collections.sort(hris, RegionInfo.COMPARATOR);
        byte[] splitKey = Bytes.toBytes((String)"3");
        final HRegion regionToSplit = UTIL.getMiniHBaseCluster().getRegions(tableTwo).stream().filter(r -> r.getRegionInfo().containsRow(splitKey)).findFirst().get();
        regionToSplit.compact(true);
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return CompactionState.NONE == ADMIN.getCompactionStateForRegion(regionToSplit.getRegionInfo().getRegionName());
            }
        });
        regionToSplit.getStores().stream().forEach(s -> {
            try {
                s.closeAndArchiveCompactedFiles();
            }
            catch (IOException e1) {
                LOG.error("Error whiling cleaning compacted file");
            }
        });
        UTIL.waitFor(10000L, () -> ((HRegion)regionToSplit).isSplittable());
        ADMIN.splitRegionAsync(regionToSplit.getRegionInfo().getRegionName(), splitKey).get(10L, TimeUnit.SECONDS);
        hris = ADMIN.getRegions(tableTwo);
        Assert.assertEquals((long)3L, (long)hris.size());
        Collections.sort(hris, RegionInfo.COMPARATOR);
        SingleProcessHBaseCluster cluster = UTIL.getHBaseCluster();
        MasterCoprocessorHost cpHost = cluster.getMaster().getMasterCoprocessorHost();
        Coprocessor coprocessor = cpHost.findCoprocessor(CPMasterObserver.class);
        CPMasterObserver masterObserver = (CPMasterObserver)coprocessor;
        masterObserver.failMerge(true);
        f = ADMIN.mergeRegionsAsync(((RegionInfo)hris.get(1)).getEncodedNameAsBytes(), ((RegionInfo)hris.get(2)).getEncodedNameAsBytes(), false);
        try {
            f.get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"Merge was supposed to fail!");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        hris = ADMIN.getRegions(tableTwo);
        Assert.assertEquals((long)3L, (long)hris.size());
        Collections.sort(hris, RegionInfo.COMPARATOR);
        try {
            ADMIN.split(tableTwo, Bytes.toBytes((String)"6"));
            Assert.fail();
        }
        catch (DoNotRetryRegionException doNotRetryRegionException) {
            // empty catch block
        }
        Thread.sleep(2000L);
        Assert.assertEquals((long)3L, (long)ADMIN.getRegions(tableTwo).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecreateTableWithSameNameAfterFirstTimeFailure() throws Exception {
        String nsp1 = this.prefix + "_testRecreateTable";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp1).addConfiguration("hbase.namespace.quota.maxregions", "20").addConfiguration("hbase.namespace.quota.maxtables", "1").build();
        ADMIN.createNamespace(nspDesc);
        TableName tableOne = TableName.valueOf((String)(nsp1 + ':' + "table1"));
        byte[] columnFamily = Bytes.toBytes((String)"info");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableOne).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])columnFamily)).build();
        MasterSyncObserver.throwExceptionInPreCreateTableAction = true;
        try {
            try {
                ADMIN.createTable(tableDescriptor);
                Assert.fail((String)("Table " + tableOne.toString() + "creation should fail."));
            }
            catch (Exception exp) {
                LOG.error(exp.toString(), (Throwable)exp);
            }
            Assert.assertFalse((boolean)ADMIN.tableExists(tableOne));
            NamespaceTableAndRegionInfo nstate = this.getNamespaceState(nsp1);
            Assert.assertEquals((String)"First table creation failed in namespace so number of tables in namespace should be 0.", (long)0L, (long)nstate.getTables().size());
            MasterSyncObserver.throwExceptionInPreCreateTableAction = false;
            try {
                ADMIN.createTable(tableDescriptor);
            }
            catch (Exception e) {
                Assert.fail((String)("Table " + tableOne.toString() + "creation should succeed."));
                LOG.error(e.toString(), (Throwable)e);
            }
            Assert.assertTrue((boolean)ADMIN.tableExists(tableOne));
            nstate = this.getNamespaceState(nsp1);
            Assert.assertEquals((String)"First table was created successfully so table size in namespace should be one now.", (long)1L, (long)nstate.getTables().size());
        }
        finally {
            MasterSyncObserver.throwExceptionInPreCreateTableAction = false;
            if (ADMIN.tableExists(tableOne)) {
                ADMIN.disableTable(tableOne);
                this.deleteTable(tableOne);
            }
            ADMIN.deleteNamespace(nsp1);
        }
    }

    private NamespaceTableAndRegionInfo getNamespaceState(String namespace) throws KeeperException, IOException {
        return this.getQuotaManager().getState(namespace);
    }

    @Test
    public void testStatePreserve() throws Exception {
        final String nsp1 = this.prefix + "_testStatePreserve";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp1).addConfiguration("hbase.namespace.quota.maxregions", "20").addConfiguration("hbase.namespace.quota.maxtables", "10").build();
        ADMIN.createNamespace(nspDesc);
        TableName tableOne = TableName.valueOf((String)(nsp1 + ':' + "table1"));
        TableName tableTwo = TableName.valueOf((String)(nsp1 + ':' + "table2"));
        TableName tableThree = TableName.valueOf((String)(nsp1 + ':' + "table3"));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"fam1")).build();
        TableDescriptorBuilder tableDescOne = TableDescriptorBuilder.newBuilder((TableName)tableOne);
        tableDescOne.setColumnFamily(columnFamilyDescriptor);
        TableDescriptorBuilder tableDescTwo = TableDescriptorBuilder.newBuilder((TableName)tableTwo);
        tableDescTwo.setColumnFamily(columnFamilyDescriptor);
        TableDescriptorBuilder tableDescThree = TableDescriptorBuilder.newBuilder((TableName)tableThree);
        tableDescThree.setColumnFamily(columnFamilyDescriptor);
        ADMIN.createTable(tableDescOne.build(), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1000"), 3);
        ADMIN.createTable(tableDescTwo.build(), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1000"), 3);
        ADMIN.createTable(tableDescThree.build(), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1000"), 4);
        ADMIN.disableTable(tableThree);
        this.deleteTable(tableThree);
        UTIL.waitFor(1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestNamespaceAuditor.this.getNamespaceState(nsp1).getTables().size() == 2;
            }
        });
        NamespaceTableAndRegionInfo before = this.getNamespaceState(nsp1);
        this.killActiveMaster();
        NamespaceTableAndRegionInfo after = this.getNamespaceState(nsp1);
        Assert.assertEquals((String)("Expected: " + before.getTables() + " Found: " + after.getTables()), (long)before.getTables().size(), (long)after.getTables().size());
    }

    public static void waitForQuotaInitialize(final HBaseTestingUtil util) throws Exception {
        util.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                HMaster master = util.getHBaseCluster().getMaster();
                if (master == null) {
                    return false;
                }
                MasterQuotaManager quotaManager = master.getMasterQuotaManager();
                return quotaManager != null && quotaManager.isQuotaInitialized();
            }
        });
    }

    private void killActiveMaster() throws Exception {
        UTIL.getHBaseCluster().getMaster(0).stop("Stopping to start again");
        UTIL.getHBaseCluster().waitOnMaster(0);
        TestNamespaceAuditor.waitForQuotaInitialize(UTIL);
    }

    private NamespaceAuditor getQuotaManager() {
        return UTIL.getHBaseCluster().getMaster().getMasterQuotaManager().getNamespaceQuotaManager();
    }

    private void deleteTable(TableName tableName) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)UTIL.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class);
        ADMIN.deleteTable(tableName);
        observer.tableDeletionLatch.await();
    }

    @Test(expected=QuotaExceededException.class)
    public void testExceedTableQuotaInNamespace() throws Exception {
        String nsp = this.prefix + "_testExceedTableQuotaInNamespace";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxtables", "1").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(nsp));
        Assert.assertEquals((long)3L, (long)ADMIN.listNamespaceDescriptors().length);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"fam1")).build();
        TableDescriptorBuilder tableDescOne = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(nsp + ':' + "table1")));
        tableDescOne.setColumnFamily(columnFamilyDescriptor);
        TableDescriptorBuilder tableDescTwo = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(nsp + ':' + "table2")));
        tableDescTwo.setColumnFamily(columnFamilyDescriptor);
        ADMIN.createTable(tableDescOne.build());
        ADMIN.createTable(tableDescTwo.build(), Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 4);
    }

    @Test(expected=QuotaExceededException.class)
    public void testCloneSnapshotQuotaExceed() throws Exception {
        String nsp = this.prefix + "_testTableQuotaExceedWithCloneSnapshot";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxtables", "1").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(nsp));
        TableName tableName = TableName.valueOf((String)(nsp + ':' + "table1"));
        TableName cloneTableName = TableName.valueOf((String)(nsp + ':' + "table2"));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"fam1")).build();
        TableDescriptorBuilder tableDescOne = TableDescriptorBuilder.newBuilder((TableName)tableName);
        tableDescOne.setColumnFamily(columnFamilyDescriptor);
        ADMIN.createTable(tableDescOne.build());
        String snapshot = "snapshot_testTableQuotaExceedWithCloneSnapshot";
        ADMIN.snapshot(snapshot, tableName);
        ADMIN.cloneSnapshot(snapshot, cloneTableName);
        ADMIN.deleteSnapshot(snapshot);
    }

    @Test
    public void testCloneSnapshot() throws Exception {
        int tableLength;
        String nsp = this.prefix + "_testCloneSnapshot";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxtables", "2").addConfiguration("hbase.namespace.quota.maxregions", "20").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(nsp));
        TableName tableName = TableName.valueOf((String)(nsp + ':' + "table1"));
        TableName cloneTableName = TableName.valueOf((String)(nsp + ':' + "table2"));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"fam1")).build();
        TableDescriptorBuilder tableDescOne = TableDescriptorBuilder.newBuilder((TableName)tableName);
        tableDescOne.setColumnFamily(columnFamilyDescriptor);
        ADMIN.createTable(tableDescOne.build(), Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 4);
        String snapshot = "snapshot_testCloneSnapshot";
        ADMIN.snapshot(snapshot, tableName);
        ADMIN.cloneSnapshot(snapshot, cloneTableName);
        try (RegionLocator locator = ADMIN.getConnection().getRegionLocator(tableName);){
            tableLength = locator.getStartKeys().length;
        }
        Assert.assertEquals((String)(tableName.getNameAsString() + " should have four regions."), (long)4L, (long)tableLength);
        locator = ADMIN.getConnection().getRegionLocator(cloneTableName);
        var10_9 = null;
        try {
            tableLength = locator.getStartKeys().length;
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
        finally {
            if (locator != null) {
                if (var10_9 != null) {
                    try {
                        locator.close();
                    }
                    catch (Throwable throwable) {
                        var10_9.addSuppressed(throwable);
                    }
                } else {
                    locator.close();
                }
            }
        }
        Assert.assertEquals((String)(cloneTableName.getNameAsString() + " should have four regions."), (long)4L, (long)tableLength);
        NamespaceTableAndRegionInfo nstate = this.getNamespaceState(nsp);
        Assert.assertEquals((String)"Total tables count should be 2.", (long)2L, (long)nstate.getTables().size());
        Assert.assertEquals((String)"Total regions count should be.", (long)8L, (long)nstate.getRegionCount());
        ADMIN.deleteSnapshot(snapshot);
    }

    @Test
    public void testRestoreSnapshot() throws Exception {
        String nsp = this.prefix + "_testRestoreSnapshot";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxregions", "10").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(nsp));
        TableName tableName1 = TableName.valueOf((String)(nsp + ':' + "table1"));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"fam1")).build();
        TableDescriptorBuilder tableDescOne = TableDescriptorBuilder.newBuilder((TableName)tableName1);
        tableDescOne.setColumnFamily(columnFamilyDescriptor);
        ADMIN.createTable(tableDescOne.build(), Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 4);
        NamespaceTableAndRegionInfo nstate = this.getNamespaceState(nsp);
        Assert.assertEquals((String)"Intial region count should be 4.", (long)4L, (long)nstate.getRegionCount());
        String snapshot = "snapshot_testRestoreSnapshot";
        ADMIN.snapshot(snapshot, tableName1);
        List regions = ADMIN.getRegions(tableName1);
        Collections.sort(regions, RegionInfo.COMPARATOR);
        ADMIN.split(tableName1, Bytes.toBytes((String)"JJJ"));
        Thread.sleep(2000L);
        Assert.assertEquals((String)"Total regions count should be 5.", (long)5L, (long)nstate.getRegionCount());
        ADMIN.disableTable(tableName1);
        ADMIN.restoreSnapshot(snapshot);
        Assert.assertEquals((String)"Total regions count should be 4 after restore.", (long)4L, (long)nstate.getRegionCount());
        ADMIN.enableTable(tableName1);
        ADMIN.deleteSnapshot(snapshot);
    }

    @Test
    public void testRestoreSnapshotQuotaExceed() throws Exception {
        String nsp = this.prefix + "_testRestoreSnapshotQuotaExceed";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxregions", "10").build();
        ADMIN.createNamespace(nspDesc);
        NamespaceDescriptor ndesc = ADMIN.getNamespaceDescriptor(nsp);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ndesc);
        TableName tableName1 = TableName.valueOf((String)(nsp + ':' + "table1"));
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"fam1")).build();
        TableDescriptorBuilder tableDescOne = TableDescriptorBuilder.newBuilder((TableName)tableName1);
        tableDescOne.setColumnFamily(columnFamilyDescriptor);
        ADMIN.createTable(tableDescOne.build(), Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 4);
        NamespaceTableAndRegionInfo nstate = this.getNamespaceState(nsp);
        Assert.assertEquals((String)"Intial region count should be 4.", (long)4L, (long)nstate.getRegionCount());
        String snapshot = "snapshot_testRestoreSnapshotQuotaExceed";
        ADMIN.snapshot(snapshot, tableName1);
        ADMIN.disableTable(tableName1);
        ADMIN.deleteTable(tableName1);
        ADMIN.createTable(tableDescOne.build());
        ndesc.setConfiguration("hbase.namespace.quota.maxregions", "3");
        ADMIN.modifyNamespace(ndesc);
        ADMIN.disableTable(tableName1);
        try {
            ADMIN.restoreSnapshot(snapshot);
            Assert.fail((String)"Region quota is exceeded so QuotaExceededException should be thrown but HBaseAdmin wraps IOException into RestoreSnapshotException");
        }
        catch (RestoreSnapshotException ignore) {
            Assert.assertTrue((boolean)(ignore.getCause() instanceof QuotaExceededException));
        }
        Assert.assertEquals((long)1L, (long)this.getNamespaceState(nsp).getRegionCount());
        ADMIN.enableTable(tableName1);
        ADMIN.deleteSnapshot(snapshot);
    }

    public static class MasterSyncObserver
    implements MasterCoprocessor,
    MasterObserver {
        volatile CountDownLatch tableDeletionLatch;
        static boolean throwExceptionInPreCreateTableAction;

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.tableDeletionLatch = new CountDownLatch(1);
        }

        public void postCompletedDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.tableDeletionLatch.countDown();
        }

        public void preCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            if (throwExceptionInPreCreateTableAction) {
                throw new IOException("Throw exception as it is demanded.");
            }
        }
    }

    public static class CustomObserver
    implements RegionCoprocessor,
    RegionObserver {
        volatile CountDownLatch postCompact;

        public void postCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, StoreFile resultFile, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
            this.postCompact.countDown();
        }

        public void start(CoprocessorEnvironment e) throws IOException {
            this.postCompact = new CountDownLatch(1);
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }
    }

    public static class CPMasterObserver
    implements MasterCoprocessor,
    MasterObserver {
        private volatile boolean shouldFailMerge = false;

        public void failMerge(boolean fail) {
            this.shouldFailMerge = fail;
        }

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public synchronized void preMergeRegionsAction(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo[] regionsToMerge) throws IOException {
            this.notifyAll();
            if (this.shouldFailMerge) {
                throw new IOException("fail merge");
            }
        }
    }

    public static class CPRegionServerObserver
    implements RegionServerCoprocessor,
    RegionServerObserver {
        private volatile boolean shouldFailMerge = false;
        private boolean triggered = false;

        public void failMerge(boolean fail) {
            this.shouldFailMerge = fail;
        }

        public synchronized void waitUtilTriggered() throws InterruptedException {
            while (!this.triggered) {
                this.wait();
            }
        }

        public Optional<RegionServerObserver> getRegionServerObserver() {
            return Optional.of(this);
        }
    }
}

