/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMasterQuotaManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterQuotaManager.class);

    @Test
    public void testUninitializedQuotaManangerDoesNotFail() {
        MasterServices masterServices = (MasterServices)Mockito.mock(MasterServices.class);
        MasterQuotaManager manager = new MasterQuotaManager(masterServices);
        manager.addRegionSize(null, 0L, 0L);
        Assert.assertNotNull((Object)manager.snapshotRegionSizes());
    }

    private RegionInfo createRegionInfo(TableName tableName, byte[] startKey, byte[] endKey) {
        return RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).setEndKey(endKey).build();
    }

    @Test
    public void testOldEntriesRemoved() {
        MasterServices masterServices = (MasterServices)Mockito.mock(MasterServices.class);
        MasterQuotaManager manager = new MasterQuotaManager(masterServices);
        manager.initializeRegionSizes();
        TableName tableName = TableName.valueOf((String)"foo");
        RegionInfo region1 = this.createRegionInfo(tableName, null, Bytes.toBytes((String)"a"));
        RegionInfo region2 = this.createRegionInfo(tableName, Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"));
        RegionInfo region3 = this.createRegionInfo(tableName, Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"));
        RegionInfo region4 = this.createRegionInfo(tableName, Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"));
        RegionInfo region5 = this.createRegionInfo(tableName, Bytes.toBytes((String)"d"), null);
        long size = 0L;
        long time1 = 10L;
        manager.addRegionSize(region1, 0L, time1);
        manager.addRegionSize(region2, 0L, time1);
        long time2 = 20L;
        manager.addRegionSize(region3, 0L, time2);
        manager.addRegionSize(region4, 0L, time2);
        long time3 = 30L;
        manager.addRegionSize(region5, 0L, time3);
        Assert.assertEquals((long)5L, (long)manager.snapshotRegionSizes().size());
        QuotaObserverChore chore = (QuotaObserverChore)Mockito.mock(QuotaObserverChore.class);
        Assert.assertEquals((long)0L, (long)manager.pruneEntriesOlderThan(0L, chore));
        Assert.assertEquals((long)5L, (long)manager.snapshotRegionSizes().size());
        Assert.assertEquals((long)0L, (long)manager.pruneEntriesOlderThan(10L, chore));
        Assert.assertEquals((long)5L, (long)manager.snapshotRegionSizes().size());
        Assert.assertEquals((long)2L, (long)manager.pruneEntriesOlderThan(15L, chore));
        Assert.assertEquals((long)3L, (long)manager.snapshotRegionSizes().size());
        Assert.assertEquals((long)2L, (long)manager.pruneEntriesOlderThan(30L, chore));
        Assert.assertEquals((long)1L, (long)manager.snapshotRegionSizes().size());
    }
}

