/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestSpaceQuotaDropTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotaDropTable.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSpaceQuotaDropTable.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, new AtomicLong(0L));
        this.helper.removeAllQuotas();
    }

    @Test
    public void testSetQuotaAndThenDropTableWithNoInserts() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.NO_INSERTS);
    }

    @Test
    public void testSetQuotaAndThenDropTableWithNoWrite() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.NO_WRITES);
    }

    @Test
    public void testSetQuotaAndThenDropTableWithNoWritesCompactions() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
    }

    @Test
    public void testSetQuotaAndThenDropTableWithDisable() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.DISABLE);
    }

    @Test
    public void testSetQuotaAndThenDropTableWithRegionReport() throws Exception {
        final TableName tn = this.helper.createTable();
        this.helper.setQuotaLimit(tn, SpaceViolationPolicy.NO_INSERTS, 1L);
        this.helper.writeData(tn, 2L);
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        final MasterQuotaManager quotaManager = master.getMasterQuotaManager();
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map regionSizes = quotaManager.snapshotRegionSizes();
                List tableRegions = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
                return regionSizes.containsKey(tableRegions.get(0));
            }
        });
        boolean hasRegionSize = false;
        for (Map.Entry entry : quotaManager.snapshotRegionSizes().entrySet()) {
            if (!((RegionInfo)entry.getKey()).getTable().equals((Object)tn)) continue;
            hasRegionSize = true;
            break;
        }
        Assert.assertTrue((boolean)hasRegionSize);
        TEST_UTIL.getAdmin().disableTable(tn);
        TEST_UTIL.getAdmin().deleteTable(tn);
        for (Map.Entry entry : quotaManager.snapshotRegionSizes().entrySet()) {
            if (!((RegionInfo)entry.getKey()).getTable().equals((Object)tn)) continue;
            Assert.fail((String)"Dropped table regionSizes were not deleted during the drop command");
        }
    }

    private void setQuotaAndThenDropTable(SpaceViolationPolicy policy) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"to_reject"));
        put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.helper.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        TEST_UTIL.deleteTable(tn);
        LOG.debug("Successfully deleted table ", (Object)tn);
        TEST_UTIL.createTable(tn, Bytes.toBytes((String)"f1"));
        LOG.debug("Successfully re-created table ", (Object)tn);
        this.helper.verifyNoViolation(tn, (Mutation)put);
    }
}

