/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestSpaceQuotaOnNonExistingTables {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotaOnNonExistingTables.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private final TableName NON_EXISTENT_TABLE = TableName.valueOf((String)"NON_EXISTENT_TABLE");
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, new AtomicLong(0L));
        this.helper.removeAllQuotas();
    }

    @Test
    public void testSetQuotaOnNonExistingTableWithNoInserts() throws Exception {
        this.helper.setQuotaLimit(this.NON_EXISTENT_TABLE, SpaceViolationPolicy.NO_INSERTS, 2L);
    }

    @Test
    public void testSetQuotaOnNonExistingTableWithNoWrites() throws Exception {
        this.helper.setQuotaLimit(this.NON_EXISTENT_TABLE, SpaceViolationPolicy.NO_WRITES, 2L);
    }

    @Test
    public void testSetQuotaOnNonExistingTableWithNoWritesCompaction() throws Exception {
        this.helper.setQuotaLimit(this.NON_EXISTENT_TABLE, SpaceViolationPolicy.NO_WRITES_COMPACTIONS, 2L);
    }

    @Test
    public void testSetQuotaOnNonExistingTableWithDisable() throws Exception {
        this.helper.setQuotaLimit(this.NON_EXISTENT_TABLE, SpaceViolationPolicy.DISABLE, 2L);
    }
}

