/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RSAnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestPriorityRpc {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPriorityRpc.class);
    private static Configuration CONF = HBaseConfiguration.create();

    @Test
    public void testQosFunctionForMeta() throws IOException {
        RPCProtos.RequestHeader.Builder headerBuilder = RPCProtos.RequestHeader.newBuilder();
        headerBuilder.setMethodName("foo");
        ClientProtos.GetRequest.Builder getRequestBuilder = ClientProtos.GetRequest.newBuilder();
        HBaseProtos.RegionSpecifier.Builder regionSpecifierBuilder = HBaseProtos.RegionSpecifier.newBuilder();
        regionSpecifierBuilder.setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
        ByteString name = UnsafeByteOperations.unsafeWrap((byte[])RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName());
        regionSpecifierBuilder.setValue(name);
        HBaseProtos.RegionSpecifier regionSpecifier = regionSpecifierBuilder.build();
        getRequestBuilder.setRegion(regionSpecifier);
        ClientProtos.Get.Builder getBuilder = ClientProtos.Get.newBuilder();
        getBuilder.setRow(UnsafeByteOperations.unsafeWrap((byte[])Bytes.toBytes((String)"somerow")));
        getRequestBuilder.setGet(getBuilder.build());
        ClientProtos.GetRequest getRequest = getRequestBuilder.build();
        RPCProtos.RequestHeader header = headerBuilder.build();
        HRegion mockRegion = (HRegion)Mockito.mock(HRegion.class);
        RSRpcServices mockRpc = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        Mockito.when((Object)mockRpc.getConfiguration()).thenReturn((Object)CONF);
        RegionInfo mockRegionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)mockRpc.getRegion((HBaseProtos.RegionSpecifier)ArgumentMatchers.any())).thenReturn((Object)mockRegion);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.getTable()).thenReturn((Object)RegionInfoBuilder.FIRST_META_REGIONINFO.getTable());
        RSAnnotationReadingPriorityFunction qosFunc = new RSAnnotationReadingPriorityFunction(mockRpc);
        Assert.assertEquals((long)200L, (long)qosFunc.getPriority(header, (Message)getRequest, TestPriorityRpc.createSomeUser()));
    }

    @Test
    public void testQosFunctionWithoutKnownArgument() throws IOException {
        RPCProtos.RequestHeader.Builder headerBuilder = RPCProtos.RequestHeader.newBuilder();
        headerBuilder.setMethodName("foo");
        RPCProtos.RequestHeader header = headerBuilder.build();
        RSRpcServices mockRpc = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        Mockito.when((Object)mockRpc.getConfiguration()).thenReturn((Object)CONF);
        RSAnnotationReadingPriorityFunction qosFunc = new RSAnnotationReadingPriorityFunction(mockRpc);
        Assert.assertEquals((long)0L, (long)qosFunc.getPriority(header, null, TestPriorityRpc.createSomeUser()));
    }

    @Test
    public void testQosFunctionForScanMethod() throws IOException {
        RPCProtos.RequestHeader.Builder headerBuilder = RPCProtos.RequestHeader.newBuilder();
        headerBuilder.setMethodName("Scan");
        RPCProtos.RequestHeader header = headerBuilder.build();
        ClientProtos.ScanRequest.Builder scanBuilder = ClientProtos.ScanRequest.newBuilder();
        ClientProtos.ScanRequest scanRequest = scanBuilder.build();
        HRegion mockRegion = (HRegion)Mockito.mock(HRegion.class);
        RSRpcServices mockRpc = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        Mockito.when((Object)mockRpc.getConfiguration()).thenReturn((Object)CONF);
        RegionInfo mockRegionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)mockRpc.getRegion((HBaseProtos.RegionSpecifier)ArgumentMatchers.any())).thenReturn((Object)mockRegion);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.getTable()).thenReturn((Object)TableName.valueOf((String)"testQosFunctionForScanMethod"));
        RSAnnotationReadingPriorityFunction qosFunc = new RSAnnotationReadingPriorityFunction(mockRpc);
        int qos = qosFunc.getPriority(header, (Message)scanRequest, TestPriorityRpc.createSomeUser());
        Assert.assertEquals((String)Integer.toString(qos), (long)qos, (long)0L);
        scanBuilder = ClientProtos.ScanRequest.newBuilder();
        scanBuilder.setScannerId(12345L);
        scanRequest = scanBuilder.build();
        RegionScanner mockRegionScanner = (RegionScanner)Mockito.mock(RegionScanner.class);
        Mockito.when((Object)mockRpc.getScanner(12345L)).thenReturn((Object)mockRegionScanner);
        Mockito.when((Object)mockRegionScanner.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRpc.getRegion((HBaseProtos.RegionSpecifier)ArgumentMatchers.any())).thenReturn((Object)mockRegion);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.getTable()).thenReturn((Object)RegionInfoBuilder.FIRST_META_REGIONINFO.getTable());
        Assert.assertEquals((long)200L, (long)qosFunc.getPriority(header, (Message)scanRequest, TestPriorityRpc.createSomeUser()));
        Mockito.when((Object)mockRegionInfo.getTable()).thenReturn((Object)TableName.valueOf((String)"testQosFunctionForScanMethod"));
        Assert.assertEquals((long)0L, (long)qosFunc.getPriority(header, (Message)scanRequest, TestPriorityRpc.createSomeUser()));
    }

    private static User createSomeUser() {
        return User.createUserForTesting((Configuration)CONF, (String)"someuser", (String[])new String[]{"somegroup"});
    }
}

