/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.ipc.QosTestBase;
import org.apache.hadoop.hbase.regionserver.RSAnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRSQosFunction
extends QosTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSQosFunction.class);
    private Configuration conf;
    private RSRpcServices rpcServices;
    private RSAnnotationReadingPriorityFunction qosFunction;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
        this.rpcServices = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        Mockito.when((Object)this.rpcServices.getConfiguration()).thenReturn((Object)this.conf);
        this.qosFunction = new RSAnnotationReadingPriorityFunction(this.rpcServices);
    }

    @Test
    public void testPriority() {
        this.checkMethod(this.conf, "ReplicateWALEntry", 5, (AnnotationReadingPriorityFunction<?>)this.qosFunction);
        this.checkMethod(this.conf, "OpenRegion", 100, (AnnotationReadingPriorityFunction<?>)this.qosFunction);
        this.checkMethod(this.conf, "Multi", 0, (AnnotationReadingPriorityFunction<?>)this.qosFunction, (Message)ClientProtos.MultiRequest.getDefaultInstance());
    }

    @Test
    public void testAnnotations() {
        this.checkMethod(this.conf, "CloseRegion", 100, (AnnotationReadingPriorityFunction<?>)this.qosFunction);
        this.checkMethod(this.conf, "CompactRegion", 100, (AnnotationReadingPriorityFunction<?>)this.qosFunction);
        this.checkMethod(this.conf, "FlushRegion", 100, (AnnotationReadingPriorityFunction<?>)this.qosFunction);
    }
}

