/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionInfoDisplay;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestRegionInfo {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionInfo.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testIsStart() {
        Assert.assertTrue((boolean)RegionInfoBuilder.FIRST_META_REGIONINFO.isFirst());
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(Bytes.toBytes((String)"not_start")).build();
        Assert.assertFalse((boolean)ri.isFirst());
    }

    @Test
    public void testIsEnd() {
        Assert.assertTrue((boolean)RegionInfoBuilder.FIRST_META_REGIONINFO.isFirst());
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setEndKey(Bytes.toBytes((String)"not_end")).build();
        Assert.assertFalse((boolean)ri.isLast());
    }

    @Test
    public void testIsNext() {
        byte[] bytes = Bytes.toBytes((String)"row");
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setEndKey(bytes).build();
        RegionInfo ri2 = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(bytes).build();
        Assert.assertFalse((boolean)ri.isNext(RegionInfoBuilder.FIRST_META_REGIONINFO));
        Assert.assertTrue((boolean)ri.isNext(ri2));
    }

    @Test
    public void testIsOverlap() {
        byte[] a = Bytes.toBytes((String)"a");
        byte[] b = Bytes.toBytes((String)"b");
        byte[] c = Bytes.toBytes((String)"c");
        byte[] d = Bytes.toBytes((String)"d");
        RegionInfo all = RegionInfoBuilder.FIRST_META_REGIONINFO;
        RegionInfo ari = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setEndKey(a).build();
        RegionInfo abri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(a).setEndKey(b).build();
        RegionInfo adri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(a).setEndKey(d).build();
        RegionInfo cdri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(c).setEndKey(d).build();
        RegionInfo dri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(d).build();
        Assert.assertTrue((boolean)all.isOverlap(all));
        Assert.assertTrue((boolean)all.isOverlap(abri));
        Assert.assertFalse((boolean)abri.isOverlap(cdri));
        Assert.assertTrue((boolean)all.isOverlap(ari));
        Assert.assertFalse((boolean)ari.isOverlap(abri));
        Assert.assertFalse((boolean)ari.isOverlap(abri));
        Assert.assertTrue((boolean)ari.isOverlap(all));
        Assert.assertTrue((boolean)dri.isOverlap(all));
        Assert.assertTrue((boolean)abri.isOverlap(adri));
        Assert.assertFalse((boolean)dri.isOverlap(ari));
        Assert.assertTrue((boolean)abri.isOverlap(adri));
        Assert.assertTrue((boolean)adri.isOverlap(abri));
    }

    @Test
    public void testIsOverlaps() {
        byte[] a = Bytes.toBytes((String)"a");
        byte[] b = Bytes.toBytes((String)"b");
        byte[] c = Bytes.toBytes((String)"c");
        byte[] d = Bytes.toBytes((String)"d");
        byte[] e = Bytes.toBytes((String)"e");
        byte[] f = Bytes.toBytes((String)"f");
        RegionInfo ari = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setEndKey(a).build();
        RegionInfo abri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(a).setEndKey(b).build();
        RegionInfo eri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setEndKey(e).build();
        RegionInfo cdri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(c).setEndKey(d).build();
        RegionInfo efri = RegionInfoBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).setStartKey(e).setEndKey(f).build();
        Assert.assertFalse((boolean)ari.isOverlap(abri));
        Assert.assertTrue((boolean)abri.isOverlap(eri));
        Assert.assertFalse((boolean)cdri.isOverlap(efri));
        Assert.assertTrue((boolean)eri.isOverlap(ari));
    }

    @Test
    public void testPb() throws DeserializationException {
        RegionInfo hri = RegionInfoBuilder.FIRST_META_REGIONINFO;
        byte[] bytes = RegionInfo.toByteArray((RegionInfo)hri);
        RegionInfo pbhri = RegionInfo.parseFrom((byte[])bytes);
        Assert.assertTrue((boolean)hri.equals(pbhri));
    }

    @Test
    public void testReadAndWriteHRegionInfoFile() throws IOException, InterruptedException {
        HBaseTestingUtil htu = new HBaseTestingUtil();
        RegionInfo hri = RegionInfoBuilder.FIRST_META_REGIONINFO;
        Path basedir = htu.getDataTestDir();
        FSTableDescriptors fsTableDescriptors = new FSTableDescriptors(htu.getConfiguration());
        FSTableDescriptors.tryUpdateMetaTableDescriptor((Configuration)htu.getConfiguration());
        HRegion r = HBaseTestingUtil.createRegionAndWAL(hri, basedir, htu.getConfiguration(), fsTableDescriptors.get(TableName.META_TABLE_NAME));
        long modtime = this.getModTime(r);
        HBaseTestingUtil.closeRegionAndWAL(r);
        Thread.sleep(1001L);
        r = HRegion.openHRegion((Path)basedir, (RegionInfo)hri, (TableDescriptor)fsTableDescriptors.get(TableName.META_TABLE_NAME), null, (Configuration)htu.getConfiguration());
        long modtime2 = this.getModTime(r);
        Assert.assertEquals((long)modtime, (long)modtime2);
        RegionInfo deserializedHri = HRegionFileSystem.loadRegionInfoFileContent((FileSystem)r.getRegionFileSystem().getFileSystem(), (Path)r.getRegionFileSystem().getRegionDir());
        Assert.assertEquals((long)0L, (long)RegionInfo.COMPARATOR.compare(hri, deserializedHri));
        HBaseTestingUtil.closeRegionAndWAL(r);
    }

    long getModTime(HRegion r) throws IOException {
        FileStatus[] statuses = r.getRegionFileSystem().getFileSystem().listStatus(new Path(r.getRegionFileSystem().getRegionDir(), ".regioninfo"));
        Assert.assertTrue((statuses != null && statuses.length == 1 ? 1 : 0) != 0);
        return statuses[0].getModificationTime();
    }

    @Test
    public void testCreateHRegionInfoName() throws Exception {
        String tableName = this.name.getMethodName();
        TableName tn = TableName.valueOf((String)tableName);
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (String)id, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id), (Object)nameStr);
        String md5HashInHex = MD5Hash.getMD5AsHex((byte[])name);
        Assert.assertEquals((long)32L, (long)md5HashInHex.length());
        name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (String)id, (boolean)true);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "." + md5HashInHex + "."), (Object)nameStr);
    }

    @Test
    public void testContainsRange() {
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"g")).build();
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"a")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"c")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"g"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"z")));
        try {
            hri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"a"));
            Assert.fail((String)"Invalid range did not throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testContainsRangeForMetaTable() {
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).build();
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] row1 = Bytes.toBytes((String)"a,a,0");
        byte[] row2 = Bytes.toBytes((String)"aaaaa,,1");
        byte[] row3 = Bytes.toBytes((String)"aaaaa,\u0000\u0000,2");
        byte[] row4 = Bytes.toBytes((String)"aaaaa,\u0001,3");
        byte[] row5 = Bytes.toBytes((String)"aaaaa,a,4");
        byte[] row6 = Bytes.toBytes((String)"aaaaa,\u1000,5");
        Assert.assertTrue((boolean)hri.containsRange(startRow, startRow));
        Assert.assertTrue((boolean)hri.containsRange(row1, row2));
        Assert.assertTrue((boolean)hri.containsRange(row2, row3));
        Assert.assertTrue((boolean)hri.containsRange(row3, row4));
        Assert.assertTrue((boolean)hri.containsRange(row4, row5));
        Assert.assertTrue((boolean)hri.containsRange(row5, row6));
        Assert.assertTrue((boolean)hri.containsRange(startRow, row2));
        Assert.assertTrue((boolean)hri.containsRange(row1, row1));
        try {
            hri.containsRange(row3, row2);
            Assert.fail((String)"Invalid range did not throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLastRegionCompare() {
        RegionInfo hric;
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        RegionInfo hrip = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).setStartKey(Bytes.toBytes((String)"a")).build();
        Assert.assertTrue((hrip.compareTo(hric = RegionInfoBuilder.newBuilder((TableName)tableDesc.getTableName()).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build()) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetaTables() {
        Assert.assertTrue((boolean)RegionInfoBuilder.FIRST_META_REGIONINFO.isMetaRegion());
    }

    @Test
    public void testComparator() {
        RegionInfo newer;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo older = RegionInfoBuilder.newBuilder((TableName)tableName).setRegionId(0L).build();
        Assert.assertTrue((older.compareTo(newer = RegionInfoBuilder.newBuilder((TableName)tableName).setRegionId(1L).build()) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((newer.compareTo(older) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)older.compareTo(older));
        Assert.assertEquals((long)0L, (long)newer.compareTo(newer));
        RegionInfo a = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"a")).build();
        RegionInfo b = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"b")).build();
        Assert.assertNotEquals((long)0L, (long)a.compareTo(b));
        TableName t = TableName.valueOf((String)"t");
        byte[] midway = Bytes.toBytes((String)"midway");
        a = RegionInfoBuilder.newBuilder((TableName)t).setEndKey(midway).build();
        b = RegionInfoBuilder.newBuilder((TableName)t).setStartKey(midway).build();
        Assert.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.compareTo(a) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)a, (Object)a);
        Assert.assertEquals((long)0L, (long)a.compareTo(a));
        a = RegionInfoBuilder.newBuilder((TableName)t).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"d")).build();
        b = RegionInfoBuilder.newBuilder((TableName)t).setStartKey(Bytes.toBytes((String)"e")).setEndKey(Bytes.toBytes((String)"g")).build();
        Assert.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
        a = RegionInfoBuilder.newBuilder((TableName)t).setStartKey(Bytes.toBytes((String)"aaaa")).setEndKey(Bytes.toBytes((String)"dddd")).build();
        b = RegionInfoBuilder.newBuilder((TableName)t).setStartKey(Bytes.toBytes((String)"e")).setEndKey(Bytes.toBytes((String)"g")).build();
        Assert.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
        a = RegionInfoBuilder.newBuilder((TableName)t).setStartKey(Bytes.toBytes((String)"aaaa")).setEndKey(Bytes.toBytes((String)"dddd")).build();
        b = RegionInfoBuilder.newBuilder((TableName)t).setStartKey(Bytes.toBytes((String)"aaaa")).setEndKey(Bytes.toBytes((String)"eeee")).build();
        Assert.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegionNameForRegionReplicas() throws Exception {
        String tableName = this.name.getMethodName();
        TableName tn = TableName.valueOf((String)tableName);
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)0, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id), (Object)nameStr);
        name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)1, (boolean)false);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "_" + String.format("%04X", 1)), (Object)nameStr);
        name = RegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)65535, (boolean)false);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "_" + String.format("%04X", 65535)), (Object)nameStr);
    }

    @Test
    public void testParseName() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] startKey = Bytes.toBytes((String)"startKey");
        long regionId = EnvironmentEdgeManager.currentTime();
        int replicaId = 42;
        byte[] regionName = RegionInfo.createRegionName((TableName)tableName, (byte[])startKey, (long)regionId, (boolean)false);
        byte[][] fields = RegionInfo.parseRegionName((byte[])regionName);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[0]), (byte[])tableName.getName(), (byte[])fields[0]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[1]), (byte[])startKey, (byte[])fields[1]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[2]), (byte[])Bytes.toBytes((String)Long.toString(regionId)), (byte[])fields[2]);
        Assert.assertEquals((long)3L, (long)fields.length);
        regionName = RegionInfo.createRegionName((TableName)tableName, (byte[])startKey, (long)regionId, (int)replicaId, (boolean)false);
        fields = RegionInfo.parseRegionName((byte[])regionName);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[0]), (byte[])tableName.getName(), (byte[])fields[0]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[1]), (byte[])startKey, (byte[])fields[1]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[2]), (byte[])Bytes.toBytes((String)Long.toString(regionId)), (byte[])fields[2]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[3]), (byte[])Bytes.toBytes((String)String.format("%04X", replicaId)), (byte[])fields[3]);
    }

    @Test
    public void testConvert() {
        TableName tableName = TableName.valueOf((String)("ns1:" + this.name.getMethodName()));
        byte[] startKey = Bytes.toBytes((String)"startKey");
        byte[] endKey = Bytes.toBytes((String)"endKey");
        boolean split = false;
        long regionId = EnvironmentEdgeManager.currentTime();
        int replicaId = 42;
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).setEndKey(endKey).setSplit(split).setRegionId(regionId).setReplicaId(replicaId).build();
        RegionInfo convertedHri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)ProtobufUtil.toRegionInfo((RegionInfo)hri));
        Assert.assertEquals((Object)hri, (Object)convertedHri);
        HBaseProtos.RegionInfo info = HBaseProtos.RegionInfo.newBuilder().setTableName(HBaseProtos.TableName.newBuilder().setQualifier(UnsafeByteOperations.unsafeWrap((byte[])tableName.getQualifier())).setNamespace(UnsafeByteOperations.unsafeWrap((byte[])tableName.getNamespace())).build()).setStartKey(UnsafeByteOperations.unsafeWrap((byte[])startKey)).setEndKey(UnsafeByteOperations.unsafeWrap((byte[])endKey)).setSplit(split).setRegionId(regionId).build();
        convertedHri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)info);
        RegionInfo expectedHri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).setEndKey(endKey).setSplit(split).setRegionId(regionId).setReplicaId(0).build();
        Assert.assertEquals((Object)expectedHri, (Object)convertedHri);
    }

    @Test
    public void testRegionDetailsForDisplay() throws IOException {
        byte[] startKey = new byte[]{1, 1, 2, 3};
        byte[] endKey = new byte[]{1, 1, 2, 4};
        Configuration conf = new Configuration();
        conf.setBoolean("hbase.display.keys", false);
        RegionInfo h = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(startKey).setEndKey(endKey).build();
        this.checkEquality(h, conf);
        h = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(startKey).setEndKey(endKey).setRegionId(EnvironmentEdgeManager.currentTime()).setReplicaId(1).build();
        this.checkEquality(h, conf);
        Assert.assertArrayEquals((byte[])RegionInfoDisplay.HIDDEN_END_KEY, (byte[])RegionInfoDisplay.getEndKeyForDisplay((RegionInfo)h, (Configuration)conf));
        Assert.assertArrayEquals((byte[])RegionInfoDisplay.HIDDEN_START_KEY, (byte[])RegionInfoDisplay.getStartKeyForDisplay((RegionInfo)h, (Configuration)conf));
        RegionState state = RegionState.createForTesting((RegionInfo)h, (RegionState.State)RegionState.State.OPEN);
        String descriptiveNameForDisplay = RegionInfoDisplay.getDescriptiveNameFromRegionStateForDisplay((RegionState)state, (Configuration)conf);
        this.checkDescriptiveNameEquality(descriptiveNameForDisplay, state.toDescriptiveString(), startKey);
        conf.setBoolean("hbase.display.keys", true);
        Assert.assertArrayEquals((byte[])endKey, (byte[])RegionInfoDisplay.getEndKeyForDisplay((RegionInfo)h, (Configuration)conf));
        Assert.assertArrayEquals((byte[])startKey, (byte[])RegionInfoDisplay.getStartKeyForDisplay((RegionInfo)h, (Configuration)conf));
        Assert.assertEquals((Object)state.toDescriptiveString(), (Object)RegionInfoDisplay.getDescriptiveNameFromRegionStateForDisplay((RegionState)state, (Configuration)conf));
    }

    private void checkDescriptiveNameEquality(String descriptiveNameForDisplay, String origDesc, byte[] startKey) {
        String firstPart = descriptiveNameForDisplay.substring(0, descriptiveNameForDisplay.indexOf(new String(RegionInfoDisplay.HIDDEN_START_KEY)));
        String secondPart = descriptiveNameForDisplay.substring(descriptiveNameForDisplay.indexOf(new String(RegionInfoDisplay.HIDDEN_START_KEY)) + RegionInfoDisplay.HIDDEN_START_KEY.length);
        String firstPartOrig = origDesc.substring(0, origDesc.indexOf(Bytes.toStringBinary((byte[])startKey)));
        String secondPartOrig = origDesc.substring(origDesc.indexOf(Bytes.toStringBinary((byte[])startKey)) + Bytes.toStringBinary((byte[])startKey).length());
        assert (firstPart.equals(firstPartOrig));
        assert (secondPart.equals(secondPartOrig));
    }

    private void checkEquality(RegionInfo h, Configuration conf) throws IOException {
        byte[] modifiedRegionName = RegionInfoDisplay.getRegionNameForDisplay((RegionInfo)h, (Configuration)conf);
        byte[][] modifiedRegionNameParts = RegionInfo.parseRegionName((byte[])modifiedRegionName);
        byte[][] regionNameParts = RegionInfo.parseRegionName((byte[])h.getRegionName());
        assert (modifiedRegionNameParts.length == regionNameParts.length);
        for (int i = 0; i < regionNameParts.length; ++i) {
            if (i != 1) {
                Assert.assertArrayEquals((byte[])regionNameParts[i], (byte[])modifiedRegionNameParts[i]);
                continue;
            }
            Assert.assertNotEquals((long)regionNameParts[i][0], (long)modifiedRegionNameParts[i][0]);
            Assert.assertArrayEquals((byte[])modifiedRegionNameParts[1], (byte[])RegionInfoDisplay.getStartKeyForDisplay((RegionInfo)h, (Configuration)conf));
        }
    }
}

