/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionServerUseIp {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerUseIp.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionServerUseIp.class);
    private HBaseTestingUtil TEST_UTIL;
    private SingleProcessHBaseCluster CLUSTER;
    private static final int NUM_MASTERS = 1;
    private static final int NUM_RS = 1;

    @Before
    public void setup() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.server.useip.enabled", true);
        this.TEST_UTIL = new HBaseTestingUtil(conf);
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(1).numRegionServers(1).numDataNodes(1).build();
        this.CLUSTER = this.TEST_UTIL.startMiniCluster(option);
    }

    @After
    public void teardown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRegionServerUseIp() throws Exception {
        String hostname = this.CLUSTER.getRegionServer(0).getServerName().getHostname();
        String ip = InetAddress.getByName(hostname).getHostAddress();
        LOG.info("hostname= " + hostname + " ,ip=" + ip);
        Assert.assertEquals((Object)ip, (Object)hostname);
    }
}

