/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.regionreplication;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.regionreplication.RegionReplicationSink;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestRegionReplicationForFlushMarker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicationForFlushMarker.class);
    private static final byte[] FAMILY = Bytes.toBytes((String)"family_test");
    private static final byte[] QUAL = Bytes.toBytes((String)"qualifier_test");
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();
    private static final int NB_SERVERS = 2;
    private static TableName tableName = TableName.valueOf((String)"TestRegionReplicationForFlushMarker");
    private static volatile boolean startTest = false;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setClass("hbase.hregion.impl", HRegionForTest.class, HRegion.class);
        conf.setInt("hbase.region.read-replica.sink.retries.number", 1);
        conf.setLong("hbase.region.read-replica.sink.rpc.timeout.ms", 600000L);
        conf.setLong("hbase.region.read-replica.sink.operation.timeout.ms", 1200000L);
        conf.setLong("hbase.region.read-replica.sink.meta-edit.rpc.timeout.ms", 600000L);
        conf.setLong("hbase.region.read-replica.sink.meta-edit.operation.timeout.ms", 1200000L);
        conf.setBoolean("hbase.region.replica.wait.for.primary.flush", false);
        conf.setInt("hbase.region.read-replica.sink.flush.min-interval.secs", 3);
        HTU.startMiniCluster(StartTestingClusterOption.builder().rsClass(RSForTest.class).numRegionServers(2).build());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        HTU.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCannotFlushMarker() throws Exception {
        HRegionForTest[] regions = this.createTable();
        RegionReplicationSink regionReplicationSink = (RegionReplicationSink)regions[0].getRegionReplicationSink().get();
        Assert.assertTrue((regionReplicationSink != null ? 1 : 0) != 0);
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName("TestRegionReplicationForFlushMarker");
        try {
            byte[] rowKey1 = Bytes.toBytes((int)1);
            startTest = true;
            regions[0].put(new Put(rowKey1).addColumn(FAMILY, QUAL, Bytes.toBytes((int)1)));
            regions[0].cyclicBarrier.await();
            Assert.assertTrue((regions[0].prepareFlushCounter.get() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)regionReplicationSink.getFailedReplicas().isEmpty());
        }
        finally {
            startTest = false;
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private HRegionForTest[] createTable() throws Exception {
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(2).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        HTU.getAdmin().createTable(tableDescriptor);
        HRegionForTest[] regions = new HRegionForTest[2];
        for (int i = 0; i < 2; ++i) {
            HRegionServer rs = HTU.getMiniHBaseCluster().getRegionServer(i);
            List onlineRegions = rs.getRegions(tableName);
            for (HRegion region : onlineRegions) {
                int replicaId = region.getRegionInfo().getReplicaId();
                Assert.assertTrue((regions[replicaId] == null ? 1 : 0) != 0);
                regions[region.getRegionInfo().getReplicaId()] = (HRegionForTest)region;
            }
        }
        for (HRegionForTest region : regions) {
            Assert.assertNotNull((Object)((Object)region));
        }
        return regions;
    }

    public static final class RSForTest
    extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer {
        public RSForTest(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new ErrorReplayRSRpcServices(this);
        }
    }

    public static final class ErrorReplayRSRpcServices
    extends RSRpcServices {
        private static final AtomicInteger callCounter = new AtomicInteger(0);

        public ErrorReplayRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public AdminProtos.ReplicateWALEntryResponse replicateToReplica(RpcController rpcController, AdminProtos.ReplicateWALEntryRequest replicateWALEntryRequest) throws ServiceException {
            HRegion region;
            if (!startTest) {
                return super.replicateToReplica(rpcController, replicateWALEntryRequest);
            }
            List entries = replicateWALEntryRequest.getEntryList();
            if (CollectionUtils.isEmpty((Collection)entries)) {
                return AdminProtos.ReplicateWALEntryResponse.getDefaultInstance();
            }
            ByteString regionName = ((AdminProtos.WALEntry)entries.get(0)).getKey().getEncodedRegionName();
            try {
                region = ((HRegionServer)this.server).getRegionByEncodedName(regionName.toStringUtf8());
            }
            catch (NotServingRegionException e) {
                throw new ServiceException((Throwable)e);
            }
            if (!region.getRegionInfo().getTable().equals((Object)tableName) || region.getRegionInfo().getReplicaId() != 1) {
                return super.replicateToReplica(rpcController, replicateWALEntryRequest);
            }
            int count = callCounter.incrementAndGet();
            if (count > 2) {
                return super.replicateToReplica(rpcController, replicateWALEntryRequest);
            }
            throw new ServiceException((Throwable)new DoNotRetryIOException("Inject error!"));
        }
    }

    public static final class HRegionForTest
    extends HRegion {
        static final String USER_THREAD_NAME = "TestRegionReplicationForFlushMarker";
        final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
        final AtomicInteger prepareFlushCounter = new AtomicInteger(0);

        public HRegionForTest(HRegionFileSystem fs, WAL wal, Configuration confParam, TableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, confParam, htd, rsServices);
        }

        public HRegionForTest(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        public void setRegionReplicationSink(RegionReplicationSink regionReplicationSink) {
            this.regionReplicationSink = Optional.of(regionReplicationSink);
        }

        protected void writeRegionOpenMarker(WAL wal, long openSeqId) throws IOException {
        }

        protected HRegion.PrepareFlushResult internalPrepareFlushCache(WAL wal, long myseqid, Collection<HStore> storesToFlush, MonitoredTask status, boolean writeFlushWalMarker, FlushLifeCycleTracker tracker) throws IOException {
            if (!startTest) {
                return super.internalPrepareFlushCache(wal, myseqid, storesToFlush, status, writeFlushWalMarker, tracker);
            }
            if (this.getRegionInfo().getReplicaId() != 0) {
                return super.internalPrepareFlushCache(wal, myseqid, storesToFlush, status, writeFlushWalMarker, tracker);
            }
            try {
                HRegion.PrepareFlushResult result = super.internalPrepareFlushCache(wal, myseqid, storesToFlush, status, writeFlushWalMarker, tracker);
                this.prepareFlushCounter.incrementAndGet();
                if (this.prepareFlushCounter.get() == 2 && result.getResult() != null && result.getResult().getResult() == HRegion.FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY) {
                    this.cyclicBarrier.await();
                }
                return result;
            }
            catch (InterruptedException | BrokenBarrierException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

