/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.regionreplication;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.regionserver.regionreplication.RegionReplicationBufferManager;
import org.apache.hadoop.hbase.regionserver.regionreplication.RegionReplicationSink;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionReplicationSink {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicationSink.class);
    private Configuration conf;
    private TableDescriptor td;
    private RegionInfo primary;
    private Runnable flushRequester;
    private AsyncClusterConnection conn;
    private RegionReplicationBufferManager manager;
    private RegionReplicationSink sink;
    @Rule
    public final TableNameTestRule name = new TableNameTestRule();

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
        this.conf.setLong("hbase.region.read-replica.sink.nb.capacity", 5L);
        this.conf.setLong("hbase.region.read-replica.sink.size.capacity", 0x100000L);
        this.td = TableDescriptorBuilder.newBuilder((TableName)this.name.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"cf")).setRegionReplication(3).build();
        this.primary = RegionInfoBuilder.newBuilder((TableName)this.name.getTableName()).build();
        this.flushRequester = (Runnable)Mockito.mock(Runnable.class);
        this.conn = (AsyncClusterConnection)Mockito.mock(AsyncClusterConnection.class);
        this.manager = (RegionReplicationBufferManager)Mockito.mock(RegionReplicationBufferManager.class);
        this.sink = new RegionReplicationSink(this.conf, this.primary, this.td, this.manager, this.flushRequester, this.conn);
    }

    @After
    public void tearDown() throws InterruptedException {
        this.sink.stop();
        this.sink.waitUntilStopped();
    }

    @Test
    public void testNormal() {
        MutableInt next = new MutableInt(0);
        List<CompletableFuture> futures = Arrays.asList(new CompletableFuture(), new CompletableFuture());
        Mockito.when((Object)this.conn.replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).then(i -> (CompletableFuture)futures.get(next.getAndIncrement()));
        ServerCall rpcCall = (ServerCall)Mockito.mock(ServerCall.class);
        WALKeyImpl key = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)key.estimatedSerializedSizeOf()).thenReturn((Object)100L);
        WALEdit edit = (WALEdit)Mockito.mock(WALEdit.class);
        Mockito.when((Object)edit.estimatedSerializedSizeOf()).thenReturn((Object)1000L);
        Mockito.when((Object)this.manager.increase(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.sink.add(key, edit, rpcCall);
        ((RegionReplicationBufferManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)1))).increase(ArgumentMatchers.anyLong());
        ((ServerCall)Mockito.verify((Object)rpcCall, (VerificationMode)Mockito.times((int)1))).retainByWAL();
        Assert.assertEquals((long)1100L, (long)this.sink.pendingSize());
        futures.get(0).complete(null);
        ((RegionReplicationBufferManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).decrease(ArgumentMatchers.anyLong());
        ((ServerCall)Mockito.verify((Object)rpcCall, (VerificationMode)Mockito.never())).releaseByWAL();
        Assert.assertEquals((long)1100L, (long)this.sink.pendingSize());
        futures.get(1).complete(null);
        ((RegionReplicationBufferManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)1))).decrease(ArgumentMatchers.anyLong());
        ((ServerCall)Mockito.verify((Object)rpcCall, (VerificationMode)Mockito.times((int)1))).releaseByWAL();
        Assert.assertEquals((long)0L, (long)this.sink.pendingSize());
    }

    @Test
    public void testDropEdits() {
        MutableInt next = new MutableInt(0);
        List<CompletableFuture> futures = Arrays.asList(new CompletableFuture(), new CompletableFuture());
        Mockito.when((Object)this.conn.replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).then(i -> (CompletableFuture)futures.get(next.getAndIncrement()));
        ServerCall rpcCall1 = (ServerCall)Mockito.mock(ServerCall.class);
        WALKeyImpl key1 = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)key1.estimatedSerializedSizeOf()).thenReturn((Object)100L);
        WALEdit edit1 = (WALEdit)Mockito.mock(WALEdit.class);
        Mockito.when((Object)edit1.estimatedSerializedSizeOf()).thenReturn((Object)1000L);
        Mockito.when((Object)this.manager.increase(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.sink.add(key1, edit1, rpcCall1);
        ((RegionReplicationBufferManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)1))).increase(ArgumentMatchers.anyLong());
        ((RegionReplicationBufferManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).decrease(ArgumentMatchers.anyLong());
        ((ServerCall)Mockito.verify((Object)rpcCall1, (VerificationMode)Mockito.times((int)1))).retainByWAL();
        Assert.assertEquals((long)1100L, (long)this.sink.pendingSize());
        ServerCall rpcCall2 = (ServerCall)Mockito.mock(ServerCall.class);
        WALKeyImpl key2 = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)key2.estimatedSerializedSizeOf()).thenReturn((Object)200L);
        WALEdit edit2 = (WALEdit)Mockito.mock(WALEdit.class);
        Mockito.when((Object)edit2.estimatedSerializedSizeOf()).thenReturn((Object)2000L);
        this.sink.add(key2, edit2, rpcCall2);
        ((RegionReplicationBufferManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)2))).increase(ArgumentMatchers.anyLong());
        ((RegionReplicationBufferManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).decrease(ArgumentMatchers.anyLong());
        ((ServerCall)Mockito.verify((Object)rpcCall2, (VerificationMode)Mockito.times((int)1))).retainByWAL();
        Assert.assertEquals((long)3300L, (long)this.sink.pendingSize());
        ServerCall rpcCall3 = (ServerCall)Mockito.mock(ServerCall.class);
        WALKeyImpl key3 = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)key3.estimatedSerializedSizeOf()).thenReturn((Object)200L);
        WALEdit edit3 = (WALEdit)Mockito.mock(WALEdit.class);
        Mockito.when((Object)edit3.estimatedSerializedSizeOf()).thenReturn((Object)3000L);
        Mockito.when((Object)this.manager.increase(ArgumentMatchers.anyLong())).thenReturn((Object)false);
        this.sink.add(key3, edit3, rpcCall3);
        ((RegionReplicationBufferManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)3))).increase(ArgumentMatchers.anyLong());
        ((RegionReplicationBufferManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)1))).decrease(ArgumentMatchers.anyLong());
        ((ServerCall)Mockito.verify((Object)rpcCall3, (VerificationMode)Mockito.times((int)1))).retainByWAL();
        ((ServerCall)Mockito.verify((Object)rpcCall3, (VerificationMode)Mockito.times((int)1))).releaseByWAL();
        ((ServerCall)Mockito.verify((Object)rpcCall2, (VerificationMode)Mockito.times((int)1))).releaseByWAL();
        Assert.assertEquals((long)1100L, (long)this.sink.pendingSize());
        ((Runnable)Mockito.verify((Object)this.flushRequester, (VerificationMode)Mockito.times((int)1))).run();
        futures.forEach(f -> f.complete(null));
        ((RegionReplicationBufferManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)2))).decrease(ArgumentMatchers.anyLong());
        ((ServerCall)Mockito.verify((Object)rpcCall1, (VerificationMode)Mockito.times((int)1))).releaseByWAL();
        Assert.assertEquals((long)0L, (long)this.sink.pendingSize());
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
    }

    @Test
    public void testNotAddToFailedReplicas() {
        MutableInt next = new MutableInt(0);
        List futures = Stream.generate(() -> new CompletableFuture()).limit(4L).collect(Collectors.toList());
        Mockito.when((Object)this.conn.replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).then(i -> (CompletableFuture)futures.get(next.getAndIncrement()));
        ServerCall rpcCall1 = (ServerCall)Mockito.mock(ServerCall.class);
        WALKeyImpl key1 = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)key1.estimatedSerializedSizeOf()).thenReturn((Object)100L);
        Mockito.when((Object)key1.getSequenceId()).thenReturn((Object)1L);
        WALEdit edit1 = (WALEdit)Mockito.mock(WALEdit.class);
        Mockito.when((Object)edit1.estimatedSerializedSizeOf()).thenReturn((Object)1000L);
        Mockito.when((Object)this.manager.increase(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.sink.add(key1, edit1, rpcCall1);
        ServerCall rpcCall2 = (ServerCall)Mockito.mock(ServerCall.class);
        WALKeyImpl key2 = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)key2.estimatedSerializedSizeOf()).thenReturn((Object)200L);
        Mockito.when((Object)key2.getSequenceId()).thenReturn((Object)3L);
        Map committedFiles = this.td.getColumnFamilyNames().stream().collect(Collectors.toMap(Function.identity(), k -> Collections.emptyList(), (u, v) -> {
            throw new IllegalStateException();
        }, () -> new TreeMap(Bytes.BYTES_COMPARATOR)));
        WALProtos.FlushDescriptor fd = ProtobufUtil.toFlushDescriptor((WALProtos.FlushDescriptor.FlushAction)WALProtos.FlushDescriptor.FlushAction.START_FLUSH, (RegionInfo)this.primary, (long)2L, (Map)committedFiles);
        WALEdit edit2 = WALEdit.createFlushWALEdit((RegionInfo)this.primary, (WALProtos.FlushDescriptor)fd);
        this.sink.add(key2, edit2, rpcCall2);
        ((CompletableFuture)futures.get(0)).complete(null);
        ((CompletableFuture)futures.get(1)).completeExceptionally(new IOException("inject error"));
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)4))).replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CompletableFuture)futures.get(2)).complete(null);
        ((CompletableFuture)futures.get(3)).complete(null);
        Assert.assertEquals((long)0L, (long)this.sink.pendingSize());
    }

    @Test
    public void testAddToFailedReplica() {
        MutableInt next = new MutableInt(0);
        List futures = Stream.generate(() -> new CompletableFuture()).limit(5L).collect(Collectors.toList());
        Mockito.when((Object)this.conn.replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).then(i -> (CompletableFuture)futures.get(next.getAndIncrement()));
        ServerCall rpcCall1 = (ServerCall)Mockito.mock(ServerCall.class);
        WALKeyImpl key1 = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)key1.estimatedSerializedSizeOf()).thenReturn((Object)100L);
        Mockito.when((Object)key1.getSequenceId()).thenReturn((Object)1L);
        WALEdit edit1 = (WALEdit)Mockito.mock(WALEdit.class);
        Mockito.when((Object)edit1.estimatedSerializedSizeOf()).thenReturn((Object)1000L);
        Mockito.when((Object)this.manager.increase(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.sink.add(key1, edit1, rpcCall1);
        ServerCall rpcCall2 = (ServerCall)Mockito.mock(ServerCall.class);
        WALKeyImpl key2 = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)key2.estimatedSerializedSizeOf()).thenReturn((Object)200L);
        Mockito.when((Object)key2.getSequenceId()).thenReturn((Object)1L);
        WALEdit edit2 = (WALEdit)Mockito.mock(WALEdit.class);
        Mockito.when((Object)edit2.estimatedSerializedSizeOf()).thenReturn((Object)2000L);
        Mockito.when((Object)this.manager.increase(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        this.sink.add(key2, edit2, rpcCall2);
        ((CompletableFuture)futures.get(0)).complete(null);
        ((CompletableFuture)futures.get(1)).completeExceptionally(new IOException("inject error"));
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)3))).replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CompletableFuture)futures.get(2)).complete(null);
        Assert.assertEquals((long)0L, (long)this.sink.pendingSize());
        ServerCall rpcCall3 = (ServerCall)Mockito.mock(ServerCall.class);
        WALKeyImpl key3 = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)key3.estimatedSerializedSizeOf()).thenReturn((Object)200L);
        Mockito.when((Object)key3.getSequenceId()).thenReturn((Object)3L);
        Map committedFiles = this.td.getColumnFamilyNames().stream().collect(Collectors.toMap(Function.identity(), k -> Collections.emptyList(), (u, v) -> {
            throw new IllegalStateException();
        }, () -> new TreeMap(Bytes.BYTES_COMPARATOR)));
        WALProtos.FlushDescriptor fd = ProtobufUtil.toFlushDescriptor((WALProtos.FlushDescriptor.FlushAction)WALProtos.FlushDescriptor.FlushAction.START_FLUSH, (RegionInfo)this.primary, (long)2L, (Map)committedFiles);
        WALEdit edit3 = WALEdit.createFlushWALEdit((RegionInfo)this.primary, (WALProtos.FlushDescriptor)fd);
        this.sink.add(key3, edit3, rpcCall3);
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)5))).replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CompletableFuture)futures.get(3)).complete(null);
        ((CompletableFuture)futures.get(4)).complete(null);
        Assert.assertEquals((long)0L, (long)this.sink.pendingSize());
    }

    @Test
    public void testSizeCapacity() {
        MutableInt next = new MutableInt(0);
        List futures = Stream.generate(() -> new CompletableFuture()).limit(6L).collect(Collectors.toList());
        Mockito.when((Object)this.conn.replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).then(i -> (CompletableFuture)futures.get(next.getAndIncrement()));
        for (int i2 = 0; i2 < 3; ++i2) {
            ServerCall rpcCall = (ServerCall)Mockito.mock(ServerCall.class);
            WALKeyImpl key = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
            Mockito.when((Object)key.estimatedSerializedSizeOf()).thenReturn((Object)100L);
            Mockito.when((Object)key.getSequenceId()).thenReturn((Object)((long)i2 + 1L));
            WALEdit edit = (WALEdit)Mockito.mock(WALEdit.class);
            Mockito.when((Object)edit.estimatedSerializedSizeOf()).thenReturn((Object)((long)(i2 + 1) * 600L * 1024L));
            Mockito.when((Object)this.manager.increase(ArgumentMatchers.anyLong())).thenReturn((Object)true);
            this.sink.add(key, edit, rpcCall);
        }
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CompletableFuture)futures.get(0)).complete(null);
        ((CompletableFuture)futures.get(1)).complete(null);
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)4))).replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CompletableFuture)futures.get(2)).complete(null);
        ((CompletableFuture)futures.get(3)).complete(null);
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)6))).replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CompletableFuture)futures.get(4)).complete(null);
        ((CompletableFuture)futures.get(5)).complete(null);
        Assert.assertEquals((long)0L, (long)this.sink.pendingSize());
    }

    @Test
    public void testCountCapacity() {
        MutableInt next = new MutableInt(0);
        List futures = Stream.generate(() -> new CompletableFuture()).limit(6L).collect(Collectors.toList());
        Mockito.when((Object)this.conn.replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).then(i -> (CompletableFuture)futures.get(next.getAndIncrement()));
        for (int i2 = 0; i2 < 7; ++i2) {
            ServerCall rpcCall = (ServerCall)Mockito.mock(ServerCall.class);
            WALKeyImpl key = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
            Mockito.when((Object)key.estimatedSerializedSizeOf()).thenReturn((Object)100L);
            Mockito.when((Object)key.getSequenceId()).thenReturn((Object)((long)i2 + 1L));
            WALEdit edit = (WALEdit)Mockito.mock(WALEdit.class);
            Mockito.when((Object)edit.estimatedSerializedSizeOf()).thenReturn((Object)1000L);
            Mockito.when((Object)this.manager.increase(ArgumentMatchers.anyLong())).thenReturn((Object)true);
            this.sink.add(key, edit, rpcCall);
        }
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CompletableFuture)futures.get(0)).complete(null);
        ((CompletableFuture)futures.get(1)).complete(null);
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)4))).replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CompletableFuture)futures.get(2)).complete(null);
        ((CompletableFuture)futures.get(3)).complete(null);
        ((AsyncClusterConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)6))).replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CompletableFuture)futures.get(4)).complete(null);
        ((CompletableFuture)futures.get(5)).complete(null);
        Assert.assertEquals((long)0L, (long)this.sink.pendingSize());
    }
}

