/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.EOFException;
import java.io.IOException;
import java.util.stream.IntStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufWALStreamReader;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.Assert;

public final class ProtobufLogTestHelper {
    private ProtobufLogTestHelper() {
    }

    private static byte[] toValue(int prefix, int suffix) {
        return Bytes.toBytes((String)(prefix + "-" + suffix));
    }

    private static RegionInfo toRegionInfo(TableName tableName) {
        return RegionInfoBuilder.newBuilder((TableName)tableName).setRegionId(1024L).build();
    }

    private static WAL.Entry generateEdit(int i, RegionInfo hri, TableName tableName, byte[] row, int columnCount, long timestamp, MultiVersionConcurrencyControl mvcc) {
        WALKeyImpl key = new WALKeyImpl(hri.getEncodedNameAsBytes(), tableName, (long)i, timestamp, HConstants.DEFAULT_CLUSTER_ID, mvcc);
        WALEdit edit = new WALEdit();
        int prefix = i;
        IntStream.range(0, columnCount).mapToObj(j -> ProtobufLogTestHelper.toValue(prefix, j)).map(value -> new KeyValue(row, row, row, timestamp, value)).forEachOrdered(arg_0 -> ((WALEdit)edit).add(arg_0));
        return new WAL.Entry(key, edit);
    }

    public static void doWrite(WALProvider.Writer writer, boolean withTrailer, TableName tableName, int columnCount, int recordCount, byte[] row, long timestamp) throws IOException {
        RegionInfo hri = ProtobufLogTestHelper.toRegionInfo(tableName);
        for (int i = 0; i < recordCount; ++i) {
            writer.append(ProtobufLogTestHelper.generateEdit(i, hri, tableName, row, columnCount, timestamp, null));
        }
        writer.sync(false);
        if (withTrailer) {
            writer.close();
        }
    }

    public static void doWrite(WAL wal, RegionInfo hri, TableName tableName, int columnCount, int recordCount, byte[] row, long timestamp, MultiVersionConcurrencyControl mvcc) throws IOException {
        for (int i = 0; i < recordCount; ++i) {
            WAL.Entry entry = ProtobufLogTestHelper.generateEdit(i, hri, tableName, row, columnCount, timestamp, mvcc);
            wal.appendData(hri, entry.getKey(), entry.getEdit());
        }
        wal.sync();
    }

    public static void doRead(ProtobufWALStreamReader reader, boolean withTrailer, RegionInfo hri, TableName tableName, int columnCount, int recordCount, byte[] row, long timestamp) throws IOException {
        if (withTrailer) {
            Assert.assertNotNull((Object)reader.trailer);
        } else {
            Assert.assertNull((Object)reader.trailer);
        }
        for (int i = 0; i < recordCount; ++i) {
            WAL.Entry entry = reader.next();
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)columnCount, (long)entry.getEdit().size());
            Assert.assertArrayEquals((byte[])hri.getEncodedNameAsBytes(), (byte[])entry.getKey().getEncodedRegionName());
            Assert.assertEquals((Object)tableName, (Object)entry.getKey().getTableName());
            int idx = 0;
            for (Cell val : entry.getEdit().getCells()) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])row, (int)0, (int)row.length, (byte[])val.getRowArray(), (int)val.getRowOffset(), (int)val.getRowLength()));
                Assert.assertArrayEquals((byte[])ProtobufLogTestHelper.toValue(i, idx), (byte[])CellUtil.cloneValue((Cell)val));
                ++idx;
            }
        }
        if (withTrailer) {
            Assert.assertNull((Object)reader.next());
        } else {
            Assert.assertThrows(EOFException.class, () -> reader.next());
        }
    }

    public static void doRead(ProtobufWALStreamReader reader, boolean withTrailer, TableName tableName, int columnCount, int recordCount, byte[] row, long timestamp) throws IOException {
        ProtobufLogTestHelper.doRead(reader, withTrailer, ProtobufLogTestHelper.toRegionInfo(tableName), tableName, columnCount, recordCount, row, timestamp);
    }
}

