/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.ExpAsStringVisibilityLabelServiceImpl;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.TestVisibilityLabelsReplication;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityReplication;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestVisibilityLabelReplicationWithExpAsString
extends TestVisibilityLabelsReplication {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVisibilityLabelReplicationWithExpAsString.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestVisibilityLabelReplicationWithExpAsString.class);

    @Override
    @Before
    public void setup() throws Exception {
        TestVisibilityLabelReplicationWithExpAsString.expected[0] = 4;
        TestVisibilityLabelReplicationWithExpAsString.expected[1] = 6;
        TestVisibilityLabelReplicationWithExpAsString.expected[2] = 4;
        TestVisibilityLabelReplicationWithExpAsString.expected[3] = 0;
        TestVisibilityLabelReplicationWithExpAsString.expected[3] = 3;
        TestVisibilityLabelReplicationWithExpAsString.expectedVisString[0] = "(\"public\"&\"secret\"&\"topsecret\")|(\"confidential\"&\"topsecret\")";
        TestVisibilityLabelReplicationWithExpAsString.expectedVisString[1] = "(\"private\"&\"public\")|(\"private\"&\"topsecret\")|(\"confidential\"&\"public\")|(\"confidential\"&\"topsecret\")";
        TestVisibilityLabelReplicationWithExpAsString.expectedVisString[2] = "(!\"topsecret\"&\"secret\")|(!\"topsecret\"&\"confidential\")";
        TestVisibilityLabelReplicationWithExpAsString.expectedVisString[3] = "(\"secret\"&\"\u00a9ABC\\\"\u0941\\\\secret\\\"'&\\\\\")";
        conf = HBaseConfiguration.create();
        conf.setInt("hfile.format.version", 3);
        conf.set("zookeeper.znode.parent", "/1");
        conf.setInt("replication.source.size.capacity", 10240);
        conf.setLong("replication.source.sleepforretries", 100L);
        conf.setInt("hbase.regionserver.maxlogs", 10);
        conf.setLong("hbase.master.logcleaner.ttl", 10L);
        conf.setInt("zookeeper.recovery.retry", 1);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf.setLong("hbase.server.thread.wakefrequency", 100L);
        conf.setInt("replication.stats.thread.period.seconds", 5);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        TestVisibilityLabelReplicationWithExpAsString.setVisibilityLabelServiceImpl(conf, ExpAsStringVisibilityLabelServiceImpl.class);
        conf.setStrings("hbase.replication.rpc.codec", new String[]{KeyValueCodecWithTags.class.getName()});
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.set("hbase.coprocessor.regionserver.classes", VisibilityReplication.class.getName());
        conf.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestVisibilityLabelsReplication.SimpleCP.class.getName()});
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", "admin");
        conf.set("hbase.superuser", User.getCurrent().getShortName());
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)User.getCurrent().getShortName(), (String[])new String[]{"supergroup"});
        User.createUserForTesting((Configuration)conf, (String)User.getCurrent().getShortName(), (String[])new String[]{"supergroup"});
        USER1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        TEST_UTIL = new HBaseTestingUtil(conf);
        TEST_UTIL.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = TEST_UTIL.getZkCluster();
        zkw1 = new ZKWatcher(conf, "cluster1", null, true);
        conf1 = HBaseConfiguration.create((Configuration)conf);
        conf1.setInt("hfile.format.version", 3);
        conf1.set("zookeeper.znode.parent", "/2");
        conf1.setInt("hbase.client.retries.number", 6);
        conf1.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf1.setStrings("hbase.replication.rpc.codec", new String[]{KeyValueCodecWithTags.class.getName()});
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestVisibilityLabelsReplication.TestCoprocessorForTagsAtSink.class.getName()});
        TestVisibilityLabelReplicationWithExpAsString.setVisibilityLabelServiceImpl(conf1, ExpAsStringVisibilityLabelServiceImpl.class);
        TEST_UTIL1 = new HBaseTestingUtil(conf1);
        TEST_UTIL1.setZkCluster(miniZK);
        zkw2 = new ZKWatcher(conf1, "cluster2", null, true);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TEST_UTIL1.startMiniCluster(1);
        admin = TEST_UTIL.getAdmin();
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(TEST_UTIL1.getClusterKey()).build();
        admin.addReplicationPeer("2", rpc);
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])fam).setScope(1).build()).build();
        try (Admin hBaseAdmin = TEST_UTIL.getAdmin();){
            hBaseAdmin.createTable(tableDescriptor);
        }
        var5_5 = null;
        try (Admin hBaseAdmin1 = TEST_UTIL1.getAdmin();){
            hBaseAdmin1.createTable(tableDescriptor);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        TestVisibilityLabelReplicationWithExpAsString.addLabels();
        TestVisibilityLabelReplicationWithExpAsString.setAuths(conf);
        TestVisibilityLabelReplicationWithExpAsString.setAuths(conf1);
    }

    protected static void setVisibilityLabelServiceImpl(Configuration conf, Class clazz) {
        conf.setClass("hbase.regionserver.visibility.label.service.class", clazz, VisibilityLabelService.class);
    }

    @Override
    protected void verifyGet(final byte[] row, final String visString, final int expected, final boolean nullExpected, final String ... auths) throws IOException, InterruptedException {
        PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

            /*
             * Exception decompiling
             */
            @Override
            public Void run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        USER1.runAs((PrivilegedExceptionAction)scanAction);
    }
}

