/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.TestHRegionServerBulkLoad;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.token.Token;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
public class TestBulkLoadHFilesSplitRecovery {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBulkLoadHFilesSplitRecovery.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHRegionServerBulkLoad.class);
    static HBaseTestingUtil util;
    static boolean useSecure;
    static final int NUM_CFS = 10;
    static final byte[] QUAL;
    static final int ROWCOUNT = 100;
    private static final byte[][] families;
    @Rule
    public TestName name = new TestName();

    static byte[] rowkey(int i) {
        return Bytes.toBytes((String)String.format("row_%08d", i));
    }

    static String family(int i) {
        return String.format("family_%04d", i);
    }

    static byte[] value(int i) {
        return Bytes.toBytes((String)String.format("%010d", i));
    }

    public static void buildHFiles(FileSystem fs, Path dir, int value) throws IOException {
        byte[] val = TestBulkLoadHFilesSplitRecovery.value(value);
        for (int i = 0; i < 10; ++i) {
            Path testIn = new Path(dir, TestBulkLoadHFilesSplitRecovery.family(i));
            TestHRegionServerBulkLoad.createHFile(fs, new Path(testIn, "hfile_" + i), Bytes.toBytes((String)TestBulkLoadHFilesSplitRecovery.family(i)), QUAL, val, 100);
        }
    }

    private TableDescriptor createTableDesc(TableName name, int cfs) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)name);
        IntStream.range(0, cfs).mapToObj(i -> ColumnFamilyDescriptorBuilder.of((String)TestBulkLoadHFilesSplitRecovery.family(i))).forEachOrdered(arg_0 -> ((TableDescriptorBuilder)builder).setColumnFamily(arg_0));
        return builder.build();
    }

    private void setupTable(Connection connection, TableName table, int cfs) throws IOException {
        try {
            LOG.info("Creating table " + table);
            try (Admin admin = connection.getAdmin();){
                admin.createTable(this.createTableDesc(table, cfs));
            }
        }
        catch (TableExistsException tee) {
            LOG.info("Table " + table + " already exists");
        }
    }

    private void setupTableWithSplitkeys(TableName table, int cfs, byte[][] SPLIT_KEYS) throws IOException {
        try {
            LOG.info("Creating table " + table);
            util.createTable(this.createTableDesc(table, cfs), SPLIT_KEYS);
        }
        catch (TableExistsException tee) {
            LOG.info("Table " + table + " already exists");
        }
    }

    private Path buildBulkFiles(TableName table, int value) throws Exception {
        Path dir = util.getDataTestDirOnTestFS(table.getNameAsString());
        Path bulk1 = new Path(dir, table.getNameAsString() + value);
        FileSystem fs = util.getTestFileSystem();
        TestBulkLoadHFilesSplitRecovery.buildHFiles(fs, bulk1, value);
        return bulk1;
    }

    private void populateTable(Connection connection, TableName table, int value) throws Exception {
        Path dir = this.buildBulkFiles(table, value);
        BulkLoadHFiles.create((Configuration)util.getConfiguration()).bulkLoad(table, dir);
    }

    private void forceSplit(TableName table) {
        try {
            int regions;
            HRegionServer hrs = util.getRSForFirstRegionInTable(table);
            for (RegionInfo hri : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices())) {
                if (!hri.getTable().equals((Object)table)) continue;
                util.getAdmin().splitRegionAsync(hri.getRegionName(), TestBulkLoadHFilesSplitRecovery.rowkey(50));
            }
            do {
                regions = 0;
                for (RegionInfo hri : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices())) {
                    if (!hri.getTable().equals((Object)table)) continue;
                    ++regions;
                }
                if (regions == 2) continue;
                LOG.info("Taking some time to complete split...");
                Thread.sleep(250L);
            } while (regions != 2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        util = new HBaseTestingUtil();
        util.getConfiguration().set("hbase.coprocessor.region.classes", "");
        util.startMiniCluster(1);
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        util.shutdownMiniCluster();
    }

    void assertExpectedTable(TableName table, int count, int value) throws IOException {
        TableDescriptor htd = util.getAdmin().getDescriptor(table);
        Assert.assertNotNull((Object)htd);
        try (Table t = util.getConnection().getTable(table);
             ResultScanner sr = t.getScanner(new Scan());){
            Result r;
            int i = 0;
            while ((r = sr.next()) != null) {
                r.getNoVersionMap().values().stream().flatMap(m -> m.values().stream()).forEach(v -> Assert.assertArrayEquals((byte[])TestBulkLoadHFilesSplitRecovery.value(value), (byte[])v));
                ++i;
            }
            Assert.assertEquals((long)count, (long)i);
        }
        catch (IOException e) {
            Assert.fail((String)"Failed due to exception");
        }
    }

    private static <T> CompletableFuture<T> failedFuture(Throwable error) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(error);
        return future;
    }

    private static AsyncClusterConnection mockAndInjectError(AsyncClusterConnection conn) {
        AsyncClusterConnection errConn = (AsyncClusterConnection)Mockito.spy((Object)conn);
        ((AsyncClusterConnection)Mockito.doReturn(TestBulkLoadHFilesSplitRecovery.failedFuture(new IOException("injecting bulk load error"))).when((Object)errConn)).bulkLoad((TableName)ArgumentMatchers.any(), ArgumentMatchers.anyList(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (Token)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyList(), ArgumentMatchers.anyBoolean());
        return errConn;
    }

    @Test(expected=IOException.class)
    public void testBulkLoadPhaseFailure() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        final AtomicInteger attemptedCalls = new AtomicInteger();
        Configuration conf = new Configuration(util.getConfiguration());
        conf.setInt("hbase.client.retries.number", 2);
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(conf){

            protected void bulkLoadPhase(AsyncClusterConnection conn, TableName tableName, Deque<BulkLoadHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups, boolean copyFiles, Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
                AsyncClusterConnection c = attemptedCalls.incrementAndGet() == 1 ? TestBulkLoadHFilesSplitRecovery.mockAndInjectError(conn) : conn;
                super.bulkLoadPhase(c, tableName, queue, regionGroups, copyFiles, item2RegionMap);
            }
        };
        Path dir = this.buildBulkFiles(table, 1);
        loader.bulkLoad(table, dir);
    }

    @Test
    public void testRetryOnIOException() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        final AtomicInteger calls = new AtomicInteger(0);
        this.setupTable(util.getConnection(), table, 10);
        final Configuration conf = new Configuration(util.getConfiguration());
        conf.setInt("hbase.client.retries.number", 2);
        conf.setBoolean("hbase.bulkload.retries.retryOnIOException", true);
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(conf){

            protected void bulkLoadPhase(AsyncClusterConnection conn, TableName tableName, Deque<BulkLoadHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups, boolean copyFiles, Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
                if (calls.get() < conf.getInt("hbase.client.retries.number", 15)) {
                    calls.incrementAndGet();
                    super.bulkLoadPhase(TestBulkLoadHFilesSplitRecovery.mockAndInjectError(conn), tableName, queue, regionGroups, copyFiles, item2RegionMap);
                } else {
                    super.bulkLoadPhase(conn, tableName, queue, regionGroups, copyFiles, item2RegionMap);
                }
            }
        };
        Path dir = this.buildBulkFiles(table, 1);
        loader.bulkLoad(table, dir);
        Assert.assertEquals((long)calls.get(), (long)2L);
    }

    @Test
    public void testSplitWhileBulkLoadPhase() throws Exception {
        final TableName table = TableName.valueOf((String)this.name.getMethodName());
        this.setupTable(util.getConnection(), table, 10);
        this.populateTable(util.getConnection(), table, 1);
        this.assertExpectedTable(table, 100, 1);
        final AtomicInteger attemptedCalls = new AtomicInteger();
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(util.getConfiguration()){

            protected void bulkLoadPhase(AsyncClusterConnection conn, TableName tableName, Deque<BulkLoadHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups, boolean copyFiles, Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
                int i = attemptedCalls.incrementAndGet();
                if (i == 1) {
                    TestBulkLoadHFilesSplitRecovery.this.forceSplit(table);
                }
                super.bulkLoadPhase(conn, tableName, queue, regionGroups, copyFiles, item2RegionMap);
            }
        };
        Path dir = this.buildBulkFiles(table, 2);
        loader.bulkLoad(table, dir);
        Assert.assertEquals((long)3L, (long)attemptedCalls.get());
        this.assertExpectedTable(table, 100, 2);
    }

    @Test
    public void testGroupOrSplitPresplit() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        this.setupTable(util.getConnection(), table, 10);
        this.populateTable(util.getConnection(), table, 1);
        this.assertExpectedTable(util.getConnection(), table, 100, 1);
        this.forceSplit(table);
        final AtomicInteger countedLqis = new AtomicInteger();
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(util.getConfiguration()){

            protected Pair<List<BulkLoadHFiles.LoadQueueItem>, String> groupOrSplit(AsyncClusterConnection conn, TableName tableName, Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups, BulkLoadHFiles.LoadQueueItem item, List<Pair<byte[], byte[]>> startEndKeys) throws IOException {
                Pair lqis = super.groupOrSplit(conn, tableName, regionGroups, item, startEndKeys);
                if (lqis != null && lqis.getFirst() != null) {
                    countedLqis.addAndGet(((List)lqis.getFirst()).size());
                }
                return lqis;
            }
        };
        Path dir = this.buildBulkFiles(table, 2);
        loader.bulkLoad(table, dir);
        this.assertExpectedTable(util.getConnection(), table, 100, 2);
        Assert.assertEquals((long)20L, (long)countedLqis.get());
    }

    @Test
    public void testCorrectSplitPoint() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"row_00000010"), Bytes.toBytes((String)"row_00000020"), Bytes.toBytes((String)"row_00000030"), Bytes.toBytes((String)"row_00000040"), Bytes.toBytes((String)"row_00000050"), Bytes.toBytes((String)"row_00000060"), Bytes.toBytes((String)"row_00000070")};
        this.setupTableWithSplitkeys(table, 10, SPLIT_KEYS);
        final AtomicInteger bulkloadRpcTimes = new AtomicInteger();
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(util.getConfiguration()){

            protected void bulkLoadPhase(AsyncClusterConnection conn, TableName tableName, Deque<BulkLoadHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups, boolean copyFiles, Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
                bulkloadRpcTimes.addAndGet(1);
                super.bulkLoadPhase(conn, tableName, queue, regionGroups, copyFiles, item2RegionMap);
            }
        };
        Path dir = this.buildBulkFiles(table, 1);
        loader.bulkLoad(table, dir);
        Assert.assertEquals((long)4L, (long)bulkloadRpcTimes.get());
    }

    @Test
    public void testSplitTmpFileCleanUp() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"row_00000010"), Bytes.toBytes((String)"row_00000020"), Bytes.toBytes((String)"row_00000030"), Bytes.toBytes((String)"row_00000040"), Bytes.toBytes((String)"row_00000050")};
        this.setupTableWithSplitkeys(table, 10, SPLIT_KEYS);
        BulkLoadHFiles loader = BulkLoadHFiles.create((Configuration)util.getConfiguration());
        Path dir = this.buildBulkFiles(table, 2);
        loader.bulkLoad(table, dir);
        Path tmpPath = new Path(dir, TestBulkLoadHFilesSplitRecovery.family(0));
        tmpPath = new Path(tmpPath, ".tmp");
        FileSystem fs = dir.getFileSystem(util.getConfiguration());
        Assert.assertTrue((boolean)fs.exists(tmpPath));
        Assert.assertNull((String)".tmp should be empty.", (Object)CommonFSUtils.listStatus((FileSystem)fs, (Path)tmpPath));
        this.assertExpectedTable(util.getConnection(), table, 100, 2);
    }

    @Test(expected=IOException.class)
    public void testGroupOrSplitFailure() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.setupTable(util.getConnection(), tableName, 10);
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(util.getConfiguration()){
            private int i;
            {
                this.i = 0;
            }

            protected Pair<List<BulkLoadHFiles.LoadQueueItem>, String> groupOrSplit(AsyncClusterConnection conn, TableName tableName, Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups, BulkLoadHFiles.LoadQueueItem item, List<Pair<byte[], byte[]>> startEndKeys) throws IOException {
                ++this.i;
                if (this.i == 5) {
                    throw new IOException("failure");
                }
                return super.groupOrSplit(conn, tableName, regionGroups, item, startEndKeys);
            }
        };
        Path dir = this.buildBulkFiles(tableName, 1);
        loader.bulkLoad(tableName, dir);
    }

    @Test
    public void testSplitWhileBulkLoadPhaseWithoutItemMap() throws Exception {
        final TableName table = TableName.valueOf((String)this.name.getMethodName());
        this.setupTable(util.getConnection(), table, 10);
        this.populateTable(util.getConnection(), table, 1);
        this.assertExpectedTable(table, 100, 1);
        final AtomicInteger attemptedCalls = new AtomicInteger();
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(util.getConfiguration()){

            protected void bulkLoadPhase(AsyncClusterConnection conn, TableName tableName, Deque<BulkLoadHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups, boolean copyFiles, Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
                int i = attemptedCalls.incrementAndGet();
                if (i == 1) {
                    TestBulkLoadHFilesSplitRecovery.this.forceSplit(table);
                }
                super.bulkLoadPhase(conn, tableName, queue, regionGroups, copyFiles, null);
            }
        };
        Path dir = this.buildBulkFiles(table, 2);
        loader.bulkLoad(table, dir);
        Assert.assertEquals((long)3L, (long)attemptedCalls.get());
        this.assertExpectedTable(table, 100, 2);
    }

    void assertExpectedTable(Connection connection, TableName table, int count, int value) throws IOException {
        TableDescriptor htd = util.getAdmin().getDescriptor(table);
        Assert.assertNotNull((Object)htd);
        try (Table t = connection.getTable(table);
             ResultScanner sr = t.getScanner(new Scan());){
            Result r;
            int i = 0;
            while ((r = sr.next()) != null) {
                r.getNoVersionMap().values().stream().flatMap(m -> m.values().stream()).forEach(v -> Assert.assertArrayEquals((byte[])TestBulkLoadHFilesSplitRecovery.value(value), (byte[])v));
                ++i;
            }
            Assert.assertEquals((long)count, (long)i);
        }
        catch (IOException e) {
            Assert.fail((String)"Failed due to exception");
        }
    }

    static {
        useSecure = false;
        QUAL = Bytes.toBytes((String)"qual");
        families = new byte[10][];
        for (int i = 0; i < 10; ++i) {
            TestBulkLoadHFilesSplitRecovery.families[i] = Bytes.toBytes((String)TestBulkLoadHFilesSplitRecovery.family(i));
        }
    }
}

