/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HFileArchiveTestingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HFileArchiveTestingUtil.class);

    private HFileArchiveTestingUtil() {
    }

    public static boolean compareArchiveToOriginal(FileStatus[] previous, FileStatus[] archived, FileSystem fs, boolean hasTimedBackup) {
        List<List<String>> lists = HFileArchiveTestingUtil.getFileLists(previous, archived);
        List<String> original = lists.get(0);
        Collections.sort(original);
        List<String> currentFiles = lists.get(1);
        Collections.sort(currentFiles);
        List<String> backedup = lists.get(2);
        Collections.sort(backedup);
        if (!hasTimedBackup == backedup.size() > 0) {
            LOG.debug("backedup files doesn't match expected.");
            return false;
        }
        String msg = null;
        if (hasTimedBackup && (msg = HFileArchiveTestingUtil.assertArchiveEquality(original, backedup)) != null) {
            LOG.debug(msg);
            return false;
        }
        msg = HFileArchiveTestingUtil.assertArchiveEquality(original, currentFiles);
        if (msg != null) {
            LOG.debug(msg);
            return false;
        }
        return true;
    }

    public static void assertArchiveEqualToOriginal(FileStatus[] expected, FileStatus[] actual, FileSystem fs) throws IOException {
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(expected, actual, fs, false);
    }

    public static void assertArchiveEqualToOriginal(FileStatus[] expected, FileStatus[] actual, FileSystem fs, boolean hasTimedBackup) throws IOException {
        List<List<String>> lists = HFileArchiveTestingUtil.getFileLists(expected, actual);
        List<String> original = lists.get(0);
        Collections.sort(original);
        List<String> currentFiles = lists.get(1);
        Collections.sort(currentFiles);
        List<String> backedup = lists.get(2);
        Collections.sort(backedup);
        Assert.assertEquals((String)("Didn't expect any backup files, but got: " + backedup), (Object)hasTimedBackup, (Object)(backedup.size() > 0 ? 1 : 0));
        String msg = null;
        if (hasTimedBackup) {
            HFileArchiveTestingUtil.assertArchiveEquality(original, backedup);
            Assert.assertNull((String)msg, (Object)msg);
        }
        msg = HFileArchiveTestingUtil.assertArchiveEquality(original, currentFiles);
        Assert.assertNull((String)msg, (Object)msg);
    }

    private static String assertArchiveEquality(List<String> expected, List<String> archived) {
        String compare = HFileArchiveTestingUtil.compareFileLists(expected, archived);
        if (expected.size() != archived.size()) {
            return "Not the same number of current files\n" + compare;
        }
        if (!expected.equals(archived)) {
            return "Different backup files, but same amount\n" + compare;
        }
        return null;
    }

    private static List<List<String>> getFileLists(FileStatus[] previous, FileStatus[] archived) {
        ArrayList<List<String>> files = new ArrayList<List<String>>(3);
        List<String> originalFileNames = HFileArchiveTestingUtil.convertToString(previous);
        files.add(originalFileNames);
        ArrayList<String> currentFiles = new ArrayList<String>(previous.length);
        ArrayList<FileStatus> backedupFiles = new ArrayList<FileStatus>(previous.length);
        for (FileStatus f : archived) {
            String name = f.getPath().getName();
            if (name.contains(".")) {
                Path parent = f.getPath().getParent();
                String shortName = name.split("[.]")[0];
                Path modPath = new Path(parent, shortName);
                FileStatus file = new FileStatus(f.getLen(), f.isDirectory(), (int)f.getReplication(), f.getBlockSize(), f.getModificationTime(), modPath);
                backedupFiles.add(file);
                continue;
            }
            currentFiles.add(name);
        }
        files.add(currentFiles);
        files.add(HFileArchiveTestingUtil.convertToString(backedupFiles));
        return files;
    }

    private static List<String> convertToString(FileStatus[] files) {
        return HFileArchiveTestingUtil.convertToString(Arrays.asList(files));
    }

    private static List<String> convertToString(List<FileStatus> files) {
        ArrayList<String> originalFileNames = new ArrayList<String>(files.size());
        for (FileStatus f : files) {
            originalFileNames.add(f.getPath().getName());
        }
        return originalFileNames;
    }

    private static String compareFileLists(List<String> expected, List<String> gotten) {
        StringBuilder sb = new StringBuilder("Expected (" + expected.size() + "): \t\t Gotten (" + gotten.size() + "):\n");
        ArrayList<String> notFound = new ArrayList<String>();
        for (String s : expected) {
            if (gotten.contains(s)) {
                sb.append(s + "\t\t" + s + "\n");
                continue;
            }
            notFound.add(s);
        }
        sb.append("Not Found:\n");
        for (String s : notFound) {
            sb.append(s + "\n");
        }
        sb.append("\nExtra:\n");
        for (String s : gotten) {
            if (expected.contains(s)) continue;
            sb.append(s + "\n");
        }
        return sb.toString();
    }

    public static Path getRegionArchiveDir(Configuration conf, HRegion region) throws IOException {
        return HFileArchiveUtil.getRegionArchiveDir((Path)CommonFSUtils.getRootDir((Configuration)conf), (TableName)region.getTableDescriptor().getTableName(), (String)region.getRegionInfo().getEncodedName());
    }

    public static Path getStoreArchivePath(Configuration conf, HRegion region, Store store) throws IOException {
        return HFileArchiveUtil.getStoreArchivePath((Configuration)conf, (RegionInfo)region.getRegionInfo(), (Path)region.getRegionFileSystem().getTableDir(), (byte[])store.getColumnFamilyDescriptor().getName());
    }

    public static Path getStoreArchivePath(HBaseTestingUtil util, String tableName, byte[] storeName) throws IOException {
        byte[] table = Bytes.toBytes((String)tableName);
        List<HRegion> servingRegions = util.getHBaseCluster().getRegions(table);
        HRegion region = servingRegions.get(0);
        HStore store = region.getStore(storeName);
        return HFileArchiveTestingUtil.getStoreArchivePath(util.getConfiguration(), region, (Store)store);
    }
}

