/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.DelegatingInternalScanner;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MiscTests.class, MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestCoprocessorScanPolicy {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoprocessorScanPolicy.class);
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final byte[] F = Bytes.toBytes((String)"fam");
    private static final byte[] Q = Bytes.toBytes((String)"qual");
    private static final byte[] R = Bytes.toBytes((String)"row");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{ScanObserver.class.getName()});
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseCommonTestingUtil.BOOLEAN_PARAMETERIZED;
    }

    public TestCoprocessorScanPolicy(boolean parallelSeekEnable) {
        TEST_UTIL.getMiniHBaseCluster().getConf().setBoolean("hbase.storescanner.parallel.seek.enable", parallelSeekEnable);
    }

    @Test
    public void testBaseCases() throws Exception {
        TableName tableName = TableName.valueOf((String)"baseCases");
        if (TEST_UTIL.getAdmin().tableExists(tableName)) {
            TEST_UTIL.deleteTable(tableName);
        }
        Table t = TEST_UTIL.createTable(tableName, F, 10);
        long now = EnvironmentEdgeManager.currentTime();
        Put p = new Put(R);
        p.addColumn(F, Q, now, Q);
        t.put(p);
        p = new Put(R);
        p.addColumn(F, Q, now + 1L, Q);
        t.put(p);
        p = new Put(R);
        p.addColumn(F, Q, now + 2L, Q);
        t.put(p);
        Get g = new Get(R);
        g.readVersions(10);
        Result r = t.get(g);
        Assert.assertEquals((long)3L, (long)r.size());
        TEST_UTIL.flush(tableName);
        TEST_UTIL.compact(tableName, true);
        r = t.get(g);
        Assert.assertEquals((long)3L, (long)r.size());
        p = new Put(R);
        p.setAttribute("versions", new byte[0]);
        p.addColumn(F, tableName.getName(), Bytes.toBytes((int)2));
        t.put(p);
        r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        TEST_UTIL.flush(tableName);
        TEST_UTIL.compact(tableName, true);
        r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        p.addColumn(F, Q, now + 3L, Q);
        t.put(p);
        r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        t.close();
    }

    @Test
    public void testTTL() throws Exception {
        TableName tableName = TableName.valueOf((String)"testTTL");
        if (TEST_UTIL.getAdmin().tableExists(tableName)) {
            TEST_UTIL.deleteTable(tableName);
        }
        Table t = TEST_UTIL.createTable(tableName, F, 10);
        long now = EnvironmentEdgeManager.currentTime();
        ManualEnvironmentEdge me = new ManualEnvironmentEdge();
        me.setValue(now);
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)me);
        long ts = now - 2000L;
        Put p = new Put(R);
        p.addColumn(F, Q, ts, Q);
        t.put(p);
        p = new Put(R);
        p.addColumn(F, Q, ts + 1L, Q);
        t.put(p);
        p = new Put(R);
        p.setAttribute("ttl", new byte[0]);
        p.addColumn(F, tableName.getName(), Bytes.toBytes((long)3000L));
        t.put(p);
        Get g = new Get(R);
        g.readAllVersions();
        Result r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        TEST_UTIL.flush(tableName);
        TEST_UTIL.compact(tableName, true);
        g = new Get(R);
        g.readAllVersions();
        r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        me.setValue(now + 2000L);
        g = new Get(R);
        g.readAllVersions();
        r = t.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        t.close();
        EnvironmentEdgeManager.reset();
    }

    public static class ScanObserver
    implements RegionCoprocessor,
    RegionObserver {
        private final ConcurrentMap<TableName, Long> ttls = new ConcurrentHashMap<TableName, Long>();
        private final ConcurrentMap<TableName, Integer> versions = new ConcurrentHashMap<TableName, Integer>();

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            if (put.getAttribute("ttl") != null) {
                Cell cell = (Cell)((List)put.getFamilyCellMap().values().stream().findFirst().get()).get(0);
                this.ttls.put(TableName.valueOf((String)Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength())), Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
                c.bypass();
            } else if (put.getAttribute("versions") != null) {
                Cell cell = (Cell)((List)put.getFamilyCellMap().values().stream().findFirst().get()).get(0);
                this.versions.put(TableName.valueOf((String)Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength())), Bytes.toInt((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
                c.bypass();
            }
        }

        private InternalScanner wrap(Store store, InternalScanner scanner) {
            final Long ttl = (Long)this.ttls.get(store.getTableName());
            final Integer version = (Integer)this.versions.get(store.getTableName());
            return new DelegatingInternalScanner(scanner){
                private byte[] row;
                private byte[] qualifier;
                private int count;

                private Predicate<Cell> checkTtl(long now, long ttl2) {
                    return c -> now - c.getTimestamp() > ttl2;
                }

                private Predicate<Cell> checkVersion(Cell firstCell, int version2) {
                    if (version2 == 0) {
                        return c -> true;
                    }
                    if (this.row == null || !CellUtil.matchingRows((Cell)firstCell, (byte[])this.row)) {
                        this.row = CellUtil.cloneRow((Cell)firstCell);
                        this.qualifier = null;
                    }
                    return c -> {
                        if (this.qualifier != null && CellUtil.matchingQualifier((Cell)c, (byte[])this.qualifier)) {
                            if (this.count >= version2) {
                                return true;
                            }
                            ++this.count;
                            return false;
                        }
                        this.qualifier = CellUtil.cloneQualifier((Cell)c);
                        this.count = 1;
                        return false;
                    };
                }

                @Override
                public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
                    boolean moreRows = this.scanner.next(result, scannerContext);
                    if (result.isEmpty()) {
                        return moreRows;
                    }
                    long now = EnvironmentEdgeManager.currentTime();
                    Predicate<Cell> predicate = null;
                    if (ttl != null) {
                        predicate = this.checkTtl(now, ttl);
                    }
                    if (version != null) {
                        Predicate<Cell> vp = this.checkVersion(result.get(0), version);
                        predicate = predicate != null ? predicate.and(vp) : vp;
                    }
                    if (predicate != null) {
                        result.removeIf(predicate);
                    }
                    return moreRows;
                }
            };
        }

        public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, FlushLifeCycleTracker tracker) throws IOException {
            return this.wrap(store, scanner);
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
            return this.wrap(store, scanner);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
            Integer version;
            TableName tableName = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getTableDescriptor().getTableName();
            Long ttl = (Long)this.ttls.get(tableName);
            if (ttl != null) {
                get.setTimeRange(EnvironmentEdgeManager.currentTime() - ttl, get.getTimeRange().getMax());
            }
            if ((version = (Integer)this.versions.get(tableName)) != null) {
                get.readVersions(version.intValue());
            }
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
            Integer version;
            Region region = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion();
            TableName tableName = region.getTableDescriptor().getTableName();
            Long ttl = (Long)this.ttls.get(tableName);
            if (ttl != null) {
                scan.setTimeRange(EnvironmentEdgeManager.currentTime() - ttl, scan.getTimeRange().getMax());
            }
            if ((version = (Integer)this.versions.get(tableName)) != null) {
                scan.readVersions(version.intValue());
            }
        }
    }
}

