/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestRegionSplitter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionSplitter.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionSplitter.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final String CF_NAME = "SPLIT_TEST_CF";
    private static final byte xFF = -1;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setup() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCreatePresplitTableHex() throws Exception {
        ArrayList<byte[]> expectedBounds = new ArrayList<byte[]>(17);
        expectedBounds.add(ArrayUtils.EMPTY_BYTE_ARRAY);
        expectedBounds.add(Bytes.toBytes((String)"10000000"));
        expectedBounds.add(Bytes.toBytes((String)"20000000"));
        expectedBounds.add(Bytes.toBytes((String)"30000000"));
        expectedBounds.add(Bytes.toBytes((String)"40000000"));
        expectedBounds.add(Bytes.toBytes((String)"50000000"));
        expectedBounds.add(Bytes.toBytes((String)"60000000"));
        expectedBounds.add(Bytes.toBytes((String)"70000000"));
        expectedBounds.add(Bytes.toBytes((String)"80000000"));
        expectedBounds.add(Bytes.toBytes((String)"90000000"));
        expectedBounds.add(Bytes.toBytes((String)"a0000000"));
        expectedBounds.add(Bytes.toBytes((String)"b0000000"));
        expectedBounds.add(Bytes.toBytes((String)"c0000000"));
        expectedBounds.add(Bytes.toBytes((String)"d0000000"));
        expectedBounds.add(Bytes.toBytes((String)"e0000000"));
        expectedBounds.add(Bytes.toBytes((String)"f0000000"));
        expectedBounds.add(ArrayUtils.EMPTY_BYTE_ARRAY);
        this.preSplitTableAndVerify(expectedBounds, RegionSplitter.HexStringSplit.class.getSimpleName(), TableName.valueOf((String)this.name.getMethodName()));
    }

    @Test
    public void testCreatePresplitTableUniform() throws Exception {
        ArrayList<byte[]> expectedBounds = new ArrayList<byte[]>(17);
        expectedBounds.add(ArrayUtils.EMPTY_BYTE_ARRAY);
        expectedBounds.add(new byte[]{16, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{32, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{48, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{64, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{80, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{96, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{112, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-128, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-112, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-96, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-80, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-64, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-48, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-32, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-16, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(ArrayUtils.EMPTY_BYTE_ARRAY);
        this.preSplitTableAndVerify(expectedBounds, RegionSplitter.UniformSplit.class.getSimpleName(), TableName.valueOf((String)this.name.getMethodName()));
    }

    @Test
    public void unitTestHexStringSplit() {
        RegionSplitter.HexStringSplit splitter = new RegionSplitter.HexStringSplit();
        byte[][] twoRegionsSplits = splitter.split(2);
        Assert.assertEquals((long)1L, (long)twoRegionsSplits.length);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"80000000"), (byte[])twoRegionsSplits[0]);
        byte[][] threeRegionsSplits = splitter.split(3);
        Assert.assertEquals((long)2L, (long)threeRegionsSplits.length);
        byte[] expectedSplit0 = Bytes.toBytes((String)"55555555");
        Assert.assertArrayEquals((byte[])expectedSplit0, (byte[])threeRegionsSplits[0]);
        byte[] expectedSplit1 = Bytes.toBytes((String)"aaaaaaaa");
        Assert.assertArrayEquals((byte[])expectedSplit1, (byte[])threeRegionsSplits[1]);
        byte[] splitPoint = splitter.split(Bytes.toBytes((String)"10000000"), Bytes.toBytes((String)"30000000"));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"20000000"), (byte[])splitPoint);
        byte[] lastRow = Bytes.toBytes((String)"ffffffff");
        Assert.assertArrayEquals((byte[])lastRow, (byte[])splitter.lastRow());
        byte[] firstRow = Bytes.toBytes((String)"00000000");
        Assert.assertArrayEquals((byte[])firstRow, (byte[])splitter.firstRow());
        splitPoint = splitter.split(firstRow, Bytes.toBytes((String)"20000000"));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"10000000"), (byte[])splitPoint);
        splitPoint = splitter.split(Bytes.toBytes((String)"dfffffff"), lastRow);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"efffffff"), (byte[])splitPoint);
        byte[][] splits = splitter.split(Bytes.toBytes((String)"00000000"), Bytes.toBytes((String)"30000000"), 3, false);
        Assert.assertEquals((long)2L, (long)splits.length);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"10000000"), (byte[])splits[0]);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"20000000"), (byte[])splits[1]);
        splits = splitter.split(Bytes.toBytes((String)"00000000"), Bytes.toBytes((String)"20000000"), 2, true);
        Assert.assertEquals((long)3L, (long)splits.length);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"10000000"), (byte[])splits[1]);
    }

    @Test
    public void unitTestDecimalStringSplit() {
        RegionSplitter.DecimalStringSplit splitter = new RegionSplitter.DecimalStringSplit();
        byte[][] twoRegionsSplits = splitter.split(2);
        Assert.assertEquals((long)1L, (long)twoRegionsSplits.length);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"50000000"), (byte[])twoRegionsSplits[0]);
        byte[][] threeRegionsSplits = splitter.split(3);
        Assert.assertEquals((long)2L, (long)threeRegionsSplits.length);
        byte[] expectedSplit0 = Bytes.toBytes((String)"33333333");
        Assert.assertArrayEquals((byte[])expectedSplit0, (byte[])threeRegionsSplits[0]);
        byte[] expectedSplit1 = Bytes.toBytes((String)"66666666");
        Assert.assertArrayEquals((byte[])expectedSplit1, (byte[])threeRegionsSplits[1]);
        byte[] splitPoint = splitter.split(Bytes.toBytes((String)"10000000"), Bytes.toBytes((String)"30000000"));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"20000000"), (byte[])splitPoint);
        byte[] lastRow = Bytes.toBytes((String)"99999999");
        Assert.assertArrayEquals((byte[])lastRow, (byte[])splitter.lastRow());
        byte[] firstRow = Bytes.toBytes((String)"00000000");
        Assert.assertArrayEquals((byte[])firstRow, (byte[])splitter.firstRow());
        splitPoint = splitter.split(firstRow, Bytes.toBytes((String)"20000000"));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"10000000"), (byte[])splitPoint);
        splitPoint = splitter.split(firstRow, Bytes.toBytes((String)"19999999"));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"09999999"), (byte[])splitPoint);
        splitPoint = splitter.split(Bytes.toBytes((String)"79999999"), lastRow);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"89999999"), (byte[])splitPoint);
        byte[][] splits = splitter.split(Bytes.toBytes((String)"00000000"), Bytes.toBytes((String)"30000000"), 3, false);
        Assert.assertEquals((long)2L, (long)splits.length);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"10000000"), (byte[])splits[0]);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"20000000"), (byte[])splits[1]);
        splits = splitter.split(Bytes.toBytes((String)"00000000"), Bytes.toBytes((String)"20000000"), 2, true);
        Assert.assertEquals((long)3L, (long)splits.length);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"10000000"), (byte[])splits[1]);
    }

    @Test
    public void unitTestUniformSplit() {
        RegionSplitter.UniformSplit splitter = new RegionSplitter.UniformSplit();
        try {
            splitter.split(1);
            throw new AssertionError((Object)"Splitting into <2 regions should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            byte[][] twoRegionsSplits = splitter.split(2);
            Assert.assertEquals((long)1L, (long)twoRegionsSplits.length);
            Assert.assertArrayEquals((byte[])twoRegionsSplits[0], (byte[])new byte[]{-128, 0, 0, 0, 0, 0, 0, 0});
            byte[][] threeRegionsSplits = splitter.split(3);
            Assert.assertEquals((long)2L, (long)threeRegionsSplits.length);
            byte[] expectedSplit0 = new byte[]{85, 85, 85, 85, 85, 85, 85, 85};
            Assert.assertArrayEquals((byte[])expectedSplit0, (byte[])threeRegionsSplits[0]);
            byte[] expectedSplit1 = new byte[]{-86, -86, -86, -86, -86, -86, -86, -86};
            Assert.assertArrayEquals((byte[])expectedSplit1, (byte[])threeRegionsSplits[1]);
            byte[] splitPoint = splitter.split(new byte[]{16}, new byte[]{48});
            Assert.assertArrayEquals((byte[])new byte[]{32}, (byte[])splitPoint);
            byte[] lastRow = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
            Assert.assertArrayEquals((byte[])lastRow, (byte[])splitter.lastRow());
            byte[] firstRow = ArrayUtils.EMPTY_BYTE_ARRAY;
            Assert.assertArrayEquals((byte[])firstRow, (byte[])splitter.firstRow());
            splitPoint = splitter.split(firstRow, new byte[]{32});
            Assert.assertArrayEquals((byte[])splitPoint, (byte[])new byte[]{16});
            splitPoint = splitter.split(new byte[]{-33, -1, -1, -1, -1, -1, -1, -1}, lastRow);
            Assert.assertArrayEquals((byte[])splitPoint, (byte[])new byte[]{-17, -1, -1, -1, -1, -1, -1, -1});
            splitPoint = splitter.split(new byte[]{97, 97, 97}, new byte[]{97, 97, 98});
            Assert.assertArrayEquals((byte[])splitPoint, (byte[])new byte[]{97, 97, 97, -128});
            byte[][] splits = splitter.split(new byte[]{97, 97, 97}, new byte[]{97, 97, 100}, 3, false);
            Assert.assertEquals((long)2L, (long)splits.length);
            Assert.assertArrayEquals((byte[])splits[0], (byte[])new byte[]{97, 97, 98});
            Assert.assertArrayEquals((byte[])splits[1], (byte[])new byte[]{97, 97, 99});
            splits = splitter.split(new byte[]{97, 97, 97}, new byte[]{97, 97, 101}, 2, true);
            Assert.assertEquals((long)3L, (long)splits.length);
            Assert.assertArrayEquals((byte[])splits[1], (byte[])new byte[]{97, 97, 99});
            return;
        }
    }

    @Test
    public void testUserInput() {
        RegionSplitter.HexStringSplit algo = new RegionSplitter.HexStringSplit();
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "00", "AA"));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "AA", "00"));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "AA", "AA"));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "0", "2", 3));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "0", "A", 11));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "0", "A", 12));
        algo = new RegionSplitter.DecimalStringSplit();
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "00", "99"));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "99", "00"));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "99", "99"));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "0", "2", 3));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "0", "9", 10));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "0", "9", 11));
        algo = new RegionSplitter.UniformSplit();
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\x00", "\\xAA"));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\xAA", "\\x00"));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\xAA", "\\xAA"));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\x00", "\\x02", 3));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\x00", "\\x0A", 11));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\x00", "\\x0A", 12));
    }

    private boolean splitFailsPrecondition(RegionSplitter.SplitAlgorithm algo) {
        return this.splitFailsPrecondition(algo, 100);
    }

    private boolean splitFailsPrecondition(RegionSplitter.SplitAlgorithm algo, String firstRow, String lastRow) {
        return this.splitFailsPrecondition(algo, firstRow, lastRow, 100);
    }

    private boolean splitFailsPrecondition(RegionSplitter.SplitAlgorithm algo, String firstRow, String lastRow, int numRegions) {
        algo.setFirstRow(firstRow);
        algo.setLastRow(lastRow);
        return this.splitFailsPrecondition(algo, numRegions);
    }

    private boolean splitFailsPrecondition(RegionSplitter.SplitAlgorithm algo, int numRegions) {
        try {
            byte[][] s = algo.split(numRegions);
            LOG.debug("split algo = " + algo);
            if (s != null) {
                StringBuilder sb = new StringBuilder();
                for (byte[] b : s) {
                    sb.append(Bytes.toStringBinary((byte[])b) + "  ");
                }
                LOG.debug(sb.toString());
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        catch (IllegalStateException e) {
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return true;
        }
    }

    private void preSplitTableAndVerify(List<byte[]> expectedBounds, String splitClass, TableName tableName) throws Exception {
        int numRegions = expectedBounds.size() - 1;
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("split.count", numRegions);
        RegionSplitter.SplitAlgorithm splitAlgo = RegionSplitter.newSplitAlgoInstance((Configuration)conf, (String)splitClass);
        RegionSplitter.createPresplitTable((TableName)tableName, (RegionSplitter.SplitAlgorithm)splitAlgo, (String[])new String[]{CF_NAME}, (Configuration)conf);
        this.verifyBounds(expectedBounds, tableName);
    }

    @Test
    public void noopRollingSplit() throws Exception {
        ArrayList<byte[]> expectedBounds = new ArrayList<byte[]>(1);
        expectedBounds.add(ArrayUtils.EMPTY_BYTE_ARRAY);
        this.rollingSplitAndVerify(TableName.valueOf((String)TestRegionSplitter.class.getSimpleName()), "UniformSplit", expectedBounds);
    }

    private void rollingSplitAndVerify(TableName tableName, String splitClass, List<byte[]> expectedBounds) throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("split.outstanding", 5);
        RegionSplitter.SplitAlgorithm splitAlgo = RegionSplitter.newSplitAlgoInstance((Configuration)conf, (String)splitClass);
        RegionSplitter.rollingSplit((TableName)tableName, (RegionSplitter.SplitAlgorithm)splitAlgo, (Configuration)conf);
        this.verifyBounds(expectedBounds, tableName);
    }

    private void verifyBounds(List<byte[]> expectedBounds, TableName tableName) throws Exception {
        int numRegions = expectedBounds.size() - 1;
        try (Table table = UTIL.getConnection().getTable(tableName);
             RegionLocator locator = UTIL.getConnection().getRegionLocator(tableName);){
            List regionInfoMap = locator.getAllRegionLocations();
            Assert.assertEquals((long)numRegions, (long)regionInfoMap.size());
            for (HRegionLocation entry : regionInfoMap) {
                RegionInfo regionInfo = entry.getRegion();
                byte[] regionStart = regionInfo.getStartKey();
                byte[] regionEnd = regionInfo.getEndKey();
                int startBoundaryIndex = TestRegionSplitter.indexOfBytes(expectedBounds, regionStart);
                Assert.assertNotSame((Object)-1, (Object)startBoundaryIndex);
                byte[] expectedRegionEnd = expectedBounds.get(startBoundaryIndex + 1);
                Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])regionEnd, (byte[])expectedRegionEnd));
            }
        }
    }

    private static int indexOfBytes(List<byte[]> list, byte[] compareTo) {
        int listIndex = 0;
        for (byte[] elem : list) {
            if (Bytes.BYTES_COMPARATOR.compare(elem, compareTo) == 0) {
                return listIndex;
            }
            ++listIndex;
        }
        return -1;
    }
}

