/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNNWithQJM {
    final Configuration conf = new HdfsConfiguration();
    private MiniJournalCluster mjc = null;
    private final Path TEST_PATH = new Path("/test-dir");
    private final Path TEST_PATH_2 = new Path("/test-dir-2");

    @Before
    public void resetSystemExit() {
        ExitUtil.resetFirstExitException();
    }

    @Before
    public void startJNs() throws Exception {
        this.mjc = new MiniJournalCluster.Builder(this.conf).build();
        this.mjc.waitActive();
    }

    @After
    public void stopJNs() throws Exception {
        if (this.mjc != null) {
            this.mjc.shutdown();
            this.mjc = null;
        }
    }

    @Test(timeout=30000L)
    public void testLogAndRestart() throws IOException {
        this.conf.set("dfs.namenode.name.dir", MiniDFSCluster.getBaseDirectory() + "/TestNNWithQJM/image");
        this.conf.set("dfs.namenode.edits.dir", this.mjc.getQuorumJournalURI("myjournal").toString());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).manageNameDfsDirs(false).build();
        try {
            cluster.getFileSystem().mkdirs(this.TEST_PATH);
            cluster.restartNameNode(new String[0]);
            Assert.assertTrue((boolean)cluster.getFileSystem().exists(this.TEST_PATH));
            cluster.getFileSystem().mkdirs(this.TEST_PATH_2);
            cluster.restartNameNode(new String[0]);
            Assert.assertTrue((boolean)cluster.getFileSystem().exists(this.TEST_PATH));
            Assert.assertTrue((boolean)cluster.getFileSystem().exists(this.TEST_PATH_2));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testNewNamenodeTakesOverWriter() throws Exception {
        File nn1Dir = new File(MiniDFSCluster.getBaseDirectory() + "/TestNNWithQJM/image-nn1");
        File nn2Dir = new File(MiniDFSCluster.getBaseDirectory() + "/TestNNWithQJM/image-nn2");
        this.conf.set("dfs.namenode.name.dir", nn1Dir.getAbsolutePath());
        this.conf.set("dfs.namenode.edits.dir", this.mjc.getQuorumJournalURI("myjournal").toString());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).manageNameDfsDirs(false).checkExitOnShutdown(false).build();
        cluster.shutdown();
        FileUtil.fullyDelete((File)nn2Dir);
        FileUtil.copy((File)nn1Dir, (FileSystem)FileSystem.getLocal((Configuration)this.conf).getRaw(), (Path)new Path(nn2Dir.getAbsolutePath()), (boolean)false, (Configuration)this.conf);
        cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).format(false).manageNameDfsDirs(false).checkExitOnShutdown(false).build();
        cluster.getFileSystem().mkdirs(this.TEST_PATH);
        Configuration conf2 = new Configuration();
        conf2.set("dfs.namenode.name.dir", nn2Dir.getAbsolutePath());
        conf2.set("dfs.namenode.edits.dir", this.mjc.getQuorumJournalURI("myjournal").toString());
        MiniDFSCluster cluster2 = new MiniDFSCluster.Builder(conf2).numDataNodes(0).format(false).manageNameDfsDirs(false).build();
        try {
            Assert.assertTrue((boolean)cluster2.getFileSystem().exists(this.TEST_PATH));
        }
        finally {
            cluster2.shutdown();
        }
        try {
            cluster.getFileSystem().mkdirs(new Path("/x"));
            Assert.fail((String)"Did not abort trying to write to a fenced NN");
        }
        catch (RemoteException re) {
            GenericTestUtils.assertExceptionContains((String)"Could not sync enough journals to persistent storage", (Throwable)re);
        }
    }

    @Test(timeout=30000L)
    public void testMismatchedNNIsRejected() throws Exception {
        this.conf.set("dfs.namenode.name.dir", MiniDFSCluster.getBaseDirectory() + "/TestNNWithQJM/image");
        String defaultEditsDir = this.conf.get("dfs.namenode.edits.dir");
        this.conf.set("dfs.namenode.edits.dir", this.mjc.getQuorumJournalURI("myjournal").toString());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).manageNameDfsDirs(false).build();
        cluster.shutdown();
        Configuration onDiskOnly = new Configuration(this.conf);
        onDiskOnly.set("dfs.namenode.edits.dir", defaultEditsDir);
        NameNode.format((Configuration)onDiskOnly);
        try {
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).manageNameDfsDirs(false).format(false).build();
            Assert.fail((String)"New NN with different namespace should have been rejected");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Unable to start log segment 1: too few journals", (Throwable)ioe);
        }
    }
}

