/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEditLogsDuringFailover {
    private static final Logger LOG = LoggerFactory.getLogger(TestEditLogsDuringFailover.class);
    private static final int NUM_DIRS_IN_LOG = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartup() throws Exception {
        Configuration conf = new Configuration();
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        try {
            ArrayList allDirs = Lists.newArrayList();
            allDirs.addAll(cluster.getNameDirs(0));
            allDirs.addAll(cluster.getNameDirs(1));
            allDirs.add(cluster.getSharedEditsDir(0, 1));
            this.assertNoEditFiles(allDirs);
            cluster.transitionToActive(0);
            this.assertEditFiles(cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
            this.assertEditFiles(Collections.singletonList(cluster.getSharedEditsDir(0, 1)), NNStorage.getInProgressEditsFileName((long)1L));
            this.assertNoEditFiles(cluster.getNameDirs(1));
            cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
            cluster.restartNameNode(1);
            this.assertEditFiles(cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
            this.assertEditFiles(Collections.singletonList(cluster.getSharedEditsDir(0, 1)), NNStorage.getInProgressEditsFileName((long)1L));
            this.assertNoEditFiles(cluster.getNameDirs(1));
            Assert.assertNull((Object)NameNodeAdapter.getFileInfo(cluster.getNameNode(1), "/test", true, false, false));
            cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
            cluster.restartNameNode(0);
            cluster.transitionToActive(1);
            Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(cluster.getNameNode(1), "/test", true, false, false));
            Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(cluster.getNameNode(1), "/test2", true, false, false));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFailoverFinalizesAndReadsInProgress(boolean partialTxAtEnd) throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        try {
            URI sharedUri = cluster.getSharedEditsDir(0, 1);
            File sharedDir = new File(sharedUri.getPath(), "current");
            FSNamesystem fsn = cluster.getNamesystem(0);
            FSImageTestUtil.createAbortedLogWithMkdirs(sharedDir, 5, 1L, fsn.getFSDirectory().getLastInodeId() + 1L);
            this.assertEditFiles(Collections.singletonList(sharedUri), NNStorage.getInProgressEditsFileName((long)1L));
            if (partialTxAtEnd) {
                FileOutputStream outs = null;
                try {
                    File editLogFile = new File(sharedDir, NNStorage.getInProgressEditsFileName((long)1L));
                    outs = new FileOutputStream(editLogFile, true);
                    outs.write(new byte[]{24, 0, 0, 0});
                    LOG.error("editLogFile = " + editLogFile);
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outs});
                    throw throwable;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outs});
            }
            cluster.transitionToActive(0);
            String testPath = "/dir5";
            Assert.assertNotNull((Object)cluster.getNameNode(0).getRpcServer().getFileInfo(testPath));
            this.assertEditFiles(Collections.singletonList(sharedUri), NNStorage.getFinalizedEditsFileName((long)1L, (long)6L), NNStorage.getInProgressEditsFileName((long)7L));
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFailoverFinalizesAndReadsInProgressSimple() throws Exception {
        this.testFailoverFinalizesAndReadsInProgress(false);
    }

    @Test
    public void testFailoverFinalizesAndReadsInProgressWithPartialTxAtEnd() throws Exception {
        this.testFailoverFinalizesAndReadsInProgress(true);
    }

    private void assertNoEditFiles(Iterable<URI> dirs) throws IOException {
        this.assertEditFiles(dirs, new String[0]);
    }

    private void assertEditFiles(Iterable<URI> dirs, String ... files) throws IOException {
        for (URI u : dirs) {
            File editDirRoot = new File(u.getPath());
            File editDir = new File(editDirRoot, "current");
            GenericTestUtils.assertExists((File)editDir);
            if (files.length == 0) {
                LOG.info("Checking no edit files exist in " + editDir);
            } else {
                LOG.info("Checking for following edit files in " + editDir + ": " + Joiner.on((String)",").join((Object[])files));
            }
            GenericTestUtils.assertGlobEquals((File)editDir, (String)"edits_.*", (String[])files);
        }
    }

    static {
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
    }
}

