/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.EncodedDataBlock;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.io.compress.Compressor;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MiscTests.class, SmallTests.class})
public class TestEncodedDataBlock {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEncodedDataBlock.class);
    private Compression.Algorithm algo;
    private static final byte[] INPUT_BYTES = new byte[]{0, 1, 0, 0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 2, 3, 0};

    @Before
    public void setUp() throws IOException {
        this.algo = (Compression.Algorithm)Mockito.mock(Compression.Algorithm.class);
    }

    @Test
    public void testGetCompressedSize() throws Exception {
        Mockito.when((Object)this.algo.createCompressionStream((OutputStream)Mockito.any(), (Compressor)Mockito.any(), Mockito.anyInt())).thenThrow(IOException.class);
        try {
            EncodedDataBlock.getCompressedSize((Compression.Algorithm)this.algo, null, (byte[])INPUT_BYTES, (int)0, (int)0);
            throw new RuntimeException("Should not reach here");
        }
        catch (IOException e) {
            ((Compression.Algorithm)Mockito.verify((Object)this.algo, (VerificationMode)Mockito.times((int)1))).createCompressionStream((OutputStream)Mockito.any(), (Compressor)Mockito.any(), Mockito.anyInt());
            return;
        }
    }
}

