/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedInt64;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MiscTests.class, SmallTests.class})
public class TestOrderedInt64 {
    private static final Long[] VALUES = new Long[]{1L, 22L, 333L, 4444L, 55555L, 666666L, 7777777L, 88888888L, 999999999L};
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOrderedInt64.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testIsNullableIsFalse() {
        OrderedInt64 type = new OrderedInt64(Order.ASCENDING);
        Assert.assertFalse((boolean)type.isNullable());
    }

    @Test
    public void testEncodedClassIsLong() {
        OrderedInt64 type = new OrderedInt64(Order.ASCENDING);
        Assert.assertEquals(Long.class, (Object)type.encodedClass());
    }

    @Test
    public void testEncodedLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedInt64 type : new OrderedInt64[]{new OrderedInt64(Order.ASCENDING), new OrderedInt64(Order.DESCENDING)}) {
            for (Long val : VALUES) {
                buffer.setPosition(0);
                type.encode((PositionedByteRange)buffer, (Object)val);
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength((Object)val));
            }
        }
    }

    @Test
    public void testEncodeNoSupportForNull() {
        this.exception.expect(IllegalArgumentException.class);
        OrderedInt64 type = new OrderedInt64(Order.ASCENDING);
        type.encode((PositionedByteRange)new SimplePositionedMutableByteRange(20), null);
    }

    @Test
    public void testEncodedFloatLength() {
        SimplePositionedMutableByteRange buffer = new SimplePositionedMutableByteRange(20);
        for (OrderedInt64 type : new OrderedInt64[]{new OrderedInt64(Order.ASCENDING), new OrderedInt64(Order.DESCENDING)}) {
            for (Long val : VALUES) {
                buffer.setPosition(0);
                type.encodeLong((PositionedByteRange)buffer, val.longValue());
                Assert.assertEquals((String)("encodedLength does not match actual, " + val), (long)buffer.getPosition(), (long)type.encodedLength(val));
            }
        }
    }
}

