/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.ClientSideRegionScanner;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TableSnapshotScanner
extends AbstractClientScanner {
    private static final Logger LOG = LoggerFactory.getLogger(TableSnapshotScanner.class);
    private Configuration conf;
    private String snapshotName;
    private FileSystem fs;
    private Path rootDir;
    private Path restoreDir;
    private Scan scan;
    private ArrayList<RegionInfo> regions;
    private TableDescriptor htd;
    private final boolean snapshotAlreadyRestored;
    private ClientSideRegionScanner currentRegionScanner = null;
    private int currentRegion = -1;
    private int numOfCompleteRows = 0;

    public TableSnapshotScanner(Configuration conf, Path restoreDir, String snapshotName, Scan scan) throws IOException {
        this(conf, CommonFSUtils.getRootDir((Configuration)conf), restoreDir, snapshotName, scan);
    }

    public TableSnapshotScanner(Configuration conf, Path rootDir, Path restoreDir, String snapshotName, Scan scan) throws IOException {
        this(conf, rootDir, restoreDir, snapshotName, scan, false);
    }

    public TableSnapshotScanner(Configuration conf, Path rootDir, Path restoreDir, String snapshotName, Scan scan, boolean snapshotAlreadyRestored) throws IOException {
        this.conf = conf;
        this.snapshotName = snapshotName;
        this.rootDir = rootDir;
        this.scan = scan;
        this.snapshotAlreadyRestored = snapshotAlreadyRestored;
        this.fs = rootDir.getFileSystem(conf);
        if (snapshotAlreadyRestored) {
            this.restoreDir = restoreDir;
            this.openWithoutRestoringSnapshot();
        } else {
            this.restoreDir = new Path(restoreDir, UUID.randomUUID().toString());
            this.openWithRestoringSnapshot();
        }
        this.initScanMetrics(scan);
    }

    private void openWithoutRestoringSnapshot() throws IOException {
        SnapshotProtos.SnapshotDescription snapshotDesc;
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshotName, this.rootDir);
        SnapshotManifest manifest = SnapshotManifest.open(this.conf, this.fs, snapshotDir, snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir));
        List<SnapshotProtos.SnapshotRegionManifest> regionManifests = manifest.getRegionManifests();
        if (regionManifests == null) {
            throw new IllegalArgumentException("Snapshot seems empty, snapshotName: " + this.snapshotName);
        }
        this.regions = new ArrayList(regionManifests.size());
        regionManifests.stream().map(r -> ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)r.getRegionInfo())).filter(this::isValidRegion).sorted().forEach(r -> this.regions.add((RegionInfo)r));
        this.htd = manifest.getTableDescriptor();
    }

    private boolean isValidRegion(RegionInfo hri) {
        if (hri.isOffline() && (hri.isSplit() || hri.isSplitParent())) {
            return false;
        }
        return PrivateCellUtil.overlappingKeys((byte[])this.scan.getStartRow(), (byte[])this.scan.getStopRow(), (byte[])hri.getStartKey(), (byte[])hri.getEndKey());
    }

    private void openWithRestoringSnapshot() throws IOException {
        RestoreSnapshotHelper.RestoreMetaChanges meta = RestoreSnapshotHelper.copySnapshotForScanner(this.conf, this.fs, this.rootDir, this.restoreDir, this.snapshotName);
        List<RegionInfo> restoredRegions = meta.getRegionsToAdd();
        this.htd = meta.getTableDescriptor();
        this.regions = new ArrayList(restoredRegions.size());
        restoredRegions.stream().filter(this::isValidRegion).sorted().forEach(r -> this.regions.add((RegionInfo)r));
    }

    public Result next() throws IOException {
        Result result = null;
        while (true) {
            if (this.currentRegionScanner == null) {
                ++this.currentRegion;
                if (this.currentRegion >= this.regions.size()) {
                    return null;
                }
                RegionInfo hri = this.regions.get(this.currentRegion);
                this.currentRegionScanner = new ClientSideRegionScanner(this.conf, this.fs, this.restoreDir, this.htd, hri, this.scan, this.scanMetrics);
                if (this.scanMetrics != null) {
                    this.scanMetrics.countOfRegions.incrementAndGet();
                }
            }
            try {
                result = this.currentRegionScanner.next();
                if (result == null) continue;
                if (this.scan.getLimit() > 0 && ++this.numOfCompleteRows > this.scan.getLimit()) {
                    result = null;
                }
                Result result2 = result;
                return result2;
            }
            finally {
                if (result != null) continue;
                this.currentRegionScanner.close();
                this.currentRegionScanner = null;
                continue;
            }
            break;
        }
    }

    private void cleanup() {
        try {
            if (this.fs.exists(this.restoreDir) && !this.fs.delete(this.restoreDir, true)) {
                LOG.warn("Delete restore directory for the snapshot failed. restoreDir: " + this.restoreDir);
            }
        }
        catch (IOException ex) {
            LOG.warn("Could not delete restore directory for the snapshot. restoreDir: " + this.restoreDir, (Throwable)ex);
        }
    }

    public void close() {
        if (this.currentRegionScanner != null) {
            this.currentRegionScanner.close();
        }
        if (!this.snapshotAlreadyRestored) {
            this.cleanup();
        }
    }

    public boolean renewLease() {
        throw new UnsupportedOperationException();
    }
}

