/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TableNamespaceManager {
    public static final String KEY_MAX_REGIONS = "hbase.namespace.quota.maxregions";
    public static final String KEY_MAX_TABLES = "hbase.namespace.quota.maxtables";
    static final String NS_INIT_TIMEOUT = "hbase.master.namespace.init.timeout";
    static final int DEFAULT_NS_INIT_TIMEOUT = 300000;
    private final ConcurrentMap<String, NamespaceDescriptor> cache = new ConcurrentHashMap<String, NamespaceDescriptor>();
    private final MasterServices masterServices;

    TableNamespaceManager(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    private void migrateNamespaceTable() throws IOException {
        try (Table nsTable = this.masterServices.getConnection().getTable(TableName.NAMESPACE_TABLE_NAME);
             ResultScanner scanner = nsTable.getScanner(new Scan().addFamily(TableDescriptorBuilder.NAMESPACE_FAMILY_INFO_BYTES).readAllVersions());
             BufferedMutator mutator = this.masterServices.getConnection().getBufferedMutator(TableName.META_TABLE_NAME);){
            Result result;
            while ((result = scanner.next()) != null) {
                Put put = new Put(result.getRow());
                result.getColumnCells(TableDescriptorBuilder.NAMESPACE_FAMILY_INFO_BYTES, TableDescriptorBuilder.NAMESPACE_COL_DESC_BYTES).forEach(c -> put.addColumn(HConstants.NAMESPACE_FAMILY, HConstants.NAMESPACE_COL_DESC_QUALIFIER, c.getTimestamp(), CellUtil.cloneValue((Cell)c)));
                mutator.mutate((Mutation)put);
            }
        }
        this.masterServices.getMasterProcedureExecutor().submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)this.masterServices.getMasterProcedureExecutor().getEnvironment(), TableName.NAMESPACE_TABLE_NAME, false));
    }

    private void loadNamespaceIntoCache() throws IOException {
        try (Table table = this.masterServices.getConnection().getTable(TableName.META_TABLE_NAME);
             ResultScanner scanner = table.getScanner(HConstants.NAMESPACE_FAMILY);){
            Result result;
            while ((result = scanner.next()) != null) {
                Cell cell = result.getColumnLatestCell(HConstants.NAMESPACE_FAMILY, HConstants.NAMESPACE_COL_DESC_QUALIFIER);
                NamespaceDescriptor ns = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)HBaseProtos.NamespaceDescriptor.parseFrom((CodedInputStream)CodedInputStream.newInstance((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength())));
                this.cache.put(ns.getName(), ns);
            }
        }
    }

    public void start() throws IOException {
        TableState nsTableState = MetaTableAccessor.getTableState(this.masterServices.getConnection(), TableName.NAMESPACE_TABLE_NAME);
        if (nsTableState != null && nsTableState.isEnabled()) {
            this.migrateNamespaceTable();
        }
        this.loadNamespaceIntoCache();
    }

    public boolean doesNamespaceExist(String namespaceName) throws IOException {
        return this.cache.containsKey(namespaceName);
    }

    public NamespaceDescriptor get(String name) throws IOException {
        return (NamespaceDescriptor)this.cache.get(name);
    }

    public void addOrUpdateNamespace(NamespaceDescriptor ns) throws IOException {
        TableNamespaceManager.insertNamespaceToMeta(this.masterServices.getConnection(), ns);
        this.cache.put(ns.getName(), ns);
    }

    public static void insertNamespaceToMeta(Connection conn, NamespaceDescriptor ns) throws IOException {
        byte[] row = Bytes.toBytes((String)ns.getName());
        Put put = new Put(row, true).addColumn(HConstants.NAMESPACE_FAMILY, HConstants.NAMESPACE_COL_DESC_QUALIFIER, ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)ns).toByteArray());
        try (Table table = conn.getTable(TableName.META_TABLE_NAME);){
            table.put(put);
        }
    }

    public void deleteNamespace(String namespaceName) throws IOException {
        Delete d = new Delete(Bytes.toBytes((String)namespaceName));
        try (Table table = this.masterServices.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.delete(d);
        }
        this.cache.remove(namespaceName);
    }

    public List<NamespaceDescriptor> list() throws IOException {
        return this.cache.values().stream().collect(Collectors.toList());
    }

    public void validateTableAndRegionCount(NamespaceDescriptor desc) throws IOException {
        if (TableNamespaceManager.getMaxRegions(desc) <= 0L) {
            throw new ConstraintException("The max region quota for " + desc.getName() + " is less than or equal to zero.");
        }
        if (TableNamespaceManager.getMaxTables(desc) <= 0L) {
            throw new ConstraintException("The max tables quota for " + desc.getName() + " is less than or equal to zero.");
        }
    }

    public static long getMaxTables(NamespaceDescriptor ns) throws IOException {
        String value = ns.getConfigurationValue(KEY_MAX_TABLES);
        long maxTables = 0L;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                maxTables = Long.parseLong(value);
            }
            catch (NumberFormatException exp) {
                throw new DoNotRetryIOException("NumberFormatException while getting max tables.", (Throwable)exp);
            }
        } else {
            maxTables = Long.MAX_VALUE;
        }
        return maxTables;
    }

    public static long getMaxRegions(NamespaceDescriptor ns) throws IOException {
        String value = ns.getConfigurationValue(KEY_MAX_REGIONS);
        long maxRegions = 0L;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                maxRegions = Long.parseLong(value);
            }
            catch (NumberFormatException exp) {
                throw new DoNotRetryIOException("NumberFormatException while getting max regions.", (Throwable)exp);
            }
        } else {
            maxRegions = Long.MAX_VALUE;
        }
        return maxRegions;
    }
}

