/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ConcurrentTableModificationException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.fs.ErasureCodingUtils;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterDDLOperationHelper;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ReopenTableRegionsProcedure;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.master.zksyncer.MetaLocationSyncer;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerValidationUtils;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ModifyTableProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.ModifyTableState> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyTableProcedure.class);
    private TableDescriptor unmodifiedTableDescriptor = null;
    private TableDescriptor modifiedTableDescriptor;
    private boolean deleteColumnFamilyInModify;
    private boolean shouldCheckDescriptor;
    private boolean reopenRegions;
    private static final List<byte[]> UNDELETABLE_META_COLUMNFAMILIES = Collections.unmodifiableList(Arrays.asList(HConstants.CATALOG_FAMILY, HConstants.TABLE_FAMILY, HConstants.REPLICATION_BARRIER_FAMILY, HConstants.NAMESPACE_FAMILY));

    public ModifyTableProcedure() {
        this.initialize(null, false);
    }

    public ModifyTableProcedure(MasterProcedureEnv env, TableDescriptor htd) throws HBaseIOException {
        this(env, htd, null);
    }

    public ModifyTableProcedure(MasterProcedureEnv env, TableDescriptor htd, ProcedurePrepareLatch latch) throws HBaseIOException {
        this(env, htd, latch, null, false, true);
    }

    public ModifyTableProcedure(MasterProcedureEnv env, TableDescriptor newTableDescriptor, ProcedurePrepareLatch latch, TableDescriptor oldTableDescriptor, boolean shouldCheckDescriptor, boolean reopenRegions) throws HBaseIOException {
        super(env, latch);
        this.reopenRegions = reopenRegions;
        this.initialize(oldTableDescriptor, shouldCheckDescriptor);
        this.modifiedTableDescriptor = newTableDescriptor;
        this.preflightChecks(env, null);
    }

    @Override
    protected void preflightChecks(MasterProcedureEnv env, Boolean enabled) throws HBaseIOException {
        super.preflightChecks(env, enabled);
        if (this.modifiedTableDescriptor.isMetaTable()) {
            Set cfs = this.modifiedTableDescriptor.getColumnFamilyNames();
            for (byte[] family : UNDELETABLE_META_COLUMNFAMILIES) {
                if (cfs.contains(family)) continue;
                throw new HBaseIOException("Delete of hbase:meta column family " + Bytes.toString((byte[])family));
            }
        }
        if (!this.reopenRegions) {
            if (this.unmodifiedTableDescriptor == null) {
                throw new HBaseIOException("unmodifiedTableDescriptor cannot be null when this table modification won't reopen regions");
            }
            if (!this.unmodifiedTableDescriptor.getTableName().equals((Object)this.modifiedTableDescriptor.getTableName())) {
                throw new HBaseIOException("Cannot change the table name when this modification won't reopen regions.");
            }
            if (this.unmodifiedTableDescriptor.getColumnFamilyCount() != this.modifiedTableDescriptor.getColumnFamilyCount()) {
                throw new HBaseIOException("Cannot add or remove column families when this modification won't reopen regions.");
            }
            if (this.unmodifiedTableDescriptor.getCoprocessorDescriptors().hashCode() != this.modifiedTableDescriptor.getCoprocessorDescriptors().hashCode()) {
                throw new HBaseIOException("Can not modify Coprocessor when table modification won't reopen regions");
            }
            HashSet<String> s = new HashSet<String>(Arrays.asList("REGION_REPLICATION", "REGION_MEMSTORE_REPLICATION", "hbase.rsgroup.name"));
            for (String k : s) {
                if (!this.isTablePropertyModified(this.unmodifiedTableDescriptor, this.modifiedTableDescriptor, k)) continue;
                throw new HBaseIOException("Can not modify " + k + " of a table when modification won't reopen regions");
            }
        }
    }

    private boolean isTablePropertyModified(TableDescriptor oldDescriptor, TableDescriptor newDescriptor, String key) {
        String oldV = oldDescriptor.getValue(key);
        String newV = newDescriptor.getValue(key);
        if (oldV == null && newV == null) {
            return false;
        }
        return oldV == null || newV == null || !oldV.equals(newV);
    }

    private void initialize(TableDescriptor unmodifiedTableDescriptor, boolean shouldCheckDescriptor) {
        this.unmodifiedTableDescriptor = unmodifiedTableDescriptor;
        this.shouldCheckDescriptor = shouldCheckDescriptor;
        this.deleteColumnFamilyInModify = false;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case MODIFY_TABLE_PREPARE: {
                    this.prepareModify(env);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_PRE_OPERATION);
                    break;
                }
                case MODIFY_TABLE_PRE_OPERATION: {
                    this.preModify(env, state);
                    if (this.reopenRegions) {
                        this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_CLOSE_EXCESS_REPLICAS);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case MODIFY_TABLE_CLOSE_EXCESS_REPLICAS: {
                    if (this.isTableEnabled(env)) {
                        this.closeExcessReplicasIfNeeded(env);
                    }
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case MODIFY_TABLE_UPDATE_TABLE_DESCRIPTOR: {
                    this.updateTableDescriptor(env);
                    if (this.reopenRegions) {
                        this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_REMOVE_REPLICA_COLUMN);
                        break;
                    }
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_POST_OPERATION);
                    break;
                }
                case MODIFY_TABLE_REMOVE_REPLICA_COLUMN: {
                    this.removeReplicaColumnsIfNeeded(env);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_POST_OPERATION);
                    break;
                }
                case MODIFY_TABLE_POST_OPERATION: {
                    this.postModify(env, state);
                    if (this.reopenRegions) {
                        this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_REOPEN_ALL_REGIONS);
                        break;
                    }
                    if (ErasureCodingUtils.needsSync(this.unmodifiedTableDescriptor, this.modifiedTableDescriptor)) {
                        this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_SYNC_ERASURE_CODING_POLICY);
                        break;
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case MODIFY_TABLE_REOPEN_ALL_REGIONS: {
                    if (this.isTableEnabled(env)) {
                        Configuration conf = env.getMasterConfiguration();
                        long backoffMillis = conf.getLong("hbase.reopen.table.regions.progressive.batch.backoff.ms", 0L);
                        int batchSizeMax = conf.getInt("hbase.reopen.table.regions.progressive.batch.size.max", -1);
                        this.addChildProcedure((Procedure[])new ReopenTableRegionsProcedure[]{new ReopenTableRegionsProcedure(this.getTableName(), backoffMillis, batchSizeMax)});
                    }
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_ASSIGN_NEW_REPLICAS);
                    break;
                }
                case MODIFY_TABLE_ASSIGN_NEW_REPLICAS: {
                    MetaLocationSyncer syncer;
                    this.assignNewReplicasIfNeeded(env);
                    if (TableName.isMetaTableName((TableName)this.getTableName()) && (syncer = env.getMasterServices().getMetaLocationSyncer()) != null) {
                        syncer.setMetaReplicaCount(this.modifiedTableDescriptor.getRegionReplication());
                    }
                    if (this.deleteColumnFamilyInModify) {
                        this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_DELETE_FS_LAYOUT);
                        break;
                    }
                    if (ErasureCodingUtils.needsSync(this.unmodifiedTableDescriptor, this.modifiedTableDescriptor)) {
                        this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_SYNC_ERASURE_CODING_POLICY);
                        break;
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case MODIFY_TABLE_DELETE_FS_LAYOUT: {
                    this.deleteFromFs(env, this.unmodifiedTableDescriptor, this.modifiedTableDescriptor);
                    if (ErasureCodingUtils.needsSync(this.unmodifiedTableDescriptor, this.modifiedTableDescriptor)) {
                        this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_SYNC_ERASURE_CODING_POLICY);
                        break;
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case MODIFY_TABLE_SYNC_ERASURE_CODING_POLICY: {
                    ErasureCodingUtils.sync(env.getMasterFileSystem().getFileSystem(), env.getMasterFileSystem().getRootDir(), this.modifiedTableDescriptor);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-modify-table", e);
            }
            LOG.warn("Retriable error trying to modify table={} (in state={})", new Object[]{this.getTableName(), state, e});
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException {
        if (state == MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_PREPARE || state == MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_PRE_OPERATION) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.ModifyTableState state) {
        switch (state) {
            case MODIFY_TABLE_PREPARE: 
            case MODIFY_TABLE_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    protected void completionCleanup(MasterProcedureEnv env) {
        this.releaseSyncLatch();
    }

    protected MasterProcedureProtos.ModifyTableState getState(int stateId) {
        return MasterProcedureProtos.ModifyTableState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.ModifyTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.ModifyTableState getInitialState() {
        return MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ModifyTableStateData.Builder modifyTableMsg = MasterProcedureProtos.ModifyTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setModifiedTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)this.modifiedTableDescriptor)).setDeleteColumnFamilyInModify(this.deleteColumnFamilyInModify).setShouldCheckDescriptor(this.shouldCheckDescriptor).setReopenRegions(this.reopenRegions);
        if (this.unmodifiedTableDescriptor != null) {
            modifyTableMsg.setUnmodifiedTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)this.unmodifiedTableDescriptor));
        }
        serializer.serialize((Message)modifyTableMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ModifyTableStateData modifyTableMsg = (MasterProcedureProtos.ModifyTableStateData)serializer.deserialize(MasterProcedureProtos.ModifyTableStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(modifyTableMsg.getUserInfo()));
        this.modifiedTableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)modifyTableMsg.getModifiedTableSchema());
        this.deleteColumnFamilyInModify = modifyTableMsg.getDeleteColumnFamilyInModify();
        this.shouldCheckDescriptor = modifyTableMsg.hasShouldCheckDescriptor() ? modifyTableMsg.getShouldCheckDescriptor() : false;
        boolean bl = this.reopenRegions = modifyTableMsg.hasReopenRegions() ? modifyTableMsg.getReopenRegions() : true;
        if (modifyTableMsg.hasUnmodifiedTableSchema()) {
            this.unmodifiedTableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)modifyTableMsg.getUnmodifiedTableSchema());
        }
    }

    @Override
    public TableName getTableName() {
        return this.modifiedTableDescriptor.getTableName();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private void prepareModify(MasterProcedureEnv env) throws IOException {
        if (!env.getMasterServices().getTableDescriptors().exists(this.getTableName())) {
            throw new TableNotFoundException(this.getTableName());
        }
        if (this.modifiedTableDescriptor.getColumnFamilyCount() == 0) {
            throw new DoNotRetryIOException("Table " + this.getTableName().toString() + " should have at least one column family.");
        }
        if (this.shouldCheckDescriptor) {
            if (TableDescriptor.COMPARATOR.compare(this.unmodifiedTableDescriptor, env.getMasterServices().getTableDescriptors().get(this.getTableName())) != 0) {
                LOG.error("Error while modifying table '" + this.getTableName().toString() + "' Skipping procedure : " + this);
                throw new ConcurrentTableModificationException("Skipping modify table operation on table '" + this.getTableName().toString() + "' as it has already been modified by some other concurrent operation, Please retry.");
            }
        } else {
            this.unmodifiedTableDescriptor = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        }
        this.deleteColumnFamilyInModify = ModifyTableProcedure.isDeleteColumnFamily(this.unmodifiedTableDescriptor, this.modifiedTableDescriptor);
        if (!this.unmodifiedTableDescriptor.getRegionServerGroup().equals(this.modifiedTableDescriptor.getRegionServerGroup())) {
            Supplier<String> forWhom = () -> "table " + this.getTableName();
            RSGroupInfo rsGroupInfo = MasterProcedureUtil.checkGroupExists(env.getMasterServices().getRSGroupInfoManager()::getRSGroup, this.modifiedTableDescriptor.getRegionServerGroup(), forWhom);
            MasterProcedureUtil.checkGroupNotEmpty(rsGroupInfo, forWhom);
        }
        StoreFileTrackerValidationUtils.checkForModifyTable(env.getMasterConfiguration(), this.unmodifiedTableDescriptor, this.modifiedTableDescriptor, !this.isTableEnabled(env));
    }

    private static boolean isDeleteColumnFamily(TableDescriptor originalDescriptor, TableDescriptor newDescriptor) {
        boolean result = false;
        Set originalFamilies = originalDescriptor.getColumnFamilyNames();
        Set newFamilies = newDescriptor.getColumnFamilyNames();
        for (byte[] familyName : originalFamilies) {
            if (newFamilies.contains(familyName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void preModify(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void updateTableDescriptor(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getTableDescriptors().update(this.modifiedTableDescriptor);
    }

    private void deleteFromFs(MasterProcedureEnv env, TableDescriptor oldTableDescriptor, TableDescriptor newTableDescriptor) throws IOException {
        Set oldFamilies = oldTableDescriptor.getColumnFamilyNames();
        Set newFamilies = newTableDescriptor.getColumnFamilyNames();
        for (byte[] familyName : oldFamilies) {
            if (newFamilies.contains(familyName)) continue;
            MasterDDLOperationHelper.deleteColumnFamilyFromFileSystem(env, this.getTableName(), this.getRegionInfoList(env), familyName, oldTableDescriptor.getColumnFamily(familyName).isMobEnabled());
        }
    }

    private void removeReplicaColumnsIfNeeded(MasterProcedureEnv env) throws IOException {
        int oldReplicaCount = this.unmodifiedTableDescriptor.getRegionReplication();
        int newReplicaCount = this.modifiedTableDescriptor.getRegionReplication();
        if (newReplicaCount >= oldReplicaCount) {
            return;
        }
        env.getAssignmentManager().getRegionStateStore().removeRegionReplicas(this.getTableName(), oldReplicaCount, newReplicaCount);
        env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.getTableName()).stream().filter(r -> r.getReplicaId() >= newReplicaCount).forEach(env.getAssignmentManager().getRegionStates()::deleteRegion);
    }

    private void assignNewReplicasIfNeeded(MasterProcedureEnv env) throws IOException {
        int oldReplicaCount = this.unmodifiedTableDescriptor.getRegionReplication();
        int newReplicaCount = this.modifiedTableDescriptor.getRegionReplication();
        if (newReplicaCount <= oldReplicaCount) {
            return;
        }
        if (this.isTableEnabled(env)) {
            List<RegionInfo> newReplicas = env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.getTableName()).stream().filter(RegionReplicaUtil::isDefaultReplica).flatMap(primaryRegion -> IntStream.range(oldReplicaCount, newReplicaCount).mapToObj(replicaId -> RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)primaryRegion, (int)replicaId))).collect(Collectors.toList());
            this.addChildProcedure((Procedure[])env.getAssignmentManager().createAssignProcedures(newReplicas));
        }
    }

    private void closeExcessReplicasIfNeeded(MasterProcedureEnv env) {
        int oldReplicaCount = this.unmodifiedTableDescriptor.getRegionReplication();
        int newReplicaCount = this.modifiedTableDescriptor.getRegionReplication();
        if (newReplicaCount >= oldReplicaCount) {
            return;
        }
        this.addChildProcedure((Procedure[])env.getAssignmentManager().createUnassignProceduresForClosingExcessRegionReplicas(this.getTableName(), newReplicaCount));
    }

    private void postModify(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void runCoprocessorAction(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            switch (state) {
                case MODIFY_TABLE_PRE_OPERATION: {
                    cpHost.preModifyTableAction(this.getTableName(), this.unmodifiedTableDescriptor, this.modifiedTableDescriptor, this.getUser());
                    break;
                }
                case MODIFY_TABLE_POST_OPERATION: {
                    cpHost.postCompletedModifyTableAction(this.getTableName(), this.unmodifiedTableDescriptor, this.modifiedTableDescriptor, this.getUser());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
    }

    private List<RegionInfo> getRegionInfoList(MasterProcedureEnv env) throws IOException {
        return env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.getTableName());
    }
}

