/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.mob.ExpiredMobFileCleaner;
import org.apache.hadoop.hbase.mob.MobFileCleanupUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MobFileCleanerChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(MobFileCleanerChore.class);
    private final HMaster master;
    private ExpiredMobFileCleaner cleaner;

    public MobFileCleanerChore(HMaster master) {
        super(master.getServerName() + "-MobFileCleanerChore", (Stoppable)master, master.getConfiguration().getInt("hbase.master.mob.cleaner.period", 86400), (long)master.getConfiguration().getInt("hbase.master.mob.cleaner.period", 86400), TimeUnit.SECONDS);
        this.master = master;
        this.cleaner = new ExpiredMobFileCleaner();
        this.cleaner.setConf(master.getConfiguration());
        this.checkObsoleteConfigurations();
    }

    private void checkObsoleteConfigurations() {
        Configuration conf = this.master.getConfiguration();
        if (conf.get("hbase.mob.compaction.mergeable.threshold") != null) {
            LOG.warn("'hbase.mob.compaction.mergeable.threshold' is obsolete and not used anymore.");
        }
        if (conf.get("hbase.mob.delfile.max.count") != null) {
            LOG.warn("'hbase.mob.delfile.max.count' is obsolete and not used anymore.");
        }
        if (conf.get("hbase.mob.compaction.threads.max") != null) {
            LOG.warn("'hbase.mob.compaction.threads.max' is obsolete and not used anymore.");
        }
        if (conf.get("hbase.mob.compaction.batch.size") != null) {
            LOG.warn("'hbase.mob.compaction.batch.size' is obsolete and not used anymore.");
        }
    }

    protected void chore() {
        TableDescriptors htds = this.master.getTableDescriptors();
        Map<String, TableDescriptor> map = null;
        try {
            map = htds.getAll();
        }
        catch (IOException e) {
            LOG.error("MobFileCleanerChore failed", (Throwable)e);
            return;
        }
        for (TableDescriptor htd : map.values()) {
            for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
                if (!hcd.isMobEnabled() || hcd.getMinVersions() != 0) continue;
                try {
                    this.cleaner.cleanExpiredMobFiles(htd.getTableName().getNameAsString(), hcd);
                }
                catch (IOException e) {
                    LOG.error("Failed to clean the expired mob files table={} family={}", new Object[]{htd.getTableName().getNameAsString(), hcd.getNameAsString(), e});
                }
            }
            try {
                LOG.info("Cleaning obsolete MOB files from table={}", (Object)htd.getTableName());
                try (Admin admin = this.master.getConnection().getAdmin();){
                    MobFileCleanupUtil.cleanupObsoleteMobFiles(this.master.getConfiguration(), htd.getTableName(), admin);
                }
                LOG.info("Cleaning obsolete MOB files finished for table={}", (Object)htd.getTableName());
            }
            catch (IOException e) {
                LOG.error("Failed to clean the obsolete mob files for table={}", (Object)htd.getTableName(), (Object)e);
            }
        }
    }
}

