/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.wal.AbstractWALRoller;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LogRoller
extends AbstractWALRoller<RegionServerServices> {
    private static final Logger LOG = LoggerFactory.getLogger(LogRoller.class);

    public LogRoller(RegionServerServices services) {
        super("LogRoller", services.getConfiguration(), services);
    }

    @Override
    protected void scheduleFlush(String encodedRegionName, List<byte[]> families) {
        RegionServerServices services = (RegionServerServices)this.abortable;
        HRegion r = services.getRegion(encodedRegionName);
        if (r == null) {
            LOG.warn("Failed to schedule flush of {}, because it is not online on us", (Object)encodedRegionName);
            return;
        }
        FlushRequester requester = services.getFlushRequester();
        if (requester == null) {
            LOG.warn("Failed to schedule flush of {}, region={}, because FlushRequester is null", (Object)encodedRegionName, (Object)r);
            return;
        }
        requester.requestFlush(r, families, FlushLifeCycleTracker.DUMMY);
    }

    Map<WAL, AbstractWALRoller.RollController> getWalNeedsRoll() {
        return this.wals;
    }
}

