/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionReplicaFlushHandler
extends EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RegionReplicaFlushHandler.class);
    private final AsyncClusterConnection connection;
    private final HRegion region;

    public RegionReplicaFlushHandler(Server server, HRegion region) {
        super(server, EventType.RS_REGION_REPLICA_FLUSH);
        this.connection = server.getAsyncClusterConnection();
        this.region = region;
    }

    @Override
    public void process() throws IOException {
        this.triggerFlushInPrimaryRegion(this.region);
    }

    @Override
    protected void handleException(Throwable t) {
        if (t instanceof InterruptedIOException || t instanceof InterruptedException) {
            LOG.error("Caught throwable while processing event " + (Object)((Object)this.eventType), t);
        } else if (t instanceof RuntimeException) {
            this.server.abort("Server aborting", t);
        } else {
            this.server.abort("ServerAborting because an exception was thrown", t);
        }
    }

    private int getRetriesCount(Configuration conf) {
        int numRetries = conf.getInt("hbase.client.retries.number", 15);
        if (numRetries > 10) {
            int mult = conf.getInt("hbase.client.serverside.retries.multiplier", 3);
            numRetries /= mult;
        }
        return numRetries;
    }

    void triggerFlushInPrimaryRegion(HRegion region) throws IOException {
        long pause = this.connection.getConfiguration().getLong("hbase.client.pause", 100L);
        int maxAttempts = this.getRetriesCount(this.connection.getConfiguration());
        RetryCounter counter = new RetryCounterFactory(maxAttempts, (int)pause).create();
        if (LOG.isDebugEnabled()) {
            LOG.debug("RPC'ing to primary " + ServerRegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region.getRegionInfo()).getRegionNameAsString() + " from " + region.getRegionInfo().getRegionNameAsString() + " to trigger FLUSH");
        }
        while (!(region.isClosing() || region.isClosed() || this.server.isAborted() || this.server.isStopped())) {
            AdminProtos.FlushRegionResponse response;
            try {
                response = (AdminProtos.FlushRegionResponse)FutureUtils.get(this.connection.flush(ServerRegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region.getRegionInfo()).getRegionName(), true));
            }
            catch (IOException e) {
                if (e instanceof TableNotFoundException || ((Boolean)FutureUtils.get((Future)this.connection.getAdmin().isTableDisabled(region.getRegionInfo().getTable()))).booleanValue()) {
                    return;
                }
                if (!counter.shouldRetry()) {
                    throw e;
                }
                LOG.debug("Failed to trigger a flush of primary region replica {} of region {}, retry={}", new Object[]{ServerRegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region.getRegionInfo()).getRegionNameAsString(), region.getRegionInfo().getRegionNameAsString(), counter.getAttemptTimes(), e});
                try {
                    counter.sleepUntilNextRetry();
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new InterruptedIOException(e1.getMessage());
                }
            }
            if (response.getFlushed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Triggered flush of primary region replica " + ServerRegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region.getRegionInfo()).getRegionNameAsString() + " for " + region.getRegionInfo().getEncodedName() + "; now waiting and blocking reads until completes a full flush cycle");
                }
                region.setReadsEnabled(true);
                break;
            }
            if (response.hasWroteFlushWalMarker()) {
                if (response.getWroteFlushWalMarker()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Triggered empty flush marker (memstore empty) on primary region replica " + ServerRegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region.getRegionInfo()).getRegionNameAsString() + " for " + region.getRegionInfo().getEncodedName() + "; now waiting and blocking reads until observing a flush marker");
                    }
                    region.setReadsEnabled(true);
                    break;
                }
                if (!counter.shouldRetry()) {
                    throw new IOException("Cannot cause primary to flush or drop a wal marker after " + counter.getAttemptTimes() + " retries. Failing opening of this region replica " + region.getRegionInfo().getRegionNameAsString());
                }
            } else {
                LOG.warn("Was not able to trigger a flush from primary region due to old server version? Continuing to open the secondary region replica: " + region.getRegionInfo().getRegionNameAsString());
                break;
            }
            LOG.warn("Cannot cause primary replica {} to flush or drop a wal marker for region replica {}, retry={}", new Object[]{ServerRegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region.getRegionInfo()).getRegionNameAsString(), region.getRegionInfo().getRegionNameAsString(), counter.getAttemptTimes()});
            try {
                counter.sleepUntilNextRetry();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
        region.setReadsEnabled(true);
    }
}

