/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ReplicationSourceWALActionListener
implements WALActionsListener {
    private final Configuration conf;
    private final ReplicationSourceManager manager;

    public ReplicationSourceWALActionListener(Configuration conf, ReplicationSourceManager manager) {
        this.conf = conf;
        this.manager = manager;
    }

    @Override
    public void postLogRoll(Path oldPath, Path newPath) throws IOException {
        this.manager.postLogRoll(newPath);
    }

    @Override
    public void visitLogEntryBeforeWrite(RegionInfo info, WALKey logKey, WALEdit logEdit) {
        ReplicationSourceWALActionListener.scopeWALEdits(logKey, logEdit, this.conf);
    }

    static void scopeWALEdits(WALKey logKey, WALEdit logEdit, Configuration conf) {
        if (ReplicationUtils.isReplicationForBulkLoadDataEnabled((Configuration)conf)) {
            return;
        }
        if (WALEdit.isReplicationMarkerEdit(logEdit)) {
            return;
        }
        if (logEdit.isReplay() || logEdit.getCells().stream().allMatch(c -> WALEdit.isMetaEditFamily(c))) {
            ((WALKeyImpl)logKey).clearReplicationScope();
        }
    }
}

