/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ServerRegionReplicaUtil
extends RegionReplicaUtil {
    public static final String REGION_REPLICA_REPLICATION_CONF_KEY = "hbase.region.replica.replication.enabled";
    private static final boolean DEFAULT_REGION_REPLICA_REPLICATION = false;
    @Deprecated
    public static final String REGION_REPLICA_REPLICATION_PEER = "region_replica_replication";
    public static final String REGION_REPLICA_REPLICATION_CATALOG_CONF_KEY = "hbase.region.replica.replication.catalog.enabled";
    private static final boolean DEFAULT_REGION_REPLICA_REPLICATION_CATALOG = false;
    public static final String REGION_REPLICA_STORE_FILE_REFRESH = "hbase.region.replica.storefile.refresh";
    private static final boolean DEFAULT_REGION_REPLICA_STORE_FILE_REFRESH = true;
    public static final String REGION_REPLICA_STORE_FILE_REFRESH_MEMSTORE_MULTIPLIER = "hbase.region.replica.storefile.refresh.memstore.multiplier";
    private static final double DEFAULT_REGION_REPLICA_STORE_FILE_REFRESH_MEMSTORE_MULTIPLIER = 4.0;

    public static RegionInfo getRegionInfoForFs(RegionInfo regionInfo) {
        if (regionInfo == null) {
            return null;
        }
        return RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)regionInfo);
    }

    public static boolean isReadOnly(HRegion region) {
        return region.getTableDescriptor().isReadOnly() || !ServerRegionReplicaUtil.isDefaultReplica((RegionInfo)region.getRegionInfo());
    }

    public static boolean shouldReplayRecoveredEdits(HRegion region) {
        return ServerRegionReplicaUtil.isDefaultReplica((RegionInfo)region.getRegionInfo());
    }

    public static StoreFileInfo getStoreFileInfo(Configuration conf, FileSystem fs, RegionInfo regionInfo, RegionInfo regionInfoForFs, String familyName, Path path) throws IOException {
        if (RegionInfo.COMPARATOR.compare(regionInfo, regionInfoForFs) == 0) {
            return new StoreFileInfo(conf, fs, path, true);
        }
        if (HFileLink.isHFileLink(path) || StoreFileInfo.isHFile(path)) {
            HFileLink link = HFileLink.build(conf, regionInfoForFs.getTable(), regionInfoForFs.getEncodedName(), familyName, path.getName());
            return new StoreFileInfo(conf, fs, link.getFileStatus(fs), link);
        }
        if (StoreFileInfo.isReference(path)) {
            Reference reference = Reference.read(fs, path);
            Path referencePath = StoreFileInfo.getReferredToFile(path);
            if (HFileLink.isHFileLink(referencePath)) {
                HFileLink link = HFileLink.buildFromHFileLinkPattern(conf, referencePath);
                return new StoreFileInfo(conf, fs, link.getFileStatus(fs), reference, link);
            }
            HFileLink link = HFileLink.build(conf, regionInfoForFs.getTable(), regionInfoForFs.getEncodedName(), familyName, path.getName());
            return new StoreFileInfo(conf, fs, link.getFileStatus(fs), reference);
        }
        throw new IOException("path=" + path + " doesn't look like a valid StoreFile");
    }

    public static boolean isRegionReplicaReplicationEnabled(Configuration conf, TableName tn) {
        return ServerRegionReplicaUtil.isMetaRegionReplicaReplicationEnabled(conf, tn) || ServerRegionReplicaUtil.isRegionReplicaReplicationEnabled(conf);
    }

    private static boolean isRegionReplicaReplicationEnabled(Configuration conf) {
        return conf.getBoolean(REGION_REPLICA_REPLICATION_CONF_KEY, false);
    }

    public static boolean isMetaRegionReplicaReplicationEnabled(Configuration conf, TableName tn) {
        return TableName.isMetaTableName((TableName)tn) && conf.getBoolean(REGION_REPLICA_REPLICATION_CATALOG_CONF_KEY, false);
    }

    public static boolean isRegionReplicaWaitForPrimaryFlushEnabled(Configuration conf) {
        return conf.getBoolean("hbase.region.replica.wait.for.primary.flush", true);
    }

    public static boolean isRegionReplicaStoreFileRefreshEnabled(Configuration conf) {
        return conf.getBoolean(REGION_REPLICA_STORE_FILE_REFRESH, true);
    }

    public static double getRegionReplicaStoreFileRefreshMultiplier(Configuration conf) {
        return conf.getDouble(REGION_REPLICA_STORE_FILE_REFRESH_MEMSTORE_MULTIPLIER, 4.0);
    }
}

