/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.example;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RefreshHFilesProtos;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RefreshHFilesClient
extends Configured
implements Tool,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshHFilesClient.class);
    private final Connection connection;

    public RefreshHFilesClient(Configuration cfg) {
        try {
            this.connection = ConnectionFactory.createConnection((Configuration)cfg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    public void refreshHFiles(TableName tableName) throws Throwable {
        try (Table table = this.connection.getTable(tableName);){
            this.refreshHFiles(table);
        }
    }

    public void refreshHFiles(Table table) throws Throwable {
        final RefreshHFilesProtos.RefreshHFilesRequest request = RefreshHFilesProtos.RefreshHFilesRequest.getDefaultInstance();
        table.coprocessorService(RefreshHFilesProtos.RefreshHFilesService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, (Batch.Call)new Batch.Call<RefreshHFilesProtos.RefreshHFilesService, RefreshHFilesProtos.RefreshHFilesResponse>(){

            public RefreshHFilesProtos.RefreshHFilesResponse call(RefreshHFilesProtos.RefreshHFilesService refreshHFilesService) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                refreshHFilesService.refreshHFiles((RpcController)controller, request, (RpcCallback<RefreshHFilesProtos.RefreshHFilesResponse>)rpcCallback);
                if (controller.failedOnException()) {
                    throw controller.getFailedOn();
                }
                return (RefreshHFilesProtos.RefreshHFilesResponse)rpcCallback.get();
            }
        });
        LOG.debug("Done refreshing HFiles");
    }

    public int run(String[] args) throws Exception {
        if (args.length != 1) {
            String message = "When there are multiple HBase clusters are sharing a common root dir, especially for read replica cluster (see detail in HBASE-18477), please consider to use this tool manually sync the flushed HFiles from the source cluster.";
            message = message + "\nUsage: " + this.getClass().getName() + " tableName";
            System.out.println(message);
            return -1;
        }
        TableName tableName = TableName.valueOf((String)args[0]);
        try {
            this.refreshHFiles(tableName);
        }
        catch (Throwable t) {
            LOG.error("Refresh HFiles from table " + tableName.getNameAsString() + "  failed: ", t);
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new RefreshHFilesClient(HBaseConfiguration.create()), (String[])args);
    }
}

