/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.coprocessor.example.generated.BulkDeleteProtos;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.Service;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BulkDeleteEndpoint
extends BulkDeleteProtos.BulkDeleteService
implements RegionCoprocessor {
    private static final String NO_OF_VERSIONS_TO_DELETE = "noOfVersionsToDelete";
    private static final Logger LOG = LoggerFactory.getLogger(BulkDeleteEndpoint.class);
    private RegionCoprocessorEnvironment env;

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(RpcController controller, BulkDeleteProtos.BulkDeleteRequest request, RpcCallback<BulkDeleteProtos.BulkDeleteResponse> done) {
        long totalRowsDeleted = 0L;
        long totalVersionsDeleted = 0L;
        Region region = this.env.getRegion();
        int rowBatchSize = request.getRowBatchSize();
        Long timestamp = null;
        if (request.hasTimestamp()) {
            timestamp = request.getTimestamp();
        }
        BulkDeleteProtos.BulkDeleteRequest.DeleteType deleteType = request.getDeleteType();
        boolean hasMore = true;
        RegionScanner scanner = null;
        try {
            Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
            if (scan.getFilter() == null && deleteType == BulkDeleteProtos.BulkDeleteRequest.DeleteType.ROW) {
                scan.setFilter((Filter)new FirstKeyOnlyFilter());
            }
            scanner = region.getScanner(scan);
            while (hasMore) {
                ArrayList deleteRows = new ArrayList(rowBatchSize);
                for (int i = 0; i < rowBatchSize; ++i) {
                    ArrayList results = new ArrayList();
                    hasMore = scanner.next(results);
                    if (results.size() > 0) {
                        deleteRows.add(results);
                    }
                    if (!hasMore) break;
                }
                if (deleteRows.size() <= 0) continue;
                Mutation[] deleteArr = new Mutation[deleteRows.size()];
                int i = 0;
                for (List list : deleteRows) {
                    deleteArr[i++] = this.createDeleteMutation(list, deleteType, timestamp);
                }
                OperationStatus[] opStatus = region.batchMutate(deleteArr);
                for (i = 0; i < opStatus.length && opStatus[i].getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS; ++i) {
                    byte[] byArray;
                    ++totalRowsDeleted;
                    if (deleteType != BulkDeleteProtos.BulkDeleteRequest.DeleteType.VERSION || (byArray = deleteArr[i].getAttribute(NO_OF_VERSIONS_TO_DELETE)) == null) continue;
                    totalVersionsDeleted += (long)Bytes.toInt((byte[])byArray);
                }
            }
        }
        catch (IOException ioe) {
            LOG.error(ioe.toString(), (Throwable)ioe);
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)ioe);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException ioe) {
                    LOG.error(ioe.toString(), (Throwable)ioe);
                }
            }
        }
        BulkDeleteProtos.BulkDeleteResponse.Builder responseBuilder = BulkDeleteProtos.BulkDeleteResponse.newBuilder();
        responseBuilder.setRowsDeleted(totalRowsDeleted);
        if (deleteType == BulkDeleteProtos.BulkDeleteRequest.DeleteType.VERSION) {
            responseBuilder.setVersionsDeleted(totalVersionsDeleted);
        }
        BulkDeleteProtos.BulkDeleteResponse result = responseBuilder.build();
        done.run((Object)result);
    }

    private Delete createDeleteMutation(List<Cell> deleteRow, BulkDeleteProtos.BulkDeleteRequest.DeleteType deleteType, Long timestamp) {
        long ts = timestamp == null ? Long.MAX_VALUE : timestamp;
        byte[] row = CellUtil.cloneRow((Cell)deleteRow.get(0));
        Delete delete = new Delete(row, ts);
        if (deleteType == BulkDeleteProtos.BulkDeleteRequest.DeleteType.FAMILY) {
            TreeSet<byte[]> families = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (Cell kv : deleteRow) {
                if (!families.add(CellUtil.cloneFamily((Cell)kv))) continue;
                delete.addFamily(CellUtil.cloneFamily((Cell)kv), ts);
            }
        } else if (deleteType == BulkDeleteProtos.BulkDeleteRequest.DeleteType.COLUMN) {
            HashSet<Column> columns = new HashSet<Column>();
            for (Cell kv : deleteRow) {
                Column column = new Column(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv));
                if (!columns.add(column)) continue;
                delete.addColumns(column.family, column.qualifier, ts);
            }
        } else if (deleteType == BulkDeleteProtos.BulkDeleteRequest.DeleteType.VERSION) {
            int noOfVersionsToDelete = 0;
            if (timestamp == null) {
                for (Cell kv : deleteRow) {
                    delete.addColumn(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), kv.getTimestamp());
                    ++noOfVersionsToDelete;
                }
            } else {
                HashSet<Column> columns = new HashSet<Column>();
                for (Cell kv : deleteRow) {
                    Column column = new Column(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv));
                    if (!columns.add(column)) continue;
                    delete.addColumn(column.family, column.qualifier, ts);
                    ++noOfVersionsToDelete;
                }
            }
            delete.setAttribute(NO_OF_VERSIONS_TO_DELETE, Bytes.toBytes((int)noOfVersionsToDelete));
        }
        return delete;
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    private static class Column {
        private byte[] family;
        private byte[] qualifier;

        public Column(byte[] family, byte[] qualifier) {
            this.family = family;
            this.qualifier = qualifier;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Column)) {
                return false;
            }
            Column column = (Column)other;
            return Bytes.equals((byte[])this.family, (byte[])column.family) && Bytes.equals((byte[])this.qualifier, (byte[])column.qualifier);
        }

        public int hashCode() {
            int h = 31;
            h += 13 * Bytes.hashCode((byte[])this.family);
            return h += 13 * Bytes.hashCode((byte[])this.qualifier);
        }
    }
}

