/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class StoreContext
implements HeapSize {
    public static final long FIXED_OVERHEAD = ClassSize.estimateBase(HStore.class, false);
    private final int blockSize;
    private final Encryption.Context encryptionContext;
    private final CacheConfig cacheConf;
    private final HRegionFileSystem regionFileSystem;
    private final CellComparator comparator;
    private final BloomType bloomFilterType;
    private final Supplier<Collection<HStoreFile>> compactedFilesSupplier;
    private final Supplier<InetSocketAddress[]> favoredNodesSupplier;
    private final ColumnFamilyDescriptor family;
    private final Path familyStoreDirectoryPath;
    private final RegionCoprocessorHost coprocessorHost;

    private StoreContext(Builder builder) {
        this.blockSize = builder.blockSize;
        this.encryptionContext = builder.encryptionContext;
        this.cacheConf = builder.cacheConf;
        this.regionFileSystem = builder.regionFileSystem;
        this.comparator = builder.comparator;
        this.bloomFilterType = builder.bloomFilterType;
        this.compactedFilesSupplier = builder.compactedFilesSupplier;
        this.favoredNodesSupplier = builder.favoredNodesSupplier;
        this.family = builder.family;
        this.familyStoreDirectoryPath = builder.familyStoreDirectoryPath;
        this.coprocessorHost = builder.coprocessorHost;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public Encryption.Context getEncryptionContext() {
        return this.encryptionContext;
    }

    public CacheConfig getCacheConf() {
        return this.cacheConf;
    }

    public HRegionFileSystem getRegionFileSystem() {
        return this.regionFileSystem;
    }

    public CellComparator getComparator() {
        return this.comparator;
    }

    public BloomType getBloomFilterType() {
        return this.bloomFilterType;
    }

    public Supplier<Collection<HStoreFile>> getCompactedFilesSupplier() {
        return this.compactedFilesSupplier;
    }

    public InetSocketAddress[] getFavoredNodes() {
        return this.favoredNodesSupplier.get();
    }

    public ColumnFamilyDescriptor getFamily() {
        return this.family;
    }

    public Path getFamilyStoreDirectoryPath() {
        return this.familyStoreDirectoryPath;
    }

    public RegionCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    public TableName getTableName() {
        return this.getRegionInfo().getTable();
    }

    public RegionInfo getRegionInfo() {
        return this.regionFileSystem.getRegionInfo();
    }

    public boolean isPrimaryReplicaStore() {
        return this.getRegionInfo().getReplicaId() == 0;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    @Override
    public long heapSize() {
        return FIXED_OVERHEAD;
    }

    public static class Builder {
        private int blockSize;
        private Encryption.Context encryptionContext;
        private CacheConfig cacheConf;
        private HRegionFileSystem regionFileSystem;
        private CellComparator comparator;
        private BloomType bloomFilterType;
        private Supplier<Collection<HStoreFile>> compactedFilesSupplier;
        private Supplier<InetSocketAddress[]> favoredNodesSupplier;
        private ColumnFamilyDescriptor family;
        private Path familyStoreDirectoryPath;
        private RegionCoprocessorHost coprocessorHost;

        public Builder withBlockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder withEncryptionContext(Encryption.Context encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        public Builder withCacheConfig(CacheConfig cacheConf) {
            this.cacheConf = cacheConf;
            return this;
        }

        public Builder withRegionFileSystem(HRegionFileSystem regionFileSystem) {
            this.regionFileSystem = regionFileSystem;
            return this;
        }

        public Builder withCellComparator(CellComparator comparator) {
            this.comparator = comparator;
            return this;
        }

        public Builder withBloomType(BloomType bloomFilterType) {
            this.bloomFilterType = bloomFilterType;
            return this;
        }

        public Builder withCompactedFilesSupplier(Supplier<Collection<HStoreFile>> compactedFilesSupplier) {
            this.compactedFilesSupplier = compactedFilesSupplier;
            return this;
        }

        public Builder withFavoredNodesSupplier(Supplier<InetSocketAddress[]> favoredNodesSupplier) {
            this.favoredNodesSupplier = favoredNodesSupplier;
            return this;
        }

        public Builder withColumnFamilyDescriptor(ColumnFamilyDescriptor family) {
            this.family = family;
            return this;
        }

        public Builder withFamilyStoreDirectoryPath(Path familyStoreDirectoryPath) {
            this.familyStoreDirectoryPath = familyStoreDirectoryPath;
            return this;
        }

        public Builder withRegionCoprocessorHost(RegionCoprocessorHost coprocessorHost) {
            this.coprocessorHost = coprocessorHost;
            return this;
        }

        public StoreContext build() {
            return new StoreContext(this);
        }
    }
}

