/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.shaded.protobuf.generated.StoreFileTrackerProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class StoreFileListFile {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFileListFile.class);
    static final String TRACK_FILE_DIR = ".filelist";
    private static final String TRACK_FILE = "f1";
    private static final String TRACK_FILE_ROTATE = "f2";
    private static final int MAX_FILE_SIZE = 0x1000000;
    private final StoreContext ctx;
    private final Path trackFileDir;
    private final Path[] trackFiles = new Path[2];
    private long prevTimestamp = -1L;
    private int nextTrackFile = -1;

    StoreFileListFile(StoreContext ctx) {
        this.ctx = ctx;
        this.trackFileDir = new Path(ctx.getFamilyStoreDirectoryPath(), TRACK_FILE_DIR);
        this.trackFiles[0] = new Path(this.trackFileDir, TRACK_FILE);
        this.trackFiles[1] = new Path(this.trackFileDir, TRACK_FILE_ROTATE);
    }

    private StoreFileTrackerProtos.StoreFileList load(Path path) throws IOException {
        int expectedChecksum;
        byte[] data;
        FileSystem fs = this.ctx.getRegionFileSystem().getFileSystem();
        try (FSDataInputStream in = fs.open(path);){
            int length = in.readInt();
            if (length <= 0 || length > 0x1000000) {
                throw new IOException("Invalid file length " + length + ", either less than 0 or greater then max allowed size " + 0x1000000);
            }
            data = new byte[length];
            in.readFully(data);
            expectedChecksum = in.readInt();
        }
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        int calculatedChecksum = (int)crc32.getValue();
        if (expectedChecksum != calculatedChecksum) {
            throw new IOException("Checksum mismatch, expected " + expectedChecksum + ", actual " + calculatedChecksum);
        }
        return StoreFileTrackerProtos.StoreFileList.parseFrom(data);
    }

    private int select(StoreFileTrackerProtos.StoreFileList[] lists) {
        if (lists[0] == null) {
            return 1;
        }
        if (lists[1] == null) {
            return 0;
        }
        return lists[0].getTimestamp() >= lists[1].getTimestamp() ? 0 : 1;
    }

    StoreFileTrackerProtos.StoreFileList load() throws IOException {
        StoreFileTrackerProtos.StoreFileList[] lists = new StoreFileTrackerProtos.StoreFileList[2];
        for (int i = 0; i < 2; ++i) {
            try {
                lists[i] = this.load(this.trackFiles[i]);
                continue;
            }
            catch (EOFException | FileNotFoundException e) {
                LOG.debug("EOF loading track file {}, ignoring the exception", (Object)this.trackFiles[i], (Object)e);
            }
        }
        int winnerIndex = this.select(lists);
        if (lists[winnerIndex] != null) {
            this.nextTrackFile = 1 - winnerIndex;
            this.prevTimestamp = lists[winnerIndex].getTimestamp();
        } else {
            this.nextTrackFile = 0;
        }
        return lists[winnerIndex];
    }

    void update(StoreFileTrackerProtos.StoreFileList.Builder builder) throws IOException {
        if (this.nextTrackFile < 0) {
            this.load();
        }
        long timestamp = Math.max(this.prevTimestamp + 1L, EnvironmentEdgeManager.currentTime());
        byte[] actualData = builder.setTimestamp(timestamp).build().toByteArray();
        CRC32 crc32 = new CRC32();
        crc32.update(actualData);
        int checksum = (int)crc32.getValue();
        FileSystem fs = this.ctx.getRegionFileSystem().getFileSystem();
        try (FSDataOutputStream out = fs.create(this.trackFiles[this.nextTrackFile], true);){
            out.writeInt(actualData.length);
            out.write(actualData);
            out.writeInt(checksum);
        }
        this.prevTimestamp = timestamp;
        this.nextTrackFile = 1 - this.nextTrackFile;
        try {
            fs.delete(this.trackFiles[this.nextTrackFile], false);
        }
        catch (IOException e) {
            LOG.debug("Failed to delete old track file {}, ignoring the exception", (Object)this.trackFiles[this.nextTrackFile], (Object)e);
        }
    }
}

