/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.datasources;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.hbase.spark.AvroSerdes$;
import org.apache.hadoop.hbase.spark.example.datasources.AvroHBaseRecord;
import org.apache.yetus.audience.InterfaceAudience;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

@InterfaceAudience.Private
public final class AvroHBaseRecord$
implements Serializable {
    public static AvroHBaseRecord$ MODULE$;
    private final String schemaString;
    private final Schema avroSchema;

    static {
        new AvroHBaseRecord$();
    }

    public String schemaString() {
        return this.schemaString;
    }

    public Schema avroSchema() {
        return this.avroSchema;
    }

    public AvroHBaseRecord apply(int i) {
        GenericData.Record user = new GenericData.Record(this.avroSchema());
        user.put("name", (Object)new StringBuilder(4).append("name").append(new StringOps(Predef$.MODULE$.augmentString("%03d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))).toString());
        user.put("favorite_number", (Object)BoxesRunTime.boxToInteger((int)i));
        user.put("favorite_color", (Object)new StringBuilder(5).append("color").append(new StringOps(Predef$.MODULE$.augmentString("%03d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))).toString());
        GenericData.Array favoriteArray = new GenericData.Array(2, this.avroSchema().getField("favorite_array").schema());
        favoriteArray.add((Object)new StringBuilder(6).append("number").append(i).toString());
        favoriteArray.add((Object)new StringBuilder(6).append("number").append(i + 1).toString());
        user.put("favorite_array", (Object)favoriteArray);
        java.util.Map favoriteMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)BoxesRunTime.boxToInteger((int)i)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)BoxesRunTime.boxToInteger((int)(i + 1)))}))).asJava();
        user.put("favorite_map", (Object)favoriteMap);
        byte[] avroByte = AvroSerdes$.MODULE$.serialize(user, this.avroSchema());
        return new AvroHBaseRecord(new StringBuilder(4).append("name").append(new StringOps(Predef$.MODULE$.augmentString("%03d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))).toString(), avroByte);
    }

    public AvroHBaseRecord apply(String col0, byte[] col1) {
        return new AvroHBaseRecord(col0, col1);
    }

    public Option<Tuple2<String, byte[]>> unapply(AvroHBaseRecord x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.col0(), (Object)x$0.col1()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AvroHBaseRecord$() {
        MODULE$ = this;
        this.schemaString = new StringOps(Predef$.MODULE$.augmentString("{\"namespace\": \"example.avro\",\n        |   \"type\": \"record\",      \"name\": \"User\",\n        |    \"fields\": [\n        |        {\"name\": \"name\", \"type\": \"string\"},\n        |        {\"name\": \"favorite_number\",  \"type\": [\"int\", \"null\"]},\n        |        {\"name\": \"favorite_color\", \"type\": [\"string\", \"null\"]},\n        |        {\"name\": \"favorite_array\", \"type\": {\"type\": \"array\", \"items\": \"string\"}},\n        |        {\"name\": \"favorite_map\", \"type\": {\"type\": \"map\", \"values\": \"int\"}}\n        |      ]    }")).stripMargin();
        Schema.Parser p = new Schema.Parser();
        this.avroSchema = p.parse(this.schemaString());
    }
}

