/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.rebalancer.util.RebalanceScheduler;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.util.InstanceValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedRebalanceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedRebalanceUtil.class);
    private static RebalanceScheduler REBALANCE_SCHEDULER = new RebalanceScheduler();

    public static boolean isDelayRebalanceEnabled(ClusterConfig clusterConfig) {
        long delay = clusterConfig.getRebalanceDelayTime();
        return delay > 0L && clusterConfig.isDelayRebalaceEnabled();
    }

    public static boolean isDelayRebalanceEnabled(IdealState idealState, ClusterConfig clusterConfig) {
        long delay = DelayedRebalanceUtil.getRebalanceDelay(idealState, clusterConfig);
        return delay > 0L && idealState.isDelayRebalanceEnabled() && clusterConfig.isDelayRebalaceEnabled();
    }

    public static long getRebalanceDelay(IdealState idealState, ClusterConfig clusterConfig) {
        long delayTime = idealState.getRebalanceDelay();
        if (delayTime < 0L) {
            delayTime = clusterConfig.getRebalanceDelayTime();
        }
        return delayTime;
    }

    public static Set<String> getActiveNodes(Set<String> allNodes, Set<String> liveEnabledNodes, Map<String, Long> instanceOfflineTimeMap, Set<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, ClusterConfig clusterConfig) {
        if (!DelayedRebalanceUtil.isDelayRebalanceEnabled(clusterConfig)) {
            return new HashSet<String>(liveEnabledNodes);
        }
        return DelayedRebalanceUtil.getActiveNodes(allNodes, liveEnabledNodes, instanceOfflineTimeMap, liveNodes, instanceConfigMap, clusterConfig.getRebalanceDelayTime(), clusterConfig);
    }

    public static Set<String> getActiveNodes(Set<String> allNodes, IdealState idealState, Set<String> liveEnabledNodes, Map<String, Long> instanceOfflineTimeMap, Set<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, long delay, ClusterConfig clusterConfig) {
        if (!DelayedRebalanceUtil.isDelayRebalanceEnabled(idealState, clusterConfig)) {
            return new HashSet<String>(liveEnabledNodes);
        }
        return DelayedRebalanceUtil.getActiveNodes(allNodes, liveEnabledNodes, instanceOfflineTimeMap, liveNodes, instanceConfigMap, delay, clusterConfig);
    }

    private static Set<String> getActiveNodes(Set<String> allNodes, Set<String> liveEnabledNodes, Map<String, Long> instanceOfflineTimeMap, Set<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, long delay, ClusterConfig clusterConfig) {
        HashSet<String> activeNodes = new HashSet<String>(liveEnabledNodes);
        HashSet<String> offlineOrDisabledInstances = new HashSet<String>(allNodes);
        offlineOrDisabledInstances.removeAll(liveEnabledNodes);
        long currentTime = System.currentTimeMillis();
        for (String ins : offlineOrDisabledInstances) {
            long inactiveTime = DelayedRebalanceUtil.getInactiveTime(ins, liveNodes, instanceOfflineTimeMap.get(ins), delay, instanceConfigMap.get(ins), clusterConfig);
            InstanceConfig instanceConfig = instanceConfigMap.get(ins);
            if (inactiveTime <= currentTime || instanceConfig == null || !instanceConfig.isDelayRebalanceEnabled()) continue;
            activeNodes.add(ins);
        }
        return activeNodes;
    }

    private static long getInactiveTime(String instance, Set<String> liveInstances, Long offlineTime, long delay, InstanceConfig instanceConfig, ClusterConfig clusterConfig) {
        long inactiveTime = Long.MAX_VALUE;
        if (!liveInstances.contains(instance) && offlineTime != null && offlineTime > 0L && offlineTime + delay < inactiveTime) {
            inactiveTime = offlineTime + delay;
        }
        if (!InstanceValidationUtil.isInstanceEnabled(instanceConfig, clusterConfig)) {
            long disabledTime = instanceConfig.getInstanceEnabledTime();
            String batchedDisabledTime = clusterConfig.getInstanceHelixDisabledTimeStamp(instance);
            if (batchedDisabledTime != null && !batchedDisabledTime.isEmpty()) {
                long batchDisableTime = Long.parseLong(batchedDisabledTime);
                if (disabledTime == -1L || disabledTime > batchDisableTime) {
                    disabledTime = batchDisableTime;
                }
            }
            if (disabledTime > 0L && disabledTime + delay < inactiveTime) {
                inactiveTime = disabledTime + delay;
            }
        }
        if (inactiveTime == Long.MAX_VALUE) {
            return -1L;
        }
        return inactiveTime;
    }

    public static Map<String, List<String>> getFinalDelayedMapping(Map<String, List<String>> newIdealPreferenceList, Map<String, List<String>> newDelayedPreferenceList, Set<String> liveEnabledInstances, int minActiveReplica) {
        HashMap<String, List<String>> finalPreferenceList = new HashMap<String, List<String>>();
        for (String partition : newIdealPreferenceList.keySet()) {
            List<String> idealList = newIdealPreferenceList.get(partition);
            List<String> delayedIdealList = newDelayedPreferenceList.get(partition);
            ArrayList<String> liveList = new ArrayList<String>();
            for (String ins : delayedIdealList) {
                if (!liveEnabledInstances.contains(ins)) continue;
                liveList.add(ins);
            }
            if (liveList.size() >= minActiveReplica) {
                finalPreferenceList.put(partition, delayedIdealList);
                continue;
            }
            ArrayList<String> candidates = new ArrayList<String>(idealList);
            candidates.removeAll(delayedIdealList);
            for (String liveIns : candidates) {
                liveList.add(liveIns);
                if (liveList.size() < minActiveReplica) continue;
                break;
            }
            finalPreferenceList.put(partition, liveList);
        }
        return finalPreferenceList;
    }

    public static int getMinActiveReplica(ResourceConfig resourceConfig, IdealState idealState, int replicaCount) {
        int minActiveReplicas;
        int n = minActiveReplicas = resourceConfig == null ? -1 : resourceConfig.getMinActiveReplica();
        if (minActiveReplicas < 0) {
            minActiveReplicas = idealState.getMinActiveReplicas();
        }
        if (minActiveReplicas < 0) {
            minActiveReplicas = replicaCount;
        }
        return minActiveReplicas;
    }

    public static void setRebalanceScheduler(String resourceName, boolean isDelayedRebalanceEnabled, Set<String> offlineOrDisabledInstances, Map<String, Long> instanceOfflineTimeMap, Set<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, long delay, ClusterConfig clusterConfig, HelixManager manager) {
        if (!isDelayedRebalanceEnabled) {
            REBALANCE_SCHEDULER.removeScheduledRebalance(resourceName);
            return;
        }
        long currentTime = System.currentTimeMillis();
        long nextRebalanceTime = Long.MAX_VALUE;
        for (String ins : offlineOrDisabledInstances) {
            long inactiveTime = DelayedRebalanceUtil.getInactiveTime(ins, liveNodes, instanceOfflineTimeMap.get(ins), delay, instanceConfigMap.get(ins), clusterConfig);
            if (inactiveTime == -1L || inactiveTime <= currentTime || inactiveTime >= nextRebalanceTime) continue;
            nextRebalanceTime = inactiveTime;
        }
        if (nextRebalanceTime == Long.MAX_VALUE) {
            long startTime = REBALANCE_SCHEDULER.removeScheduledRebalance(resourceName);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Remove exist rebalance timer for resource %s at %d\n", resourceName, startTime));
            }
        } else {
            long currentScheduledTime = REBALANCE_SCHEDULER.getRebalanceTime(resourceName);
            if (currentScheduledTime < 0L || currentScheduledTime > nextRebalanceTime) {
                REBALANCE_SCHEDULER.scheduleRebalance(manager, resourceName, nextRebalanceTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Set next rebalance time for resource %s at time %d\n", resourceName, nextRebalanceTime));
                }
            }
        }
    }
}

