/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.scanning;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.server.ResourceFinder;

public final class JarFileScanner
implements ResourceFinder {
    private static final Logger LOGGER = Logger.getLogger(JarFileScanner.class.getName());
    private static final char JAR_FILE_SEPARATOR = '\\';
    private final JarInputStream jarInputStream;
    private final String parent;
    private final boolean recursive;
    private JarEntry next = null;

    public JarFileScanner(InputStream inputStream, String parent, boolean recursive) throws IOException {
        this.jarInputStream = new JarInputStream(inputStream);
        this.parent = parent;
        this.recursive = recursive;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            try {
                String suffix;
                do {
                    this.next = this.jarInputStream.getNextJarEntry();
                } while (this.next != null && (this.next.isDirectory() || !this.next.getName().startsWith(this.parent) || !this.recursive && (suffix = this.next.getName().substring(this.parent.length())).lastIndexOf(92) > 0));
            }
            catch (IOException e) {
                LOGGER.log(Level.CONFIG, "Unable to read the next jar entry.", e);
                return false;
            }
            catch (SecurityException e) {
                LOGGER.log(Level.CONFIG, "Unable to read the next jar entry.", e);
                return false;
            }
        }
        if (this.next == null) {
            try {
                this.jarInputStream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Unable to close jar file.", e);
            }
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        if (this.next != null || this.hasNext()) {
            String name = this.next.getName();
            this.next = null;
            return name;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream open() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return JarFileScanner.this.jarInputStream.read();
            }

            @Override
            public int read(byte[] bytes) throws IOException {
                return JarFileScanner.this.jarInputStream.read(bytes);
            }

            @Override
            public int read(byte[] bytes, int i, int i2) throws IOException {
                return JarFileScanner.this.jarInputStream.read(bytes, i, i2);
            }

            @Override
            public long skip(long l) throws IOException {
                return JarFileScanner.this.jarInputStream.skip(l);
            }

            @Override
            public int available() throws IOException {
                return JarFileScanner.this.jarInputStream.available();
            }

            @Override
            public void close() throws IOException {
                JarFileScanner.this.jarInputStream.closeEntry();
            }

            @Override
            public synchronized void mark(int i) {
                JarFileScanner.this.jarInputStream.mark(i);
            }

            @Override
            public synchronized void reset() throws IOException {
                JarFileScanner.this.jarInputStream.reset();
            }

            @Override
            public boolean markSupported() {
                return JarFileScanner.this.jarInputStream.markSupported();
            }
        };
    }
}

