/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model.builder;

import java.util.Arrays;
import org.apache.helix.model.HelixConfigScope;

public class HelixConfigScopeBuilder {
    private final HelixConfigScope.ConfigScopeProperty _type;
    private String _clusterName;
    private String _participantName;
    private String _resourceName;
    private String _partitionName;

    public HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty type, String ... keys) {
        int argNum = type.getZkPathArgNum() + type.getMapKeyArgNum();
        if (keys == null || keys.length != argNum && keys.length != argNum - 1) {
            throw new IllegalArgumentException("invalid keys. type: " + (Object)((Object)type) + ", keys: " + Arrays.asList(keys));
        }
        this._type = type;
        this._clusterName = keys[0];
        switch (type) {
            case CLUSTER: {
                break;
            }
            case REST: {
                break;
            }
            case PARTICIPANT: {
                if (keys.length <= 1) break;
                this._participantName = keys[1];
                break;
            }
            case RESOURCE: {
                if (keys.length <= 1) break;
                this._resourceName = keys[1];
                break;
            }
            case PARTITION: {
                this._resourceName = keys[1];
                if (keys.length <= 2) break;
                this._partitionName = keys[2];
                break;
            }
        }
    }

    public HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty type) {
        this._type = type;
    }

    public HelixConfigScopeBuilder forCluster(String clusterName) {
        this._clusterName = clusterName;
        return this;
    }

    public HelixConfigScopeBuilder forParticipant(String participantName) {
        this._participantName = participantName;
        return this;
    }

    public HelixConfigScopeBuilder forResource(String resourceName) {
        this._resourceName = resourceName;
        return this;
    }

    public HelixConfigScopeBuilder forPartition(String partitionName) {
        this._partitionName = partitionName;
        return this;
    }

    public HelixConfigScope build() {
        HelixConfigScope scope = null;
        switch (this._type) {
            case CLUSTER: {
                scope = new HelixConfigScope(this._type, Arrays.asList(this._clusterName, this._clusterName), null);
                break;
            }
            case PARTICIPANT: {
                if (this._participantName == null) {
                    scope = new HelixConfigScope(this._type, Arrays.asList(this._clusterName), null);
                    break;
                }
                scope = new HelixConfigScope(this._type, Arrays.asList(this._clusterName, this._participantName), null);
                break;
            }
            case RESOURCE: {
                if (this._resourceName == null) {
                    scope = new HelixConfigScope(this._type, Arrays.asList(this._clusterName), null);
                    break;
                }
                scope = new HelixConfigScope(this._type, Arrays.asList(this._clusterName, this._resourceName), null);
                break;
            }
            case PARTITION: {
                if (this._partitionName == null) {
                    scope = new HelixConfigScope(this._type, Arrays.asList(this._clusterName, this._resourceName), null);
                    break;
                }
                scope = new HelixConfigScope(this._type, Arrays.asList(this._clusterName, this._resourceName), this._partitionName);
                break;
            }
            case REST: {
                scope = new HelixConfigScope(this._type, Arrays.asList(this._clusterName, this._clusterName), null);
                break;
            }
            case CLOUD: {
                scope = new HelixConfigScope(this._type, Arrays.asList(this._clusterName, this._clusterName), null);
                break;
            }
            case CUSTOMIZED_STATE_AGGREGATION: 
            case CUSTOMIZED_STATE: {
                scope = new HelixConfigScope(this._type, Arrays.asList(this._clusterName, this._clusterName), null);
            }
        }
        return scope;
    }
}

