/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyType;
import org.apache.helix.controller.common.PartitionStateMap;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.rebalancer.strategy.RebalanceStrategy;
import org.apache.helix.controller.rebalancer.waged.ReadOnlyWagedRebalancer;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateCalcStage;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.ClusterEventType;
import org.apache.helix.controller.stages.CurrentStateComputationStage;
import org.apache.helix.controller.stages.ResourceComputationStage;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkBucketDataAccessor;
import org.apache.helix.model.BuiltInStateModelDefinitions;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.util.InstanceValidationUtil;
import org.apache.helix.util.RebalanceUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelixUtil {
    private static Logger LOG = LoggerFactory.getLogger(HelixUtil.class);

    private HelixUtil() {
    }

    public static String getInstanceNameFromPath(String path) {
        String[] split;
        if (path.contains("/" + PropertyType.INSTANCES + "/") && (split = path.split("\\/")).length > 3) {
            return split[3];
        }
        return null;
    }

    public static String getZkParentPath(String path) {
        if (path.equals("/")) {
            return null;
        }
        int idx = path.lastIndexOf(47);
        return idx == 0 ? "/" : path.substring(0, idx);
    }

    public static String getZkName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static String clusterNameToShardingKey(String clusterName) {
        return clusterName.charAt(0) == '/' ? clusterName : "/" + clusterName;
    }

    public static String serializeByComma(List<String> objects) {
        return Joiner.on((String)",").join(objects);
    }

    public static List<String> deserializeByComma(String object) {
        if (object.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(object.split(","));
    }

    public static Map<String, String> parseCsvFormatedKeyValuePairs(String keyValuePairs) {
        String[] pairs = keyValuePairs.split("[\\s,]");
        TreeMap<String, String> keyValueMap = new TreeMap<String, String>();
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                LOG.error("Invalid key-value pair: " + pair + ". Igonore it.");
                continue;
            }
            String key = pair.substring(0, idx);
            String value = pair.substring(idx + 1);
            keyValueMap.put(key, value);
        }
        return keyValueMap;
    }

    public static <T> Class<?> loadClass(Class<T> clazz, String className) throws ClassNotFoundException {
        try {
            return clazz.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            throw ex;
        }
    }

    public static Map<String, ResourceAssignment> getTargetAssignmentForWagedFullAuto(String metadataStoreAddress, ClusterConfig clusterConfig, List<InstanceConfig> instanceConfigs, List<String> liveInstances, List<IdealState> idealStates, List<ResourceConfig> resourceConfigs) {
        ZkBaseDataAccessor<ZNRecord> baseDataAccessor = new ZkBaseDataAccessor<ZNRecord>(metadataStoreAddress);
        Map<String, ResourceAssignment> result = HelixUtil.getAssignmentForWagedFullAutoImpl(new ZkBucketDataAccessor(metadataStoreAddress), baseDataAccessor, clusterConfig, instanceConfigs, liveInstances, idealStates, resourceConfigs, false);
        baseDataAccessor.close();
        return result;
    }

    public static Map<String, ResourceAssignment> getTargetAssignmentForWagedFullAuto(ZkBucketDataAccessor zkBucketDataAccessor, BaseDataAccessor<ZNRecord> baseDataAccessor, ClusterConfig clusterConfig, List<InstanceConfig> instanceConfigs, List<String> liveInstances, List<IdealState> idealStates, List<ResourceConfig> resourceConfigs) {
        return HelixUtil.getAssignmentForWagedFullAutoImpl(zkBucketDataAccessor, baseDataAccessor, clusterConfig, instanceConfigs, liveInstances, idealStates, resourceConfigs, true);
    }

    public static Map<String, ResourceAssignment> getImmediateAssignmentForWagedFullAuto(String metadataStoreAddress, ClusterConfig clusterConfig, List<InstanceConfig> instanceConfigs, List<String> liveInstances, List<IdealState> idealStates, List<ResourceConfig> resourceConfigs) {
        ZkBaseDataAccessor<ZNRecord> baseDataAccessor = new ZkBaseDataAccessor<ZNRecord>(metadataStoreAddress);
        Map<String, ResourceAssignment> result = HelixUtil.getAssignmentForWagedFullAutoImpl(new ZkBucketDataAccessor(metadataStoreAddress), baseDataAccessor, clusterConfig, instanceConfigs, liveInstances, idealStates, resourceConfigs, false);
        baseDataAccessor.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ResourceAssignment> getAssignmentForWagedFullAutoImpl(ZkBucketDataAccessor zkBucketDataAccessor, BaseDataAccessor<ZNRecord> baseDataAccessor, ClusterConfig clusterConfig, List<InstanceConfig> instanceConfigs, List<String> liveInstances, List<IdealState> idealStates, List<ResourceConfig> resourceConfigs, boolean usePrefLists) {
        ClusterConfig globalSyncClusterConfig = new ClusterConfig(clusterConfig.getRecord());
        globalSyncClusterConfig.setGlobalRebalanceAsyncMode(false);
        ZKHelixDataAccessor helixDataAccessor = new ZKHelixDataAccessor(globalSyncClusterConfig.getClusterName(), baseDataAccessor);
        ReadOnlyWagedRebalancer readOnlyWagedRebalancer = new ReadOnlyWagedRebalancer(zkBucketDataAccessor, globalSyncClusterConfig.getClusterName(), globalSyncClusterConfig.getGlobalRebalancePreference());
        ClusterEvent event = new ClusterEvent(globalSyncClusterConfig.getClusterName(), ClusterEventType.Unknown);
        try {
            ResourceControllerDataProvider dataProvider = new ResourceControllerDataProvider(globalSyncClusterConfig.getClusterName());
            dataProvider.requireFullRefresh();
            dataProvider.refresh(helixDataAccessor);
            readOnlyWagedRebalancer.updateChangeDetectorSnapshots(dataProvider);
            dataProvider.requireFullRefresh();
            dataProvider.refresh(helixDataAccessor);
            dataProvider.setClusterConfig(globalSyncClusterConfig);
            dataProvider.setInstanceConfigMap(instanceConfigs.stream().collect(Collectors.toMap(InstanceConfig::getInstanceName, Function.identity())));
            Map<String, LiveInstance> liveInstanceMap = dataProvider.getLiveInstances();
            List filteredLiveInstances = liveInstanceMap.entrySet().stream().filter(entry -> liveInstances.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            ArrayList<String> liveInstanceList = new ArrayList<String>(liveInstances);
            liveInstanceList.removeAll(filteredLiveInstances.stream().map(LiveInstance::getInstanceName).collect(Collectors.toList()));
            liveInstanceList.forEach(liveInstanceName -> {
                LiveInstance newLiveInstanceObj = new LiveInstance((String)liveInstanceName);
                newLiveInstanceObj.getRecord().setSimpleField(LiveInstance.LiveInstanceProperty.SESSION_ID.name(), UUID.randomUUID().toString().replace("-", ""));
                filteredLiveInstances.add(newLiveInstanceObj);
            });
            dataProvider.setLiveInstances(new ArrayList<LiveInstance>(filteredLiveInstances));
            dataProvider.setIdealStates(idealStates);
            dataProvider.setResourceConfigMap(resourceConfigs.stream().collect(Collectors.toMap(ResourceConfig::getResourceName, Function.identity())));
            event.addAttribute(AttributeName.ControllerDataProvider.name(), dataProvider);
            event.addAttribute(AttributeName.STATEFUL_REBALANCER.name(), readOnlyWagedRebalancer);
            RebalanceUtil.runStage(event, new ResourceComputationStage());
            RebalanceUtil.runStage(event, new CurrentStateComputationStage());
            RebalanceUtil.runStage(event, new BestPossibleStateCalcStage());
        }
        catch (Exception e) {
            LOG.error("getIdealAssignmentForWagedFullAuto(): Failed to compute ResourceAssignments!", (Throwable)e);
        }
        finally {
            readOnlyWagedRebalancer.close();
        }
        HashMap<String, ResourceAssignment> result = new HashMap<String, ResourceAssignment>();
        BestPossibleStateOutput output = (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
        if (output == null || output.getPreferenceLists() == null && output.getResourceStatesMap().isEmpty()) {
            throw new HelixException("getIdealAssignmentForWagedFullAuto(): Calculation failed: Failed to compute BestPossibleState!");
        }
        for (IdealState idealState : idealStates) {
            String resourceName = idealState.getResourceName();
            StateModelDefinition stateModelDefinition = BuiltInStateModelDefinitions.valueOf(idealState.getStateModelDefRef()).getStateModelDefinition();
            PartitionStateMap partitionStateMap = output.getPartitionStateMap(resourceName);
            ResourceAssignment resourceAssignment = new ResourceAssignment(resourceName);
            for (String partitionName : idealState.getPartitionSet()) {
                Partition partition = new Partition(partitionName);
                if (usePrefLists) {
                    resourceAssignment.addReplicaMap(partition, HelixUtil.computeIdealMapping(output.getPreferenceList(resourceName, partitionName), stateModelDefinition, new HashSet<String>(liveInstances)));
                    continue;
                }
                resourceAssignment.addReplicaMap(partition, partitionStateMap.getPartitionMap(partition));
            }
            result.put(resourceName, resourceAssignment);
        }
        return result;
    }

    public static Map<String, Map<String, String>> getIdealAssignmentForFullAuto(ClusterConfig clusterConfig, List<InstanceConfig> instanceConfigs, List<String> liveInstances, IdealState idealState, List<String> partitions, String strategyClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList<String> allNodes = new ArrayList<String>();
        HashMap<String, InstanceConfig> instanceConfigMap = new HashMap<String, InstanceConfig>();
        for (InstanceConfig instanceConfig2 : instanceConfigs) {
            allNodes.add(instanceConfig2.getInstanceName());
            instanceConfigMap.put(instanceConfig2.getInstanceName(), instanceConfig2);
        }
        ResourceControllerDataProvider cache = new ResourceControllerDataProvider();
        cache.setClusterConfig(clusterConfig);
        cache.setInstanceConfigMap(instanceConfigMap);
        StateModelDefinition stateModelDefinition = BuiltInStateModelDefinitions.valueOf(idealState.getStateModelDefRef()).getStateModelDefinition();
        RebalanceStrategy strategy = (RebalanceStrategy)RebalanceStrategy.class.cast(HelixUtil.loadClass(HelixUtil.class, strategyClassName).newInstance());
        strategy.init(idealState.getResourceName(), partitions, stateModelDefinition.getStateCountMap(liveInstances.size(), Integer.parseInt(idealState.getReplicas())), idealState.getMaxPartitionsPerInstance());
        List disabledInstance = instanceConfigs.stream().filter(instanceConfig -> !InstanceValidationUtil.isInstanceEnabled(instanceConfig, clusterConfig)).map(InstanceConfig::getInstanceName).collect(Collectors.toList());
        liveInstances.removeAll(disabledInstance);
        Map<String, List<String>> preferenceLists = strategy.computePartitionAssignment(allNodes, liveInstances, new HashMap<String, Map<String, String>>(), cache).getListFields();
        HashMap<String, Map<String, String>> idealStateMapping = new HashMap<String, Map<String, String>>();
        HashSet<String> liveInstanceSet = new HashSet<String>(liveInstances);
        for (String partitionName : preferenceLists.keySet()) {
            idealStateMapping.put(partitionName, HelixUtil.computeIdealMapping(preferenceLists.get(partitionName), stateModelDefinition, liveInstanceSet));
        }
        return idealStateMapping;
    }

    public static Map<String, String> computeIdealMapping(List<String> preferenceList, StateModelDefinition stateModelDef, Set<String> liveAndEnabled) {
        return HelixUtil.computeIdealMapping(preferenceList, stateModelDef, liveAndEnabled, Collections.emptySet());
    }

    public static Map<String, String> computeIdealMapping(List<String> preferenceList, StateModelDefinition stateModelDef, Set<String> liveInstanceSet, Set<String> disabledInstancesForPartition) {
        HashMap<String, String> idealStateMap = new HashMap<String, String>();
        if (preferenceList == null) {
            return idealStateMap;
        }
        for (String instance : preferenceList) {
            if (!disabledInstancesForPartition.contains(instance) || !liveInstanceSet.contains(instance)) continue;
            idealStateMap.put(instance, stateModelDef.getInitialState());
        }
        HashSet<String> liveAndEnabledInstances = new HashSet<String>(liveInstanceSet);
        liveAndEnabledInstances.removeAll(disabledInstancesForPartition);
        List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
        HashSet<String> assigned = new HashSet<String>();
        block1: for (String state : statesPriorityList) {
            int stateCount = AbstractRebalancer.getStateCount(state, stateModelDef, liveAndEnabledInstances.size(), preferenceList.size());
            for (String instance : preferenceList) {
                if (stateCount <= 0) continue block1;
                if (assigned.contains(instance) || !liveAndEnabledInstances.contains(instance)) continue;
                idealStateMap.put(instance, state);
                assigned.add(instance);
                --stateCount;
            }
        }
        return idealStateMap;
    }

    public static boolean removeMessageFromZK(HelixDataAccessor accessor, Message msg, String instanceName) {
        try {
            return accessor.removeProperty(msg.getKey(accessor.keyBuilder(), instanceName));
        }
        catch (Exception e) {
            LOG.error("Caught exception while removing message {}.", (Object)msg, (Object)e);
            return false;
        }
    }

    public static int getSystemPropertyAsInt(String propertyKey, int propertyDefaultValue) {
        String valueString = System.getProperty(propertyKey, "" + propertyDefaultValue);
        try {
            int value = Integer.parseInt(valueString);
            if (value > 0) {
                return value;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Exception while parsing property: " + propertyKey + ", string: " + valueString + ", using default value: " + propertyDefaultValue);
        }
        return propertyDefaultValue;
    }

    public static long getSystemPropertyAsLong(String propertyKey, long propertyDefaultValue) {
        String valueString = System.getProperty(propertyKey, "" + propertyDefaultValue);
        try {
            long value = Long.parseLong(valueString);
            if (value > 0L) {
                return value;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Exception while parsing property: " + propertyKey + ", string: " + valueString + ", using default value: " + propertyDefaultValue);
        }
        return propertyDefaultValue;
    }

    public static InstanceConfig composeInstanceConfig(String instanceName) {
        InstanceConfig instanceConfig = new InstanceConfig(instanceName);
        String hostName = instanceName;
        String port = "";
        int lastPos = instanceName.lastIndexOf("_");
        if (lastPos > 0) {
            hostName = instanceName.substring(0, lastPos);
            port = instanceName.substring(lastPos + 1);
        }
        instanceConfig.setHostName(hostName);
        instanceConfig.setPort(port);
        instanceConfig.setInstanceEnabled(true);
        return instanceConfig;
    }

    public static boolean inManagementMode(PauseSignal pauseSignal, Map<String, LiveInstance> liveInstanceMap, Set<String> enabledLiveInstances, Map<String, Collection<Message>> instancesMessages) {
        return pauseSignal != null || enabledLiveInstances.stream().anyMatch(instance -> HelixUtil.isInstanceInManagementMode(instance, liveInstanceMap, instancesMessages));
    }

    private static boolean isInstanceInManagementMode(String instance, Map<String, LiveInstance> liveInstanceMap, Map<String, Collection<Message>> instancesMessages) {
        return LiveInstance.LiveInstanceStatus.FROZEN.equals((Object)liveInstanceMap.get(instance).getStatus()) || ((Collection)instancesMessages.getOrDefault(instance, Collections.emptyList())).stream().anyMatch(Message::isParticipantStatusChangeType);
    }

    public static List<String> sortAndFlattenZoneMapping(Map<String, Set<String>> zoneMapping) {
        return zoneMapping.entrySet().stream().sorted(Map.Entry.comparingByKey()).flatMap(entry -> ((Set)entry.getValue()).stream().sorted()).collect(Collectors.toList());
    }
}

