/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MaterializationsRebuildLockHandler;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializationsRebuildLockCleanerTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializationsRebuildLockCleanerTask.class);
    private Configuration conf;

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.TXN_TIMEOUT, unit) / 2L;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void run() {
        long removedCnt = MaterializationsRebuildLockHandler.get().cleanupResourceLocks(MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.TXN_TIMEOUT, TimeUnit.MILLISECONDS));
        if (removedCnt > 0L && LOG.isDebugEnabled()) {
            LOG.info("Number of materialization locks deleted: " + removedCnt);
        }
    }
}

