/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.core;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.Node;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.closure.CatchUpClosure;
import org.apache.ignite.raft.jraft.core.NodeImpl;
import org.apache.ignite.raft.jraft.core.NodeMetrics;
import org.apache.ignite.raft.jraft.core.Scheduler;
import org.apache.ignite.raft.jraft.entity.EntryMetaBuilder;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.error.RaftException;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.option.ReplicatorOptions;
import org.apache.ignite.raft.jraft.rpc.AppendEntriesRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftClientService;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.RpcResponseClosure;
import org.apache.ignite.raft.jraft.rpc.RpcResponseClosureAdapter;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite.raft.jraft.util.ByteBufferCollector;
import org.apache.ignite.raft.jraft.util.ByteString;
import org.apache.ignite.raft.jraft.util.OnlyForTest;
import org.apache.ignite.raft.jraft.util.RecyclableByteBufferList;
import org.apache.ignite.raft.jraft.util.RecycleUtil;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.ThreadId;
import org.apache.ignite.raft.jraft.util.Utils;
import org.apache.ignite.raft.jraft.util.internal.ThrowUtil;

public class Replicator
implements ThreadId.OnError {
    private static final IgniteLogger LOG = Loggers.forClass(Replicator.class);
    private final RaftClientService rpcService;
    private volatile long nextIndex;
    private int consecutiveErrorTimes = 0;
    private boolean hasSucceeded;
    private long timeoutNowIndex;
    private volatile long lastRpcSendTimestamp;
    private volatile long heartbeatCounter = 0L;
    private volatile long appendEntriesCounter = 0L;
    private volatile long installSnapshotCounter = 0L;
    protected Stat statInfo = new Stat();
    private ScheduledFuture<?> blockTimer;
    private Inflight rpcInFly;
    private Future<Message> heartbeatInFly;
    private Future<Message> timeoutNowInFly;
    private final ArrayDeque<Inflight> inflights = new ArrayDeque();
    private long waitId = -1L;
    protected ThreadId id;
    private final ReplicatorOptions options;
    private final RaftOptions raftOptions;
    private ScheduledFuture<?> heartbeatTimer;
    private volatile SnapshotReader reader;
    private CatchUpClosure catchUpClosure;
    private final Scheduler timerManager;
    private final NodeMetrics nodeMetrics;
    private volatile State state;
    private int reqSeq = 0;
    private int requiredNextSeq = 0;
    private int version = 0;
    private final PriorityQueue<RpcResponse> pendingResponses = new PriorityQueue(50);

    private int getAndIncrementReqSeq() {
        int prev = this.reqSeq++;
        if (this.reqSeq < 0) {
            this.reqSeq = 0;
        }
        return prev;
    }

    private int getAndIncrementRequiredNextSeq() {
        int prev = this.requiredNextSeq++;
        if (this.requiredNextSeq < 0) {
            this.requiredNextSeq = 0;
        }
        return prev;
    }

    public Replicator(ReplicatorOptions replicatorOptions, RaftOptions raftOptions) {
        this.options = replicatorOptions;
        this.nodeMetrics = this.options.getNode().getNodeMetrics();
        this.nextIndex = this.options.getLogManager().getLastLogIndex() + 1L;
        this.timerManager = replicatorOptions.getTimerManager();
        this.raftOptions = raftOptions;
        this.rpcService = replicatorOptions.getRaftRpcService();
    }

    private static void notifyReplicatorStatusListener(Replicator replicator, ReplicatorEvent event, Status status) {
        ReplicatorOptions replicatorOpts = Requires.requireNonNull(replicator.getOpts(), "replicatorOptions");
        Node node = Requires.requireNonNull(replicatorOpts.getNode(), "node");
        PeerId peer = Requires.requireNonNull(replicatorOpts.getPeerId(), "peer");
        List<ReplicatorStateListener> listenerList = node.getReplicatorStateListeners();
        for (int i = 0; i < listenerList.size(); ++i) {
            ReplicatorStateListener listener = listenerList.get(i);
            if (listener == null) continue;
            try {
                switch (event) {
                    case CREATED: {
                        Utils.runInThread(replicatorOpts.getCommonExecutor(), () -> listener.onCreated(peer));
                        break;
                    }
                    case ERROR: {
                        Utils.runInThread(replicatorOpts.getCommonExecutor(), () -> listener.onError(peer, status));
                        break;
                    }
                    case DESTROYED: {
                        Utils.runInThread(replicatorOpts.getCommonExecutor(), () -> listener.onDestroyed(peer));
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                LOG.error("Fail to notify ReplicatorStatusListener, listener={}, event={}.", new Object[]{listener, event});
            }
        }
    }

    private static void notifyReplicatorStatusListener(Replicator replicator, ReplicatorEvent event) {
        Replicator.notifyReplicatorStatusListener(replicator, event, null);
    }

    @OnlyForTest
    ArrayDeque<Inflight> getInflights() {
        return this.inflights;
    }

    @OnlyForTest
    State getState() {
        return this.state;
    }

    @OnlyForTest
    void setState(State state) {
        this.state = state;
    }

    @OnlyForTest
    int getReqSeq() {
        return this.reqSeq;
    }

    @OnlyForTest
    int getRequiredNextSeq() {
        return this.requiredNextSeq;
    }

    @OnlyForTest
    int getVersion() {
        return this.version;
    }

    @OnlyForTest
    public PriorityQueue<RpcResponse> getPendingResponses() {
        return this.pendingResponses;
    }

    @OnlyForTest
    long getWaitId() {
        return this.waitId;
    }

    @OnlyForTest
    ScheduledFuture<?> getBlockTimer() {
        return this.blockTimer;
    }

    @OnlyForTest
    long getTimeoutNowIndex() {
        return this.timeoutNowIndex;
    }

    @OnlyForTest
    ReplicatorOptions getOpts() {
        return this.options;
    }

    @OnlyForTest
    long getRealNextIndex() {
        return this.nextIndex;
    }

    @OnlyForTest
    Future<Message> getRpcInFly() {
        if (this.rpcInFly == null) {
            return null;
        }
        return this.rpcInFly.rpcFuture;
    }

    @OnlyForTest
    Future<Message> getHeartbeatInFly() {
        return this.heartbeatInFly;
    }

    @OnlyForTest
    ScheduledFuture<?> getHeartbeatTimer() {
        return this.heartbeatTimer;
    }

    @OnlyForTest
    void setHasSucceeded() {
        this.hasSucceeded = true;
    }

    @OnlyForTest
    Future<Message> getTimeoutNowInFly() {
        return this.timeoutNowInFly;
    }

    private void addInflight(RequestType reqType, long startIndex, int count, int size, int seq, Future<Message> rpcInfly) {
        this.rpcInFly = new Inflight(reqType, startIndex, count, size, seq, rpcInfly);
        this.inflights.add(this.rpcInFly);
        this.nodeMetrics.recordSize("replicate-inflights-count", this.inflights.size());
    }

    long getNextSendIndex() {
        if (this.inflights.isEmpty()) {
            return this.nextIndex;
        }
        if (this.inflights.size() > this.raftOptions.getMaxReplicatorInflightMsgs()) {
            return -1L;
        }
        if (this.rpcInFly != null && this.rpcInFly.isSendingLogEntries()) {
            return this.rpcInFly.startIndex + (long)this.rpcInFly.count;
        }
        return -1L;
    }

    private Inflight pollInflight() {
        return this.inflights.poll();
    }

    private void startHeartbeatTimer(long startMs) {
        long dueTime = startMs + (long)this.options.getDynamicHeartBeatTimeoutMs();
        try {
            this.heartbeatTimer = this.timerManager.schedule(() -> Replicator.onTimeout(this.id), dueTime - Utils.nowMs(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOG.error("Fail to schedule heartbeat timer", (Throwable)e);
            Replicator.onTimeout(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installSnapshot() {
        if (this.state == State.Snapshot) {
            LOG.warn("Replicator {} is installing snapshot, ignore the new request.", new Object[]{this.options.getPeerId()});
            this.id.unlock();
            return;
        }
        boolean doUnlock = true;
        try {
            Requires.requireTrue(this.reader == null, "Replicator %s already has a snapshot reader, current state is %s", new Object[]{this.options.getPeerId(), this.state});
            this.reader = this.options.getSnapshotStorage().open();
            if (this.reader == null) {
                NodeImpl node = this.options.getNode();
                RaftException error = new RaftException(EnumOutter.ErrorType.ERROR_TYPE_SNAPSHOT);
                error.setStatus(new Status(RaftError.EIO, "Fail to open snapshot", new Object[0]));
                this.id.unlock();
                doUnlock = false;
                node.onError(error);
                return;
            }
            String uri = this.reader.generateURIForCopy();
            if (uri == null) {
                NodeImpl node = this.options.getNode();
                RaftException error = new RaftException(EnumOutter.ErrorType.ERROR_TYPE_SNAPSHOT);
                error.setStatus(new Status(RaftError.EIO, "Fail to generate uri for snapshot reader", new Object[0]));
                this.releaseReader();
                this.id.unlock();
                doUnlock = false;
                node.onError(error);
                return;
            }
            RaftOutter.SnapshotMeta meta = this.reader.load();
            if (meta == null) {
                String snapshotPath = this.reader.getPath();
                NodeImpl node = this.options.getNode();
                RaftException error = new RaftException(EnumOutter.ErrorType.ERROR_TYPE_SNAPSHOT);
                error.setStatus(new Status(RaftError.EIO, "Fail to load meta from %s", snapshotPath));
                this.releaseReader();
                this.id.unlock();
                doUnlock = false;
                node.onError(error);
                return;
            }
            final RpcRequests.InstallSnapshotRequest request = this.raftOptions.getRaftMessagesFactory().installSnapshotRequest().term(this.options.getTerm()).groupId(this.options.getGroupId()).serverId(this.options.getServerId().toString()).peerId(this.options.getPeerId().toString()).meta(meta).uri(uri).build();
            this.statInfo.runningState = RunningState.INSTALLING_SNAPSHOT;
            this.statInfo.lastLogIncluded = meta.lastIncludedIndex();
            this.statInfo.lastTermIncluded = meta.lastIncludedTerm();
            this.state = State.Snapshot;
            ++this.installSnapshotCounter;
            final long monotonicSendTimeMs = Utils.monotonicMs();
            final int stateVersion = this.version;
            final int seq = this.getAndIncrementReqSeq();
            Future<Message> rpcFuture = this.rpcService.installSnapshot(this.options.getPeerId().getEndpoint(), request, (RpcResponseClosure<RpcRequests.InstallSnapshotResponse>)new RpcResponseClosureAdapter<RpcRequests.InstallSnapshotResponse>(){

                @Override
                public void run(Status status) {
                    Replicator.onRpcReturned(Replicator.this.id, RequestType.Snapshot, status, request, this.getResponse(), seq, stateVersion, monotonicSendTimeMs);
                }
            });
            this.addInflight(RequestType.Snapshot, this.nextIndex, 0, 0, seq, rpcFuture);
        }
        finally {
            if (doUnlock) {
                this.id.unlock();
            }
        }
    }

    static boolean onInstallSnapshotReturned(ThreadId id, Replicator r, Status status, RpcRequests.InstallSnapshotRequest request, RpcRequests.InstallSnapshotResponse response) {
        boolean success = true;
        r.releaseReader();
        StringBuilder sb = new StringBuilder("Node ").append(r.options.getGroupId()).append(":").append(r.options.getServerId()).append(" received InstallSnapshotResponse from ").append(r.options.getPeerId()).append(" lastIncludedIndex=").append(request.meta().lastIncludedIndex()).append(" lastIncludedTerm=").append(request.meta().lastIncludedTerm());
        if (!status.isOk()) {
            sb.append(" error:").append(status);
            LOG.info(sb.toString(), new Object[0]);
            Replicator.notifyReplicatorStatusListener(r, ReplicatorEvent.ERROR, status);
            if (++r.consecutiveErrorTimes % 10 == 0) {
                LOG.warn("Fail to install snapshot at peer={}, error={}", new Object[]{r.options.getPeerId(), status});
            }
            success = false;
        } else if (!response.success()) {
            sb.append(" success=false");
            LOG.info(sb.toString(), new Object[0]);
            success = false;
        } else {
            r.nextIndex = request.meta().lastIncludedIndex() + 1L;
            sb.append(" success=true");
            LOG.info(sb.toString(), new Object[0]);
        }
        if (!success) {
            r.resetInflights();
            r.state = State.Probe;
            r.block(Utils.nowMs(), status.getCode());
            return false;
        }
        r.hasSucceeded = true;
        r.notifyOnCaughtUp(RaftError.SUCCESS.getNumber(), false);
        if (r.timeoutNowIndex > 0L && r.timeoutNowIndex < r.nextIndex) {
            r.sendTimeoutNow(false, false);
        }
        r.state = State.Replicate;
        return true;
    }

    private void sendEmptyEntries(boolean isHeartbeat) {
        this.sendEmptyEntries(isHeartbeat, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEmptyEntries(boolean isHeartbeat, RpcResponseClosure<RpcRequests.AppendEntriesResponse> heartBeatClosure) {
        AppendEntriesRequestBuilder rb = this.raftOptions.getRaftMessagesFactory().appendEntriesRequest();
        rb.timestamp(this.options.getNode().clockNow());
        if (!this.fillCommonFields(rb, this.nextIndex - 1L, isHeartbeat)) {
            this.installSnapshot();
            if (isHeartbeat && heartBeatClosure != null) {
                Utils.runClosureInThread(this.options.getCommonExecutor(), heartBeatClosure, new Status(RaftError.EAGAIN, "Fail to send heartbeat to peer %s", this.options.getPeerId()));
            }
            return;
        }
        try {
            RpcRequests.AppendEntriesRequest request;
            final long monotonicSendTimeMs = Utils.monotonicMs();
            if (isHeartbeat) {
                request = rb.build();
                ++this.heartbeatCounter;
                RpcResponseClosureAdapter<RpcRequests.AppendEntriesResponse> heartbeatDone = heartBeatClosure != null ? heartBeatClosure : new RpcResponseClosureAdapter<RpcRequests.AppendEntriesResponse>(){

                    @Override
                    public void run(Status status) {
                        Replicator.onHeartbeatReturned(Replicator.this.id, status, request, (RpcRequests.AppendEntriesResponse)this.getResponse(), monotonicSendTimeMs);
                    }
                };
                this.heartbeatInFly = this.rpcService.appendEntries(this.options.getPeerId().getEndpoint(), request, this.options.getElectionTimeoutMs() / 2, (RpcResponseClosure<RpcRequests.AppendEntriesResponse>)heartbeatDone);
            } else {
                rb.data(ByteString.EMPTY);
                request = rb.build();
                this.statInfo.runningState = RunningState.APPENDING_ENTRIES;
                this.statInfo.firstLogIndex = this.nextIndex;
                this.statInfo.lastLogIndex = this.nextIndex - 1L;
                ++this.appendEntriesCounter;
                this.state = State.Probe;
                final int stateVersion = this.version;
                final int seq = this.getAndIncrementReqSeq();
                Future<Message> rpcFuture = this.rpcService.appendEntries(this.options.getPeerId().getEndpoint(), request, -1, (RpcResponseClosure<RpcRequests.AppendEntriesResponse>)new RpcResponseClosureAdapter<RpcRequests.AppendEntriesResponse>(){

                    @Override
                    public void run(Status status) {
                        Replicator.onRpcReturned(Replicator.this.id, RequestType.AppendEntries, status, request, this.getResponse(), seq, stateVersion, monotonicSendTimeMs);
                    }
                });
                this.addInflight(RequestType.AppendEntries, this.nextIndex, 0, 0, seq, rpcFuture);
            }
            LOG.debug("Node {} send HeartbeatRequest to {} term {} lastCommittedIndex {}", new Object[]{this.options.getNode().getNodeId(), this.options.getPeerId(), this.options.getTerm(), request.committedIndex()});
        }
        finally {
            this.id.unlock();
        }
    }

    boolean prepareEntry(long nextSendingIndex, int offset, EntryMetaBuilder emb, RecyclableByteBufferList dateBuffer) {
        if (dateBuffer.getCapacity() >= this.raftOptions.getMaxBodySize()) {
            return false;
        }
        long logIndex = nextSendingIndex + (long)offset;
        LogEntry entry = this.options.getLogManager().getEntry(logIndex);
        if (entry == null) {
            return false;
        }
        emb.term(entry.getId().getTerm());
        if (entry.hasChecksum()) {
            emb.checksum(entry.getChecksum());
        }
        emb.type(entry.getType());
        if (entry.getPeers() != null) {
            Requires.requireTrue(!entry.getPeers().isEmpty(), "Empty peers at logIndex=%d", logIndex);
            this.fillMetaPeers(emb, entry);
        } else {
            Requires.requireTrue(entry.getType() != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION, "Empty peers but is ENTRY_TYPE_CONFIGURATION type at logIndex=%d", logIndex);
        }
        int remaining = entry.getData() != null ? entry.getData().remaining() : 0;
        emb.dataLen(remaining);
        if (entry.getData() != null) {
            dateBuffer.add(entry.getData().slice());
        }
        return true;
    }

    private void fillMetaPeers(EntryMetaBuilder emb, LogEntry entry) {
        emb.peersList(entry.getPeers().stream().map(Object::toString).collect(Collectors.toList()));
        if (entry.getOldPeers() != null) {
            emb.oldPeersList(entry.getOldPeers().stream().map(Object::toString).collect(Collectors.toList()));
        }
        if (entry.getLearners() != null) {
            emb.learnersList(entry.getLearners().stream().map(Object::toString).collect(Collectors.toList()));
        }
        if (entry.getOldLearners() != null) {
            emb.oldLearnersList(entry.getOldLearners().stream().map(Object::toString).collect(Collectors.toList()));
        }
    }

    public static ThreadId start(ReplicatorOptions opts, RaftOptions raftOptions) {
        if (opts.getLogManager() == null || opts.getBallotBox() == null || opts.getNode() == null) {
            throw new IllegalArgumentException("Invalid ReplicatorOptions.");
        }
        Replicator r = new Replicator(opts, raftOptions);
        if (!r.rpcService.connect(opts.getPeerId().getEndpoint())) {
            LOG.error("Fail to init sending channel to {}.", new Object[]{opts.getPeerId()});
            return null;
        }
        MetricRegistry metricRegistry = opts.getNode().getNodeMetrics().getMetricRegistry();
        if (metricRegistry != null) {
            try {
                String replicatorMetricName = Replicator.getReplicatorMetricName(opts);
                if (!metricRegistry.getNames().contains(replicatorMetricName)) {
                    metricRegistry.register(replicatorMetricName, (Metric)new ReplicatorMetricSet(opts, r));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        r.id = new ThreadId(r, r);
        r.id.lock();
        Replicator.notifyReplicatorStatusListener(r, ReplicatorEvent.CREATED);
        LOG.info("Replicator={}@{} is started", new Object[]{r.id, r.options.getPeerId()});
        r.catchUpClosure = null;
        r.lastRpcSendTimestamp = Utils.monotonicMs();
        r.startHeartbeatTimer(Utils.nowMs());
        r.sendEmptyEntries(false);
        return r.id;
    }

    private static String getReplicatorMetricName(ReplicatorOptions opts) {
        return "replicator-" + opts.getNode().getGroupId() + "/" + opts.getPeerId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForCaughtUp(ThreadId id, long maxMargin, long dueTime, CatchUpClosure done, ExecutorService executor) {
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            Utils.runClosureInThread(executor, done, new Status(RaftError.EINVAL, "No such replicator", new Object[0]));
            return;
        }
        try {
            if (r.catchUpClosure != null) {
                LOG.error("Previous wait_for_caught_up is not over", new Object[0]);
                Utils.runClosureInThread(executor, done, new Status(RaftError.EINVAL, "Duplicated call", new Object[0]));
                return;
            }
            done.setMaxMargin(maxMargin);
            if (dueTime > 0L) {
                done.setTimer(r.timerManager.schedule(() -> Replicator.onCatchUpTimedOut(id), dueTime - Utils.nowMs(), TimeUnit.MILLISECONDS));
            }
            r.catchUpClosure = done;
        }
        finally {
            id.unlock();
        }
    }

    public String toString() {
        return "Replicator [state=" + this.state + ", statInfo=" + this.statInfo + ", peerId=" + this.options.getPeerId() + ", type=" + this.options.getReplicatorType() + "]";
    }

    static void onBlockTimeoutInNewThread(ThreadId id) {
        if (id != null) {
            Replicator.continueSending(id, RaftError.ETIMEDOUT.getNumber());
        }
    }

    static void unBlockAndSendNow(ThreadId id) {
        if (id == null) {
            return;
        }
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            return;
        }
        try {
            if (r.blockTimer != null && r.blockTimer.cancel(true)) {
                Replicator.onBlockTimeout(id, r.options.getCommonExecutor());
            }
        }
        finally {
            id.unlock();
        }
    }

    static boolean continueSending(ThreadId id, int errCode) {
        if (id == null) {
            return true;
        }
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            return false;
        }
        r.waitId = -1L;
        if (errCode == RaftError.ETIMEDOUT.getNumber()) {
            r.blockTimer = null;
            r.sendEmptyEntries(false);
        } else if (errCode != RaftError.ESTOP.getNumber()) {
            r.sendEntries();
        } else {
            LOG.warn("Replicator {} stops sending entries.", new Object[]{id});
            id.unlock();
        }
        return true;
    }

    static void onBlockTimeout(ThreadId arg, ExecutorService executor) {
        Utils.runInThread(executor, () -> Replicator.onBlockTimeoutInNewThread(arg));
    }

    void block(long startTimeMs, int errorCode) {
        if (this.blockTimer != null) {
            this.id.unlock();
            return;
        }
        long dueTime = startTimeMs + (long)this.options.getDynamicHeartBeatTimeoutMs();
        try {
            LOG.debug("Blocking {} for {} ms", new Object[]{this.options.getPeerId(), this.options.getDynamicHeartBeatTimeoutMs()});
            this.blockTimer = this.timerManager.schedule(() -> Replicator.onBlockTimeout(this.id, this.options.getCommonExecutor()), dueTime - Utils.nowMs(), TimeUnit.MILLISECONDS);
            this.statInfo.runningState = RunningState.BLOCKING;
            this.id.unlock();
        }
        catch (Exception e) {
            this.blockTimer = null;
            LOG.error("Fail to add timer", (Throwable)e);
            this.sendEmptyEntries(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(ThreadId id, Object data, int errorCode) {
        Replicator r = (Replicator)data;
        if (errorCode == RaftError.ESTOP.getNumber()) {
            try {
                for (Inflight inflight : r.inflights) {
                    if (inflight == r.rpcInFly) continue;
                    inflight.rpcFuture.cancel(true);
                }
                if (r.rpcInFly != null) {
                    r.rpcInFly.rpcFuture.cancel(true);
                    r.rpcInFly = null;
                }
                if (r.heartbeatInFly != null) {
                    r.heartbeatInFly.cancel(true);
                    r.heartbeatInFly = null;
                }
                if (r.timeoutNowInFly != null) {
                    r.timeoutNowInFly.cancel(true);
                    r.timeoutNowInFly = null;
                }
                if (r.heartbeatTimer != null) {
                    r.heartbeatTimer.cancel(true);
                    r.heartbeatTimer = null;
                }
                if (r.blockTimer != null) {
                    r.blockTimer.cancel(true);
                    r.blockTimer = null;
                }
                if (r.waitId >= 0L) {
                    r.options.getLogManager().removeWaiter(r.waitId);
                }
                r.notifyOnCaughtUp(errorCode, true);
            }
            finally {
                r.destroy();
            }
        } else if (errorCode == RaftError.ETIMEDOUT.getNumber()) {
            id.unlock();
            Utils.runInThread(this.options.getCommonExecutor(), () -> Replicator.sendHeartbeat(id));
        } else {
            id.unlock();
            Requires.requireTrue(false, "Unknown error code for replicator: " + errorCode);
        }
    }

    private static void onCatchUpTimedOut(ThreadId id) {
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            return;
        }
        try {
            r.notifyOnCaughtUp(RaftError.ETIMEDOUT.getNumber(), false);
        }
        finally {
            id.unlock();
        }
    }

    private void notifyOnCaughtUp(int code, boolean beforeDestroy) {
        if (this.catchUpClosure == null) {
            return;
        }
        if (code != RaftError.ETIMEDOUT.getNumber()) {
            if (this.nextIndex - 1L + this.catchUpClosure.getMaxMargin() < this.options.getLogManager().getLastLogIndex()) {
                LOG.debug("Catch up for peer={} in progress, current index={} (leader log last index={}, catch up margin={})", new Object[]{this.getOpts().getPeerId(), this.nextIndex - 1L, this.options.getLogManager().getLastLogIndex(), this.catchUpClosure.getMaxMargin()});
                return;
            }
            if (this.catchUpClosure.isErrorWasSet()) {
                return;
            }
            this.catchUpClosure.setErrorWasSet(true);
            if (code != RaftError.SUCCESS.getNumber()) {
                this.catchUpClosure.getStatus().setError(code, RaftError.describeCode(code), new Object[0]);
            }
            if (this.catchUpClosure.hasTimer() && !beforeDestroy && !this.catchUpClosure.getTimer().cancel(false)) {
                return;
            }
        } else if (!this.catchUpClosure.isErrorWasSet()) {
            this.catchUpClosure.getStatus().setError(code, RaftError.describeCode(code), new Object[0]);
        }
        CatchUpClosure savedClosure = this.catchUpClosure;
        this.catchUpClosure = null;
        Utils.runClosureInThread(this.options.getCommonExecutor(), savedClosure, savedClosure.getStatus());
    }

    private static void onTimeout(ThreadId id) {
        if (id != null) {
            id.setError(RaftError.ETIMEDOUT.getNumber());
        } else {
            LOG.warn("Replicator id is null when timeout, maybe it's destroyed.", new Object[0]);
        }
    }

    void destroy() {
        ThreadId savedId = this.id;
        LOG.info("Replicator {} is going to quit", new Object[]{savedId});
        this.releaseReader();
        if (this.nodeMetrics.isEnabled()) {
            this.nodeMetrics.getMetricRegistry().removeMatching(MetricFilter.startsWith((String)Replicator.getReplicatorMetricName(this.options)));
        }
        this.state = State.Destroyed;
        Replicator.notifyReplicatorStatusListener((Replicator)savedId.getData(), ReplicatorEvent.DESTROYED);
        savedId.unlockAndDestroy();
    }

    private void releaseReader() {
        if (this.reader != null) {
            Utils.closeQuietly(this.reader);
            this.reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onHeartbeatReturned(ThreadId id, Status status, RpcRequests.AppendEntriesRequest request, RpcRequests.AppendEntriesResponse response, long rpcSendTime) {
        if (id == null) {
            return;
        }
        long startTimeMs = Utils.nowMs();
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            return;
        }
        if (response != null && response.timestamp() != null) {
            r.options.getNode().clockUpdate(response.timestamp());
        }
        boolean doUnlock = true;
        try {
            boolean isLogDebugEnabled = LOG.isDebugEnabled();
            StringBuilder sb = null;
            if (isLogDebugEnabled) {
                sb = new StringBuilder("Node ").append(r.options.getGroupId()).append(':').append(r.options.getServerId()).append(" received HeartbeatResponse from ").append(r.options.getPeerId()).append(" prevLogIndex=").append(request.prevLogIndex()).append(" prevLogTerm=").append(request.prevLogTerm());
            }
            if (!status.isOk()) {
                if (isLogDebugEnabled) {
                    sb.append(" fail, sleep, status=").append(status);
                    LOG.debug(sb.toString(), new Object[0]);
                }
                r.state = State.Probe;
                Replicator.notifyReplicatorStatusListener(r, ReplicatorEvent.ERROR, status);
                if (++r.consecutiveErrorTimes % 10 == 0) {
                    LOG.warn("Fail to issue RPC to {}, consecutiveErrorTimes={}, error={}", new Object[]{r.options.getPeerId(), r.consecutiveErrorTimes, status});
                }
                r.startHeartbeatTimer(startTimeMs);
                return;
            }
            r.consecutiveErrorTimes = 0;
            if (response.term() > r.options.getTerm()) {
                if (isLogDebugEnabled) {
                    sb.append(" fail, greater term ").append(response.term()).append(" expect term ").append(r.options.getTerm());
                    LOG.debug(sb.toString(), new Object[0]);
                }
                NodeImpl node = r.options.getNode();
                r.notifyOnCaughtUp(RaftError.EPERM.getNumber(), true);
                r.destroy();
                node.increaseTermTo(response.term(), new Status(RaftError.EHIGHERTERMRESPONSE, "Leader receives higher term heartbeat_response from peer:%s", r.options.getPeerId()));
                return;
            }
            if (!response.success() && response.lastLogIndex() != 0L) {
                if (isLogDebugEnabled) {
                    sb.append(" fail, response term ").append(response.term()).append(" lastLogIndex ").append(response.lastLogIndex());
                    LOG.debug(sb.toString(), new Object[0]);
                }
                LOG.warn("Heartbeat to peer {} failure, try to send a probe request.", new Object[]{r.options.getPeerId()});
                doUnlock = false;
                r.sendEmptyEntries(false);
                r.startHeartbeatTimer(startTimeMs);
                return;
            }
            if (isLogDebugEnabled) {
                LOG.debug(sb.toString(), new Object[0]);
            }
            if (rpcSendTime > r.lastRpcSendTimestamp) {
                r.lastRpcSendTimestamp = rpcSendTime;
            }
            r.startHeartbeatTimer(startTimeMs);
        }
        finally {
            if (doUnlock) {
                id.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static void onRpcReturned(ThreadId id, RequestType reqType, Status status, Message request, Message response, int seq, int stateVersion, long rpcSendTime) {
        if (id == null) {
            return;
        }
        startTimeMs = Utils.nowMs();
        r = (Replicator)id.lock();
        if (r == null) {
            return;
        }
        if (stateVersion != r.version) {
            Replicator.LOG.debug("Replicator {} ignored old version response {}, current version is {}, request is {}\n, and response is {}\n, status is {}.", new Object[]{r, stateVersion, r.version, request, response, status});
            id.unlock();
            return;
        }
        holdingQueue = r.pendingResponses;
        holdingQueue.add(new RpcResponse(reqType, seq, status, request, response, rpcSendTime));
        if (holdingQueue.size() > r.raftOptions.getMaxReplicatorInflightMsgs()) {
            Replicator.LOG.warn("Too many pending responses {} for replicator {}, maxReplicatorInflightMsgs={}", new Object[]{holdingQueue.size(), r.options.getPeerId(), r.raftOptions.getMaxReplicatorInflightMsgs()});
            r.resetInflights();
            r.state = State.Probe;
            r.sendEmptyEntries(false);
            return;
        }
        continueSendEntries = false;
        isLogDebugEnabled = Replicator.LOG.isDebugEnabled();
        sb = null;
        if (isLogDebugEnabled) {
            sb = new StringBuilder("Replicator ").append(r).append(" is processing RPC responses, ");
        }
        try {
            processed = 0;
lbl27:
            // 7 sources

            block12: while (!holdingQueue.isEmpty()) {
                queuedPipelinedResponse = holdingQueue.peek();
                if (queuedPipelinedResponse.seq != r.requiredNextSeq) {
                    if (processed > 0) {
                        if (isLogDebugEnabled) {
                            sb.append("has processed ").append(processed).append(" responses, ");
                        }
                        break;
                    }
                    continueSendEntries = false;
                    id.unlock();
                    return;
                }
                holdingQueue.remove();
                ++processed;
                inflight = r.pollInflight();
                if (inflight == null) {
                    if (!isLogDebugEnabled) continue;
                    sb.append("ignore response because request not found: ").append(queuedPipelinedResponse).append(",\n");
                    continue;
                }
                if (inflight.seq != queuedPipelinedResponse.seq) {
                    Replicator.LOG.warn("Replicator {} response sequence out of order, expect {}, but it is {}, reset state to try again.", new Object[]{r, inflight.seq, queuedPipelinedResponse.seq});
                    r.resetInflights();
                    r.state = State.Probe;
                    continueSendEntries = false;
                    r.block(Utils.nowMs(), RaftError.EREQUEST.getNumber());
                    return;
                }
                try {
                    switch (6.$SwitchMap$org$apache$ignite$raft$jraft$core$Replicator$RequestType[queuedPipelinedResponse.requestType.ordinal()]) {
                        case 1: {
                            continueSendEntries = Replicator.onAppendEntriesReturned(id, inflight, queuedPipelinedResponse.status, (RpcRequests.AppendEntriesRequest)queuedPipelinedResponse.request, (RpcRequests.AppendEntriesResponse)queuedPipelinedResponse.response, rpcSendTime, startTimeMs, r);
                            ** break;
                        }
                        case 2: {
                            continueSendEntries = Replicator.onInstallSnapshotReturned(id, r, queuedPipelinedResponse.status, (RpcRequests.InstallSnapshotRequest)queuedPipelinedResponse.request, (RpcRequests.InstallSnapshotResponse)queuedPipelinedResponse.response);
                            continue block12;
                        }
                        ** default:
lbl63:
                        // 1 sources

                        continue block12;
                    }
                }
                finally {
                    if (continueSendEntries) {
                        r.getAndIncrementRequiredNextSeq();
                        continue;
                    }
                    break;
                }
            }
        }
        finally {
            if (isLogDebugEnabled) {
                sb.append("after processed, continue to send entries: ").append(continueSendEntries);
                Replicator.LOG.debug(sb.toString(), new Object[0]);
            }
            if (continueSendEntries) {
                r.sendEntries();
            }
        }
    }

    void resetInflights() {
        int rs;
        ++this.version;
        this.inflights.clear();
        this.pendingResponses.clear();
        this.reqSeq = this.requiredNextSeq = (rs = Math.max(this.reqSeq, this.requiredNextSeq));
        this.releaseReader();
    }

    private static boolean onAppendEntriesReturned(ThreadId id, Inflight inflight, Status status, RpcRequests.AppendEntriesRequest request, RpcRequests.AppendEntriesResponse response, long rpcSendTime, long startTimeMs, Replicator r) {
        int entriesSize;
        if (inflight.startIndex != request.prevLogIndex() + 1L) {
            LOG.warn("Replicator {} received invalid AppendEntriesResponse, in-flight startIndex={}, request prevLogIndex={}, reset the replicator state and probe again.", new Object[]{r, inflight.startIndex, request.prevLogIndex()});
            r.resetInflights();
            r.state = State.Probe;
            r.sendEmptyEntries(false);
            return false;
        }
        if (request.entriesList() != null) {
            r.nodeMetrics.recordLatency("replicate-entries", Utils.monotonicMs() - rpcSendTime);
            r.nodeMetrics.recordSize("replicate-entries-count", request.entriesList().size());
            r.nodeMetrics.recordSize("replicate-entries-bytes", request.data() != null ? (long)request.data().size() : 0L);
        }
        boolean isLogDebugEnabled = LOG.isDebugEnabled();
        StringBuilder sb = null;
        if (isLogDebugEnabled) {
            sb = new StringBuilder("Node ").append(r.options.getGroupId()).append(':').append(r.options.getServerId()).append(" received AppendEntriesResponse from ").append(r.options.getPeerId()).append(" prevLogIndex=").append(request.prevLogIndex()).append(" prevLogTerm=").append(request.prevLogTerm()).append(" count=").append(Utils.size(request.entriesList()));
        }
        if (!status.isOk()) {
            if (isLogDebugEnabled) {
                sb.append(" fail, sleep, status=").append(status);
                LOG.debug(sb.toString(), new Object[0]);
            }
            Replicator.notifyReplicatorStatusListener(r, ReplicatorEvent.ERROR, status);
            if (++r.consecutiveErrorTimes % 10 == 0) {
                LOG.warn("Fail to issue RPC to {}, consecutiveErrorTimes={}, error={}", new Object[]{r.options.getPeerId(), r.consecutiveErrorTimes, status});
            }
            r.resetInflights();
            r.state = State.Probe;
            r.block(startTimeMs, status.getCode());
            return false;
        }
        r.consecutiveErrorTimes = 0;
        if (!response.success()) {
            if (response.term() > r.options.getTerm()) {
                if (isLogDebugEnabled) {
                    sb.append(" fail, greater term ").append(response.term()).append(" expect term ").append(r.options.getTerm());
                    LOG.debug(sb.toString(), new Object[0]);
                }
                NodeImpl node = r.options.getNode();
                r.notifyOnCaughtUp(RaftError.EPERM.getNumber(), true);
                r.destroy();
                node.increaseTermTo(response.term(), new Status(RaftError.EHIGHERTERMRESPONSE, "Leader receives higher term heartbeat_response from peer:%s", r.options.getPeerId()));
                return false;
            }
            if (isLogDebugEnabled) {
                sb.append(" fail, find nextIndex remote lastLogIndex ").append(response.lastLogIndex()).append(" local nextIndex ").append(r.nextIndex);
                LOG.debug(sb.toString(), new Object[0]);
            }
            if (rpcSendTime > r.lastRpcSendTimestamp) {
                r.lastRpcSendTimestamp = rpcSendTime;
            }
            r.resetInflights();
            if (response.lastLogIndex() + 1L < r.nextIndex) {
                LOG.debug("LastLogIndex at peer={} is {}", new Object[]{r.options.getPeerId(), response.lastLogIndex()});
                r.nextIndex = response.lastLogIndex() + 1L;
            } else if (r.nextIndex > 1L) {
                LOG.debug("logIndex={} dismatch", new Object[]{r.nextIndex});
                --r.nextIndex;
            } else {
                LOG.error("Peer={} declares that log at index=0 doesn't match, which is not supposed to happen", new Object[]{r.options.getPeerId()});
            }
            r.sendEmptyEntries(false);
            return false;
        }
        if (isLogDebugEnabled) {
            sb.append(", success");
            LOG.debug(sb.toString(), new Object[0]);
        }
        if (response.term() != r.options.getTerm()) {
            r.resetInflights();
            r.state = State.Probe;
            LOG.error("Fail, response term {} dismatch, expect term {}", new Object[]{response.term(), r.options.getTerm()});
            id.unlock();
            return false;
        }
        if (rpcSendTime > r.lastRpcSendTimestamp) {
            r.lastRpcSendTimestamp = rpcSendTime;
        }
        if ((entriesSize = Utils.size(request.entriesList())) > 0) {
            if (r.options.getReplicatorType().isFollower()) {
                r.options.getBallotBox().commitAt(r.nextIndex, r.nextIndex + (long)entriesSize - 1L, r.options.getPeerId());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Replicated logs in [{}, {}] to peer {}", new Object[]{r.nextIndex, r.nextIndex + (long)entriesSize - 1L, r.options.getPeerId()});
            }
        }
        r.state = State.Replicate;
        r.blockTimer = null;
        r.nextIndex += (long)entriesSize;
        r.hasSucceeded = true;
        r.notifyOnCaughtUp(RaftError.SUCCESS.getNumber(), false);
        if (r.timeoutNowIndex > 0L && r.timeoutNowIndex < r.nextIndex) {
            r.sendTimeoutNow(false, false);
        }
        return true;
    }

    private boolean fillCommonFields(AppendEntriesRequestBuilder rb, long prevLogIndex, boolean isHeartbeat) {
        long prevLogTerm = this.options.getLogManager().getTerm(prevLogIndex);
        if (prevLogTerm == 0L && prevLogIndex != 0L) {
            if (!isHeartbeat) {
                Requires.requireTrue(prevLogIndex < this.options.getLogManager().getFirstLogIndex());
                LOG.debug("logIndex={} was compacted", new Object[]{prevLogIndex});
                return false;
            }
            prevLogIndex = 0L;
        }
        rb.term(this.options.getTerm());
        rb.groupId(this.options.getGroupId());
        rb.serverId(this.options.getServerId().toString());
        rb.peerId(this.options.getPeerId().toString());
        rb.prevLogIndex(prevLogIndex);
        rb.prevLogTerm(prevLogTerm);
        rb.committedIndex(this.options.getBallotBox().getLastCommittedIndex());
        return true;
    }

    private void waitMoreEntries(long nextWaitIndex) {
        try {
            LOG.debug("Node {} waits more entries", new Object[]{this.options.getNode().getNodeId()});
            if (this.waitId >= 0L) {
                return;
            }
            this.waitId = this.options.getLogManager().wait(nextWaitIndex - 1L, (arg, errorCode) -> Replicator.continueSending((ThreadId)arg, errorCode), this.id);
            this.statInfo.runningState = RunningState.IDLE;
        }
        finally {
            this.id.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEntries() {
        boolean doUnlock = true;
        try {
            long nextSendingIndex;
            long prevSendIndex = -1L;
            while ((nextSendingIndex = this.getNextSendIndex()) > prevSendIndex) {
                if (this.sendEntries(nextSendingIndex)) {
                    prevSendIndex = nextSendingIndex;
                    continue;
                }
                doUnlock = false;
                break;
            }
        }
        finally {
            if (doUnlock) {
                this.id.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendEntries(long nextSendingIndex) {
        AppendEntriesRequestBuilder rb = this.raftOptions.getRaftMessagesFactory().appendEntriesRequest();
        if (!this.fillCommonFields(rb, nextSendingIndex - 1L, false)) {
            this.installSnapshot();
            return false;
        }
        ByteBufferCollector dataBuf = null;
        int maxEntriesSize = this.raftOptions.getMaxEntriesSize();
        RecyclableByteBufferList byteBufList = RecyclableByteBufferList.newInstance();
        try {
            EntryMetaBuilder emb;
            int i;
            ArrayList<RaftOutter.EntryMeta> entries = new ArrayList<RaftOutter.EntryMeta>();
            for (i = 0; i < maxEntriesSize && this.prepareEntry(nextSendingIndex, i, emb = this.raftOptions.getRaftMessagesFactory().entryMeta(), byteBufList); i += 1) {
                entries.add(emb.build());
            }
            rb.entriesList(entries);
            if (entries.isEmpty()) {
                if (nextSendingIndex < this.options.getLogManager().getFirstLogIndex()) {
                    this.installSnapshot();
                    i = 0;
                    return i != 0;
                }
                this.waitMoreEntries(nextSendingIndex);
                i = 0;
                return i != 0;
            }
            if (byteBufList.getCapacity() > 0) {
                dataBuf = ByteBufferCollector.allocateByRecyclers(byteBufList.getCapacity());
                for (ByteBuffer b : byteBufList) {
                    dataBuf.put(b);
                }
                ByteBuffer buf = dataBuf.getBuffer();
                buf.flip();
                rb.data(new ByteString(buf));
            }
        }
        finally {
            RecycleUtil.recycle(byteBufList);
        }
        rb.timestamp(this.options.getNode().clockNow());
        final RpcRequests.AppendEntriesRequest request = rb.build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node {} send AppendEntriesRequest to {} term {} lastCommittedIndex {} prevLogIndex {} prevLogTerm {} logIndex {} count {}", new Object[]{this.options.getNode().getNodeId(), this.options.getPeerId(), this.options.getTerm(), request.committedIndex(), request.prevLogIndex(), request.prevLogTerm(), nextSendingIndex, Utils.size(request.entriesList())});
        }
        this.statInfo.runningState = RunningState.APPENDING_ENTRIES;
        this.statInfo.firstLogIndex = request.prevLogIndex() + 1L;
        this.statInfo.lastLogIndex = request.prevLogIndex() + (long)Utils.size(request.entriesList());
        final ByteBufferCollector recyclable = dataBuf;
        final int v = this.version;
        final long monotonicSendTimeMs = Utils.monotonicMs();
        final int seq = this.getAndIncrementReqSeq();
        Future<Message> rpcFuture = null;
        try {
            rpcFuture = this.rpcService.appendEntries(this.options.getPeerId().getEndpoint(), request, -1, (RpcResponseClosure<RpcRequests.AppendEntriesResponse>)new RpcResponseClosureAdapter<RpcRequests.AppendEntriesResponse>(){

                @Override
                public void run(Status status) {
                    if (status.isOk()) {
                        RecycleUtil.recycle(recyclable);
                    }
                    Replicator.onRpcReturned(Replicator.this.id, RequestType.AppendEntries, status, request, this.getResponse(), seq, v, monotonicSendTimeMs);
                }
            });
        }
        catch (Throwable t) {
            RecycleUtil.recycle(recyclable);
            ThrowUtil.throwException(t);
        }
        this.addInflight(RequestType.AppendEntries, nextSendingIndex, Utils.size(request.entriesList()), request.data() == null ? 0 : request.data().size(), seq, rpcFuture);
        return true;
    }

    public static void sendHeartbeat(ThreadId id, RpcResponseClosure<RpcRequests.AppendEntriesResponse> closure, ExecutorService executor) {
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            Utils.runClosureInThread(executor, closure, new Status(RaftError.EHOSTDOWN, "Peer %s is not connected", id));
            return;
        }
        r.sendEmptyEntries(true, closure);
    }

    private static void sendHeartbeat(ThreadId id) {
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            return;
        }
        r.sendEmptyEntries(true);
    }

    private void sendTimeoutNow(boolean unlockId, boolean stopAfterFinish) {
        this.sendTimeoutNow(unlockId, stopAfterFinish, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTimeoutNow(boolean unlockId, boolean stopAfterFinish, int timeoutMs) {
        RpcRequests.TimeoutNowRequest req = this.raftOptions.getRaftMessagesFactory().timeoutNowRequest().term(this.options.getTerm()).groupId(this.options.getGroupId()).serverId(this.options.getServerId().toString()).peerId(this.options.getPeerId().toString()).build();
        try {
            if (!stopAfterFinish) {
                this.timeoutNowInFly = this.timeoutNow(req, false, timeoutMs);
                this.timeoutNowIndex = 0L;
            } else {
                this.timeoutNow(req, true, timeoutMs);
            }
        }
        finally {
            if (unlockId) {
                this.id.unlock();
            }
        }
    }

    private Future<Message> timeoutNow(final RpcRequests.TimeoutNowRequest request, final boolean stopAfterFinish, int timeoutMs) {
        return this.rpcService.timeoutNow(this.options.getPeerId().getEndpoint(), request, timeoutMs, (RpcResponseClosure<RpcRequests.TimeoutNowResponse>)new RpcResponseClosureAdapter<RpcRequests.TimeoutNowResponse>(){

            @Override
            public void run(Status status) {
                if (Replicator.this.id != null) {
                    Replicator.onTimeoutNowReturned(Replicator.this.id, status, request, (RpcRequests.TimeoutNowResponse)this.getResponse(), stopAfterFinish);
                }
            }
        });
    }

    static void onTimeoutNowReturned(ThreadId id, Status status, RpcRequests.TimeoutNowRequest request, RpcRequests.TimeoutNowResponse response, boolean stopAfterFinish) {
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            return;
        }
        boolean isLogDebugEnabled = LOG.isDebugEnabled();
        StringBuilder sb = null;
        if (isLogDebugEnabled) {
            sb = new StringBuilder("Node ").append(r.options.getGroupId()).append(":").append(r.options.getServerId()).append(" received TimeoutNowResponse from ").append(r.options.getPeerId());
        }
        if (!status.isOk()) {
            if (isLogDebugEnabled) {
                sb.append(" fail:").append(status);
                LOG.debug(sb.toString(), new Object[0]);
            }
            Replicator.notifyReplicatorStatusListener(r, ReplicatorEvent.ERROR, status);
            if (stopAfterFinish) {
                r.notifyOnCaughtUp(RaftError.ESTOP.getNumber(), true);
                r.destroy();
            } else {
                id.unlock();
            }
            return;
        }
        if (isLogDebugEnabled) {
            sb.append(response.success() ? " success" : " fail");
            LOG.debug(sb.toString(), new Object[0]);
        }
        if (response.term() > r.options.getTerm()) {
            NodeImpl node = r.options.getNode();
            r.notifyOnCaughtUp(RaftError.EPERM.getNumber(), true);
            r.destroy();
            node.increaseTermTo(response.term(), new Status(RaftError.EHIGHERTERMRESPONSE, "Leader receives higher term timeout_now_response from peer:%s", r.options.getPeerId()));
            return;
        }
        if (stopAfterFinish) {
            r.notifyOnCaughtUp(RaftError.ESTOP.getNumber(), true);
            r.destroy();
        } else {
            id.unlock();
        }
    }

    public static boolean stop(ThreadId id) {
        id.setError(RaftError.ESTOP.getNumber());
        return true;
    }

    public static boolean join(ThreadId id) {
        id.join();
        return true;
    }

    public static long getLastRpcSendTimestamp(ThreadId id) {
        Replicator r = (Replicator)id.getData();
        if (r == null) {
            return 0L;
        }
        return r.lastRpcSendTimestamp;
    }

    public static boolean transferLeadership(ThreadId id, long logIndex) {
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            return false;
        }
        return r.transferLeadership(logIndex);
    }

    private boolean transferLeadership(long logIndex) {
        if (this.hasSucceeded && this.nextIndex > logIndex) {
            this.sendTimeoutNow(true, false);
            return true;
        }
        this.timeoutNowIndex = logIndex;
        this.id.unlock();
        return true;
    }

    public static boolean stopTransferLeadership(ThreadId id) {
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            return false;
        }
        r.timeoutNowIndex = 0L;
        id.unlock();
        return true;
    }

    public static boolean sendTimeoutNowAndStop(ThreadId id, int timeoutMs) {
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            return false;
        }
        r.sendTimeoutNow(true, true, timeoutMs);
        return true;
    }

    public static long getNextIndex(ThreadId id) {
        Replicator r = (Replicator)id.lock();
        if (r == null) {
            return 0L;
        }
        long nextIdx = 0L;
        if (r.hasSucceeded) {
            nextIdx = r.nextIndex;
        }
        id.unlock();
        return nextIdx;
    }

    static class RpcResponse
    implements Comparable<RpcResponse> {
        final Status status;
        final Message request;
        final Message response;
        final long rpcSendTime;
        final int seq;
        final RequestType requestType;

        RpcResponse(RequestType reqType, int seq, Status status, Message request, Message response, long rpcSendTime) {
            this.requestType = reqType;
            this.seq = seq;
            this.status = status;
            this.request = request;
            this.response = response;
            this.rpcSendTime = rpcSendTime;
        }

        public String toString() {
            return "RpcResponse [status=" + this.status + ", request=" + this.request + ", response=" + this.response + ", rpcSendTime=" + this.rpcSendTime + ", seq=" + this.seq + ", requestType=" + this.requestType + "]";
        }

        @Override
        public int compareTo(RpcResponse o) {
            return Integer.compare(this.seq, o.seq);
        }
    }

    static class Inflight {
        final int count;
        final long startIndex;
        final int size;
        final Future<Message> rpcFuture;
        final RequestType requestType;
        final int seq;

        Inflight(RequestType requestType, long startIndex, int count, int size, int seq, Future<Message> rpcFuture) {
            this.seq = seq;
            this.requestType = requestType;
            this.count = count;
            this.startIndex = startIndex;
            this.size = size;
            this.rpcFuture = rpcFuture;
        }

        public String toString() {
            return "Inflight [count=" + this.count + ", startIndex=" + this.startIndex + ", size=" + this.size + ", rpcFuture=" + this.rpcFuture + ", requestType=" + this.requestType + ", seq=" + this.seq + "]";
        }

        boolean isSendingLogEntries() {
            return this.requestType == RequestType.AppendEntries && this.count > 0;
        }
    }

    static enum RequestType {
        Snapshot,
        AppendEntries;

    }

    static class Stat {
        RunningState runningState;
        long firstLogIndex;
        long lastLogIncluded;
        long lastLogIndex;
        long lastTermIncluded;

        Stat() {
        }

        public String toString() {
            return "<running=" + this.runningState + ", firstLogIndex=" + this.firstLogIndex + ", lastLogIncluded=" + this.lastLogIncluded + ", lastLogIndex=" + this.lastLogIndex + ", lastTermIncluded=" + this.lastTermIncluded + ">";
        }
    }

    public static interface ReplicatorStateListener {
        public void onCreated(PeerId var1);

        public void onError(PeerId var1, Status var2);

        public void onDestroyed(PeerId var1);
    }

    static enum ReplicatorEvent {
        CREATED,
        ERROR,
        DESTROYED;

    }

    static enum RunningState {
        IDLE,
        BLOCKING,
        APPENDING_ENTRIES,
        INSTALLING_SNAPSHOT;

    }

    private static final class ReplicatorMetricSet
    implements MetricSet {
        private final ReplicatorOptions opts;
        private final Replicator r;

        private ReplicatorMetricSet(ReplicatorOptions opts, Replicator r) {
            this.opts = opts;
            this.r = r;
        }

        public Map<String, Metric> getMetrics() {
            HashMap<String, Metric> gauges = new HashMap<String, Metric>();
            gauges.put("log-lags", (Metric)((Gauge)() -> this.opts.getLogManager().getLastLogIndex() - (this.r.nextIndex - 1L)));
            gauges.put("next-index", (Metric)((Gauge)() -> this.r.nextIndex));
            gauges.put("heartbeat-times", (Metric)((Gauge)() -> this.r.heartbeatCounter));
            gauges.put("install-snapshot-times", (Metric)((Gauge)() -> this.r.installSnapshotCounter));
            gauges.put("append-entries-times", (Metric)((Gauge)() -> this.r.appendEntriesCounter));
            return gauges;
        }
    }

    public static enum State {
        Probe,
        Snapshot,
        Replicate,
        Destroyed;

    }
}

