/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.hash;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.datapage.DataPageReader;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.storage.index.HashIndexDescriptor;
import org.apache.ignite.internal.storage.index.IndexDescriptor;
import org.apache.ignite.internal.storage.pagememory.index.InlineUtils;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexRow;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexRowKey;
import org.apache.ignite.internal.storage.pagememory.index.hash.io.HashIndexTreeInnerIo;
import org.apache.ignite.internal.storage.pagememory.index.hash.io.HashIndexTreeIo;
import org.apache.ignite.internal.storage.pagememory.index.hash.io.HashIndexTreeLeafIo;
import org.apache.ignite.internal.storage.pagememory.index.hash.io.HashIndexTreeMetaIo;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class HashIndexTree
extends BplusTree<HashIndexRowKey, HashIndexRow> {
    private final DataPageReader dataPageReader;
    private final int inlineSize;

    public HashIndexTree(int grpId, @Nullable String grpName, int partId, PageMemory pageMem, PageLockListener lockLsnr, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, HashIndexDescriptor indexDescriptor, boolean initNew) throws IgniteInternalCheckedException {
        super("HashIndexTree_" + grpId, grpId, grpName, partId, pageMem, lockLsnr, globalRmvId, metaPageId, reuseList);
        this.inlineSize = initNew ? InlineUtils.binaryTupleInlineSize(this.pageSize(), 42, (IndexDescriptor)indexDescriptor) : this.readInlineSizeFromMetaIo();
        this.setIos(HashIndexTreeInnerIo.VERSIONS.get(this.inlineSize), HashIndexTreeLeafIo.VERSIONS.get(this.inlineSize), HashIndexTreeMetaIo.VERSIONS);
        this.dataPageReader = new DataPageReader(pageMem, grpId, this.statisticsHolder());
        this.initTree(initNew);
        if (initNew) {
            this.writeInlineSizeToMetaIo(this.inlineSize);
        }
    }

    public int partitionId() {
        return this.partId;
    }

    public DataPageReader dataPageReader() {
        return this.dataPageReader;
    }

    protected int compare(BplusIo<HashIndexRowKey> io, long pageAddr, int idx, HashIndexRowKey row) throws IgniteInternalCheckedException {
        HashIndexTreeIo hashIndexTreeIo = (HashIndexTreeIo)io;
        return hashIndexTreeIo.compare(this.dataPageReader, this.partId, pageAddr, idx, row);
    }

    public HashIndexRow getRow(BplusIo<HashIndexRowKey> io, long pageAddr, int idx, Object x) throws IgniteInternalCheckedException {
        HashIndexTreeIo hashIndexTreeIo = (HashIndexTreeIo)io;
        return hashIndexTreeIo.getRow(this.dataPageReader, this.partId, pageAddr, idx);
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    private int readInlineSizeFromMetaIo() throws IgniteInternalCheckedException {
        Integer inlineSize = (Integer)this.read(this.metaPageId, (groupId, pageId, page, pageAddr, io, arg, intArg, statHolder) -> ((HashIndexTreeMetaIo)io).getInlineSize(pageAddr), null, 0, -1);
        assert (inlineSize != -1);
        return inlineSize;
    }

    private void writeInlineSizeToMetaIo(int inlineSize) throws IgniteInternalCheckedException {
        Boolean result = (Boolean)this.write(this.metaPageId, (groupId, pageId, page, pageAddr, io, arg, intArg, statHolder) -> {
            ((HashIndexTreeMetaIo)io).setInlineSize(pageAddr, inlineSize);
            return Boolean.TRUE;
        }, 0, Boolean.FALSE, this.statisticsHolder());
        assert (result == Boolean.TRUE) : result;
    }
}

