/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sql;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.sql.ResultSetImpl;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.sql.ResultSet;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.sql.reactive.ReactiveResultSet;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public interface Session
extends AutoCloseable {
    public static final String DEFAULT_SCHEMA = "PUBLIC";
    public static final int DEFAULT_PAGE_SIZE = 1024;

    default public ResultSet execute(@Nullable Transaction transaction, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        try {
            return new ResultSetImpl(this.executeAsync(transaction, query, arguments).join());
        }
        catch (CompletionException e) {
            throw IgniteException.wrap(e);
        }
    }

    default public ResultSet execute(@Nullable Transaction transaction, Statement statement, Object ... arguments) {
        Objects.requireNonNull(statement);
        try {
            return new ResultSetImpl(this.executeAsync(transaction, statement, arguments).join());
        }
        catch (CompletionException e) {
            throw IgniteException.wrap(e);
        }
    }

    public CompletableFuture<AsyncResultSet> executeAsync(@Nullable Transaction var1, String var2, Object ... var3);

    public CompletableFuture<AsyncResultSet> executeAsync(@Nullable Transaction var1, Statement var2, Object ... var3);

    public ReactiveResultSet executeReactive(@Nullable Transaction var1, String var2, Object ... var3);

    public ReactiveResultSet executeReactive(@Nullable Transaction var1, Statement var2, Object ... var3);

    default public long[] executeBatch(@Nullable Transaction transaction, String dmlQuery, BatchedArguments batch) {
        try {
            return this.executeBatchAsync(transaction, dmlQuery, batch).join();
        }
        catch (CompletionException e) {
            throw IgniteException.wrap(e);
        }
    }

    public long[] executeBatch(@Nullable Transaction var1, Statement var2, BatchedArguments var3);

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction var1, String var2, BatchedArguments var3);

    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction var1, Statement var2, BatchedArguments var3);

    public Flow.Publisher<Long> executeBatchReactive(@Nullable Transaction var1, String var2, BatchedArguments var3);

    public Flow.Publisher<Long> executeBatchReactive(@Nullable Transaction var1, Statement var2, BatchedArguments var3);

    public void executeScript(String var1, Object ... var2);

    public CompletableFuture<Void> executeScriptAsync(String var1, Object ... var2);

    public long defaultQueryTimeout(TimeUnit var1);

    public long idleTimeout(TimeUnit var1);

    public String defaultSchema();

    public int defaultPageSize();

    @Nullable
    public Object property(String var1);

    @Override
    public void close();

    public CompletableFuture<Void> closeAsync();

    public Flow.Publisher<Void> closeReactive();

    public SessionBuilder toBuilder();

    public static interface SessionBuilder {
        public long defaultQueryTimeout(TimeUnit var1);

        public SessionBuilder defaultQueryTimeout(long var1, TimeUnit var3);

        public long idleTimeout(TimeUnit var1);

        public SessionBuilder idleTimeout(long var1, TimeUnit var3);

        public String defaultSchema();

        public SessionBuilder defaultSchema(String var1);

        public int defaultPageSize();

        public SessionBuilder defaultPageSize(int var1);

        @Nullable
        public Object property(String var1);

        public SessionBuilder property(String var1, @Nullable Object var2);

        public Session build();
    }
}

