/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.pagememory.persistence.PageReadWriteManager;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreFactory;
import org.apache.ignite.internal.pagememory.persistence.store.GroupPageStoresMap;
import org.apache.ignite.internal.pagememory.persistence.store.LongOperationAsyncExecutor;
import org.apache.ignite.internal.pagememory.persistence.store.PageStore;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteStripedLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.jetbrains.annotations.Nullable;

public class FilePageStoreManager
implements PageReadWriteManager {
    public static final String FILE_SUFFIX = ".bin";
    public static final String TMP_FILE_SUFFIX = ".tmp";
    public static final String PART_FILE_PREFIX = "part-";
    public static final String PART_DELTA_FILE_PREFIX = "part-%d-delta-";
    public static final String PART_FILE_TEMPLATE = "part-%d.bin";
    public static final String PART_DELTA_FILE_TEMPLATE = "part-%d-delta-%d.bin";
    public static final String TMP_PART_DELTA_FILE_TEMPLATE = "part-%d-delta-%d.bin.tmp";
    public static final String GROUP_DIR_PREFIX = "table-";
    private final IgniteLogger log;
    private final Path dbDir;
    private final int pageSize;
    private final LongOperationAsyncExecutor cleanupAsyncExecutor;
    private final GroupPageStoresMap<FilePageStore> groupPageStores;
    private final IgniteStripedLock initGroupDirLock = new IgniteStripedLock(Math.max(Runtime.getRuntime().availableProcessors(), 8));
    private final FilePageStoreFactory filePageStoreFactory;

    public FilePageStoreManager(IgniteLogger log, String igniteInstanceName, Path storagePath, FileIoFactory filePageStoreFileIoFactory, int pageSize) throws IgniteInternalCheckedException {
        this.log = log;
        this.dbDir = storagePath.resolve("db");
        this.pageSize = pageSize;
        this.cleanupAsyncExecutor = new LongOperationAsyncExecutor(igniteInstanceName, log);
        this.groupPageStores = new GroupPageStoresMap(this.cleanupAsyncExecutor);
        this.filePageStoreFactory = new FilePageStoreFactory(filePageStoreFileIoFactory, pageSize);
    }

    public void start() throws IgniteInternalCheckedException {
        String tmpDir;
        try {
            Files.createDirectories(this.dbDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IgniteInternalCheckedException("Could not create work directory for page stores: " + this.dbDir, (Throwable)e);
        }
        if (this.log.isWarnEnabled() && (tmpDir = System.getProperty("java.io.tmpdir")) != null && this.dbDir.startsWith(tmpDir)) {
            this.log.warn("Persistence store directory is in the temp directory and may be cleaned. To avoid this change location of persistence directories [currentDir={}]", new Object[]{this.dbDir});
        }
        try (Stream<Path> tmpFileStream = Files.find(this.dbDir, Integer.MAX_VALUE, (path, basicFileAttributes) -> path.getFileName().toString().endsWith(TMP_FILE_SUFFIX), new FileVisitOption[0]);){
            List<Path> tmpFiles = tmpFileStream.collect(Collectors.toList());
            if (!tmpFiles.isEmpty()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Temporary files to be deleted: {}", new Object[]{tmpFiles.size()});
                }
                tmpFiles.forEach(IgniteUtils::deleteIfExists);
            }
        }
        catch (IOException e) {
            throw new IgniteInternalCheckedException("Could not create work directory for page stores: " + this.dbDir, (Throwable)e);
        }
    }

    public void stop() throws Exception {
        this.stopAllGroupFilePageStores(false);
        this.cleanupAsyncExecutor.awaitAsyncTaskCompletion(false);
    }

    @Override
    public void read(int grpId, long pageId, ByteBuffer pageBuf, boolean keepCrc) throws IgniteInternalCheckedException {
        FilePageStore pageStore = this.getStore(grpId, PageIdUtils.partitionId(pageId));
        pageStore.read(pageId, pageBuf, keepCrc);
    }

    @Override
    public PageStore write(int grpId, long pageId, ByteBuffer pageBuf, boolean calculateCrc) throws IgniteInternalCheckedException {
        FilePageStore pageStore = this.getStore(grpId, PageIdUtils.partitionId(pageId));
        pageStore.write(pageId, pageBuf, calculateCrc);
        return pageStore;
    }

    @Override
    public long allocatePage(int grpId, int partId, byte flags) throws IgniteInternalCheckedException {
        assert (partId >= 0 && partId <= 65500) : partId;
        FilePageStore pageStore = this.getStore(grpId, partId);
        int pageIdx = pageStore.allocatePage();
        return PageIdUtils.pageId(partId, flags, pageIdx);
    }

    public void initialize(String tableName, int tableId, int partitions) throws IgniteInternalCheckedException {
        assert (partitions > 0 && partitions < 65500) : partitions;
        this.initGroupDirLock.lock(tableId);
        try {
            if (!this.groupPageStores.containsPageStores(tableId)) {
                List<FilePageStore> partitionFilePageStores = this.createFilePageStores(tableId, partitions);
                List<FilePageStore> old = this.groupPageStores.put(tableId, partitionFilePageStores);
                assert (old == null) : tableName;
            }
        }
        catch (IgniteInternalCheckedException e) {
            throw e;
        }
        finally {
            this.initGroupDirLock.unlock(tableId);
        }
    }

    @Nullable
    public List<FilePageStore> getStores(int grpId) {
        return this.groupPageStores.get(grpId);
    }

    public Collection<List<FilePageStore>> allPageStores() {
        return this.groupPageStores.allPageStores();
    }

    public FilePageStore getStore(int grpId, int partId) throws IgniteInternalCheckedException {
        assert (partId >= 0 && partId <= 65500) : partId;
        List<FilePageStore> holder = this.groupPageStores.get(grpId);
        if (holder == null) {
            throw new IgniteInternalCheckedException("Failed to get file page store for the given group ID (group has not been started): " + grpId);
        }
        if (partId >= holder.size()) {
            throw new IgniteInternalCheckedException(String.format("Failed to get file page store for the given partition ID (partition has not been created) [grpId=%s, partId=%s]", grpId, partId));
        }
        return holder.get(partId);
    }

    void stopAllGroupFilePageStores(boolean cleanFiles) {
        List partitionPageStores = this.groupPageStores.allPageStores().stream().flatMap(Collection::stream).collect(Collectors.toList());
        this.groupPageStores.clear();
        Runnable stopPageStores = () -> {
            try {
                FilePageStoreManager.stopGroupFilePageStores(partitionPageStores, cleanFiles);
                this.log.info("Cleanup cache stores [total={}, cleanFiles={}]", new Object[]{partitionPageStores.size(), cleanFiles});
            }
            catch (Exception e) {
                this.log.info("Failed to gracefully stop page store managers", (Throwable)e);
            }
        };
        if (cleanFiles) {
            this.cleanupAsyncExecutor.async(stopPageStores, "file-page-stores-cleanup");
        } else {
            stopPageStores.run();
        }
    }

    private static void stopGroupFilePageStores(List<FilePageStore> partitionPageStores, boolean cleanFiles) throws IgniteInternalCheckedException {
        try {
            List closePageStores = partitionPageStores.stream().map(pageStore -> () -> pageStore.stop(cleanFiles)).collect(Collectors.toList());
            IgniteUtils.closeAll(closePageStores);
        }
        catch (IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteInternalCheckedException((Throwable)e);
        }
    }

    private Path ensureGroupWorkDir(int groupId) throws IgniteInternalCheckedException {
        Path groupWorkDir = this.dbDir.resolve(GROUP_DIR_PREFIX + groupId);
        try {
            Files.createDirectories(groupWorkDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IgniteInternalCheckedException("Failed to initialize group working directory (failed to create, make sure the work folder has correct permissions): " + groupWorkDir, (Throwable)e);
        }
        return groupWorkDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FilePageStore> createFilePageStores(int groupId, int partitions) throws IgniteInternalCheckedException {
        Path groupWorkDir = this.ensureGroupWorkDir(groupId);
        ArrayList<FilePageStore> partitionFilePageStores = new ArrayList<FilePageStore>(partitions);
        ByteBuffer buffer = GridUnsafe.allocateBuffer((int)this.pageSize);
        try {
            int i = 0;
            while (i < partitions) {
                int part = i++;
                Path partFilePath = groupWorkDir.resolve(String.format(PART_FILE_TEMPLATE, part));
                Path[] partDeltaFiles = this.findPartitionDeltaFiles(groupWorkDir, part);
                FilePageStore filePageStore = this.filePageStoreFactory.createPageStore(buffer.rewind(), partFilePath, partDeltaFiles);
                partitionFilePageStores.add(filePageStore);
            }
            List<FilePageStore> list = Collections.unmodifiableList(partitionFilePageStores);
            return list;
        }
        finally {
            GridUnsafe.freeBuffer((ByteBuffer)buffer);
        }
    }

    Path[] findPartitionDeltaFiles(Path groupWorkDir, int partition) throws IgniteInternalCheckedException {
        Path[] pathArray;
        block9: {
            assert (partition >= 0) : partition;
            String partitionDeltaFilePrefix = String.format(PART_DELTA_FILE_PREFIX, partition);
            Stream<Path> deltaFileStream = Files.find(groupWorkDir, 1, (path, basicFileAttributes) -> path.getFileName().toString().startsWith(partitionDeltaFilePrefix), new FileVisitOption[0]);
            try {
                pathArray = (Path[])deltaFileStream.toArray(Path[]::new);
                if (deltaFileStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (deltaFileStream != null) {
                        try {
                            deltaFileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IgniteInternalCheckedException(IgniteStringFormatter.format((String)"Error while searching delta partition files [groupDir={}, partition={}]", (Object[])new Object[]{groupWorkDir, partition}), (Throwable)e);
                }
            }
            deltaFileStream.close();
        }
        return pathArray;
    }

    public Path tmpDeltaFilePageStorePath(int groupId, int partitionId, int index) {
        return this.dbDir.resolve(GROUP_DIR_PREFIX + groupId).resolve(String.format(TMP_PART_DELTA_FILE_TEMPLATE, partitionId, index));
    }

    public Path deltaFilePageStorePath(int groupId, int partitionId, int index) {
        return this.dbDir.resolve(GROUP_DIR_PREFIX + groupId).resolve(String.format(PART_DELTA_FILE_TEMPLATE, partitionId, index));
    }
}

