/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.network;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite.internal.network.message.InvokeRequest;
import org.apache.ignite.internal.network.message.InvokeResponse;
import org.apache.ignite.internal.network.netty.ConnectionManager;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.serialization.ClassDescriptorRegistry;
import org.apache.ignite.internal.network.serialization.DescriptorRegistry;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.network.AbstractMessagingService;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NettyBootstrapFactory;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.NetworkMessageHandler;
import org.apache.ignite.network.OutNetworkObject;
import org.apache.ignite.network.TopologyService;
import org.jetbrains.annotations.Nullable;

public class DefaultMessagingService
extends AbstractMessagingService {
    private final NetworkMessagesFactory factory;
    private final TopologyService topologyService;
    private final UserObjectMarshaller marshaller;
    private final ClassDescriptorRegistry classDescriptorRegistry;
    private volatile ConnectionManager connectionManager;
    private InetSocketAddress localAddress;
    private final ConcurrentMap<Long, CompletableFuture<NetworkMessage>> requestsMap = new ConcurrentHashMap<Long, CompletableFuture<NetworkMessage>>();
    private final AtomicLong correlationIdGenerator = new AtomicLong();
    private static final String UNKNOWN_HOST = "unknown";
    private static final int UNKNOWN_HOST_PORT = 1337;
    private final ExecutorService outboundService = Executors.newSingleThreadExecutor();
    private final ExecutorService inboundService = Executors.newSingleThreadExecutor();

    public DefaultMessagingService(NetworkMessagesFactory factory, TopologyService topologyService, ClassDescriptorRegistry classDescriptorRegistry, UserObjectMarshaller marshaller) {
        this.factory = factory;
        this.topologyService = topologyService;
        this.classDescriptorRegistry = classDescriptorRegistry;
        this.marshaller = marshaller;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.localAddress = (InetSocketAddress)connectionManager.getLocalAddress();
        this.connectionManager = connectionManager;
        connectionManager.addListener(this::onMessage);
    }

    public void weakSend(ClusterNode recipient, NetworkMessage msg) {
        this.send(recipient, msg);
    }

    public CompletableFuture<Void> send(ClusterNode recipient, NetworkMessage msg) {
        return this.send0(recipient, recipient.address(), msg, null);
    }

    public CompletableFuture<Void> respond(ClusterNode recipient, NetworkMessage msg, long correlationId) {
        return this.send0(recipient, recipient.address(), msg, correlationId);
    }

    public CompletableFuture<Void> respond(NetworkAddress addr, NetworkMessage msg, long correlationId) {
        ClusterNode recipient = this.topologyService.getByAddress(addr);
        return this.send0(recipient, addr, msg, correlationId);
    }

    public CompletableFuture<NetworkMessage> invoke(ClusterNode recipient, NetworkMessage msg, long timeout) {
        return this.invoke0(recipient, recipient.address(), msg, timeout);
    }

    public CompletableFuture<NetworkMessage> invoke(NetworkAddress addr, NetworkMessage msg, long timeout) {
        ClusterNode recipient = this.topologyService.getByAddress(addr);
        return this.invoke0(recipient, addr, msg, timeout);
    }

    private CompletableFuture<Void> send0(@Nullable ClusterNode recipient, NetworkAddress address, NetworkMessage msg, @Nullable Long correlationId) {
        if (this.connectionManager.isStopped()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        InetSocketAddress addr = new InetSocketAddress(address.host(), address.port());
        if (this.isSelf(recipient, address.consistentId(), addr)) {
            if (correlationId != null) {
                this.onInvokeResponse(msg, correlationId);
            } else {
                this.sendToSelf(msg, null);
            }
            return CompletableFuture.completedFuture(null);
        }
        NetworkMessage message = correlationId != null ? this.responseFromMessage(msg, correlationId) : msg;
        String recipientConsistentId = recipient != null ? recipient.name() : address.consistentId();
        return this.sendMessage0(message, recipientConsistentId, addr);
    }

    private CompletableFuture<NetworkMessage> invoke0(@Nullable ClusterNode recipient, NetworkAddress addr, NetworkMessage msg, long timeout) {
        if (this.connectionManager.isStopped()) {
            return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
        }
        long correlationId = this.createCorrelationId();
        CompletableFuture<NetworkMessage> responseFuture = new CompletableFuture().orTimeout(timeout, TimeUnit.MILLISECONDS);
        this.requestsMap.put(correlationId, responseFuture);
        InetSocketAddress address = new InetSocketAddress(addr.host(), addr.port());
        if (this.isSelf(recipient, addr.consistentId(), address)) {
            this.sendToSelf(msg, correlationId);
            return responseFuture;
        }
        InvokeRequest message = this.requestFromMessage(msg, correlationId);
        String recipientConsistentId = recipient != null ? recipient.name() : addr.consistentId();
        return this.sendMessage0(message, recipientConsistentId, address).thenCompose(unused -> responseFuture);
    }

    private CompletableFuture<Void> sendMessage0(NetworkMessage message, String recipientConsistentId, InetSocketAddress addr) {
        List<ClassDescriptorMessage> descriptors;
        if (NettyBootstrapFactory.isInNetworkThread()) {
            return CompletableFuture.supplyAsync(() -> this.sendMessage0(message, recipientConsistentId, addr), this.outboundService).thenCompose(Function.identity());
        }
        try {
            descriptors = this.beforeRead(message);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture((Throwable)new IgniteException("Failed to marshal message: " + e.getMessage(), (Throwable)e));
        }
        return this.connectionManager.channel(recipientConsistentId, addr).thenComposeToCompletable(sender -> sender.send(new OutNetworkObject(message, descriptors)));
    }

    private List<ClassDescriptorMessage> beforeRead(NetworkMessage msg) throws Exception {
        IntOpenHashSet ids = new IntOpenHashSet();
        msg.prepareMarshal((IntSet)ids, (Object)this.marshaller);
        return PerSessionSerializationService.createClassDescriptorsMessages((IntSet)ids, this.classDescriptorRegistry);
    }

    private void sendToSelf(NetworkMessage msg, @Nullable Long correlationId) {
        NetworkAddress address = new NetworkAddress(this.localAddress.getHostName(), this.localAddress.getPort(), this.connectionManager.consistentId());
        for (NetworkMessageHandler networkMessageHandler : this.getMessageHandlers(msg.groupType())) {
            networkMessageHandler.onReceived(msg, address, correlationId);
        }
    }

    private void onMessage(InNetworkObject obj) {
        ClusterNode sender;
        if (NettyBootstrapFactory.isInNetworkThread()) {
            this.inboundService.submit(() -> this.onMessage(obj));
            return;
        }
        NetworkMessage msg = obj.message();
        DescriptorRegistry registry = obj.registry();
        String consistentId = obj.consistentId();
        try {
            msg.unmarshal((Object)this.marshaller, (Object)registry);
        }
        catch (Exception e) {
            throw new IgniteException("Failed to unmarshal message: " + e.getMessage(), (Throwable)e);
        }
        if (msg instanceof InvokeResponse) {
            InvokeResponse response = (InvokeResponse)msg;
            this.onInvokeResponse(response.message(), response.correlationId());
            return;
        }
        Long correlationId = null;
        NetworkMessage message = msg;
        if (msg instanceof InvokeRequest) {
            InvokeRequest messageWithCorrelation = (InvokeRequest)msg;
            correlationId = messageWithCorrelation.correlationId();
            message = messageWithCorrelation.message();
        }
        NetworkAddress senderAddress = (sender = this.topologyService.getByConsistentId(consistentId)) != null ? sender.address() : new NetworkAddress(UNKNOWN_HOST, 1337, consistentId);
        for (NetworkMessageHandler networkMessageHandler : this.getMessageHandlers(message.groupType())) {
            networkMessageHandler.onReceived(message, senderAddress, correlationId);
        }
    }

    private void onInvokeResponse(NetworkMessage response, Long correlationId) {
        CompletableFuture responseFuture = (CompletableFuture)this.requestsMap.remove(correlationId);
        if (responseFuture != null) {
            responseFuture.complete(response);
        }
    }

    private InvokeRequest requestFromMessage(NetworkMessage message, long correlationId) {
        return this.factory.invokeRequest().correlationId(correlationId).message(message).build();
    }

    private InvokeResponse responseFromMessage(NetworkMessage message, long correlationId) {
        return this.factory.invokeResponse().correlationId(correlationId).message(message).build();
    }

    private long createCorrelationId() {
        return this.correlationIdGenerator.getAndIncrement();
    }

    private boolean isSelf(@Nullable ClusterNode target, @Nullable String consistentId, SocketAddress targetSocketAddress) {
        String cid = consistentId;
        if (cid == null && target != null) {
            cid = target.name();
        }
        if (cid != null) {
            return this.connectionManager.consistentId().equals(cid);
        }
        if (Objects.equals(this.localAddress, targetSocketAddress)) {
            return true;
        }
        InetSocketAddress targetInetSocketAddress = (InetSocketAddress)targetSocketAddress;
        assert (!targetInetSocketAddress.getHostName().equals(UNKNOWN_HOST) && targetInetSocketAddress.getPort() != 1337);
        InetAddress targetInetAddress = targetInetSocketAddress.getAddress();
        if (targetInetAddress.isAnyLocalAddress() || targetInetAddress.isLoopbackAddress()) {
            return targetInetSocketAddress.getPort() == this.localAddress.getPort();
        }
        return false;
    }

    public void stop() {
        NodeStoppingException exception = new NodeStoppingException();
        this.requestsMap.values().forEach(fut -> fut.completeExceptionally((Throwable)exception));
        this.requestsMap.clear();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.inboundService, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.outboundService, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }
}

