/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.function.IntSupplier;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.apache.ignite.internal.schema.mapping.ColumnMapping;
import org.apache.ignite.internal.schema.registry.SchemaRegistrationConflictException;
import org.apache.ignite.internal.schema.registry.SchemaRegistryException;
import org.apache.ignite.internal.schema.registry.UpgradingRowAdapter;
import org.apache.ignite.internal.schema.row.Row;
import org.jetbrains.annotations.Nullable;

public class SchemaRegistryImpl
implements SchemaRegistry {
    private final ConcurrentNavigableMap<Integer, SchemaDescriptor> schemaCache = new ConcurrentSkipListMap<Integer, SchemaDescriptor>();
    private final Map<Long, ColumnMapper> mappingCache = new ConcurrentHashMap<Long, ColumnMapper>();
    private volatile int lastVer;
    private final Function<Integer, SchemaDescriptor> history;
    private final IntSupplier latestVersionStore;

    public SchemaRegistryImpl(Function<Integer, SchemaDescriptor> history, IntSupplier latestVersionStore, SchemaDescriptor initialSchema) {
        this.lastVer = initialSchema.version();
        this.history = history;
        this.latestVersionStore = latestVersionStore;
        this.schemaCache.put(initialSchema.version(), initialSchema);
    }

    @Override
    public SchemaDescriptor schema(int ver) {
        SchemaDescriptor desc;
        if (ver == 0) {
            ver = this.lastVer;
        }
        if ((desc = (SchemaDescriptor)this.schemaCache.get(ver)) != null) {
            return desc;
        }
        desc = this.history.apply(ver);
        if (desc != null) {
            this.schemaCache.putIfAbsent(ver, desc);
            return desc;
        }
        if (this.lastVer < ver || ver <= 0) {
            throw new SchemaRegistryException("Incorrect schema version requested: ver=" + ver);
        }
        throw new SchemaRegistryException("Failed to find schema: ver=" + ver);
    }

    @Override
    @Nullable
    public SchemaDescriptor schema() {
        int lastVer0 = this.lastVer;
        return this.schema(lastVer0);
    }

    @Override
    public SchemaDescriptor waitLatestSchema() {
        int lastVer0 = this.latestVersionStore.getAsInt();
        assert (this.lastVer <= lastVer0) : "Cached schema is earlier than consensus [lastVer=" + this.lastVer + ", consLastVer=" + lastVer0 + "]";
        return this.schema(lastVer0);
    }

    @Override
    public int lastSchemaVersion() {
        return this.lastVer;
    }

    @Override
    public Row resolve(BinaryRow row) {
        SchemaDescriptor curSchema = this.waitLatestSchema();
        return this.resolveInternal(row, curSchema);
    }

    @Override
    public Row resolve(BinaryRow row, SchemaDescriptor schemaDescriptor) {
        return this.resolveInternal(row, schemaDescriptor);
    }

    @Override
    public Collection<Row> resolve(Collection<BinaryRow> binaryRows) {
        SchemaDescriptor curSchema = this.waitLatestSchema();
        ArrayList<Row> rows = new ArrayList<Row>(binaryRows.size());
        for (BinaryRow r : binaryRows) {
            if (r == null) continue;
            rows.add(this.resolveInternal(r, curSchema));
        }
        return rows;
    }

    private Row resolveInternal(BinaryRow row, SchemaDescriptor curSchema) {
        if (curSchema == null) {
            throw new SchemaRegistryException("No schema found for the row: schemaVersion=" + row.schemaVersion());
        }
        if (row.schemaVersion() == 0 || curSchema.version() == row.schemaVersion()) {
            return new Row(curSchema, row);
        }
        SchemaDescriptor rowSchema = this.schema(row.schemaVersion());
        ColumnMapper mapping = this.resolveMapping(curSchema, rowSchema);
        return new UpgradingRowAdapter(curSchema, rowSchema, row, mapping);
    }

    ColumnMapper resolveMapping(SchemaDescriptor curSchema, SchemaDescriptor rowSchema) {
        assert (curSchema.version() > rowSchema.version());
        if (curSchema.version() == rowSchema.version() + 1) {
            return curSchema.columnMapping();
        }
        long mappingKey = (long)curSchema.version() << 32 | (long)rowSchema.version();
        ColumnMapper mapping = this.mappingCache.get(mappingKey);
        if (mapping != null) {
            return mapping;
        }
        mapping = this.schema(rowSchema.version() + 1).columnMapping();
        for (int i = rowSchema.version() + 2; i <= curSchema.version(); ++i) {
            mapping = ColumnMapping.mergeMapping(mapping, this.schema(i));
        }
        this.mappingCache.putIfAbsent(mappingKey, mapping);
        return mapping;
    }

    public void onSchemaRegistered(SchemaDescriptor desc) {
        if (desc.version() != this.lastVer + 1) {
            if (desc.version() > 0 && desc.version() <= this.lastVer) {
                throw new SchemaRegistrationConflictException("Schema with given version has been already registered: " + desc.version());
            }
            throw new SchemaRegistryException("Try to register schema of wrong version: ver=" + desc.version() + ", lastVer=" + this.lastVer);
        }
        this.schemaCache.put(desc.version(), desc);
        this.lastVer = desc.version();
    }

    public void onSchemaDropped(int ver) {
        if (ver >= this.lastVer || ver <= 0 || (Integer)this.schemaCache.keySet().first() < ver) {
            throw new SchemaRegistryException("Incorrect schema version to clean up to: " + ver);
        }
        if (this.schemaCache.remove(ver) != null) {
            this.mappingCache.keySet().removeIf(k -> (k & 0xFFFFFFFFL) == (long)ver);
        }
    }

    Map<Long, ColumnMapper> mappingCache() {
        return this.mappingCache;
    }
}

